/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.viewers;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SWTUtils {
    protected static final int lower2Upper = -32;
    protected static final int upper2lower = 32;

    public static int toLowerLetter(int letterChar) {
        if (letterChar >= 65 && letterChar <= 90) {
            return letterChar + 32;
        }
        return letterChar;
    }

    public static boolean equalsIgnoreCase(int char1, int char2) {
        return SWTUtils.toLowerLetter(char1) == SWTUtils.toLowerLetter(char2);
    }

    public static boolean matchKey(int stateMask, int keyCode, int expectedState, int expectedKeyCode) {
        return SWTUtils.matchState(stateMask, expectedState) && SWTUtils.matchKeyCode(keyCode, expectedKeyCode);
    }

    public static boolean matchState(int stateMask, int expectedState) {
        if (expectedState != 0 && (stateMask & expectedState) == 0) {
            return false;
        }
        int unexpectedState = ~expectedState;
        return (stateMask & unexpectedState) == 0;
    }

    public static boolean matchKeyCode(int keyCode, int expectedKeyCode) {
        if (expectedKeyCode == 13 || expectedKeyCode == 0x1000050) {
            return keyCode == 13 || keyCode == 0x1000050;
        }
        if (expectedKeyCode == 43 || expectedKeyCode == 16777259) {
            return keyCode == 43 || keyCode == 16777259;
        }
        if (expectedKeyCode == 45 || expectedKeyCode == 16777261) {
            return keyCode == 45 || keyCode == 16777261;
        }
        return SWTUtils.equalsIgnoreCase(keyCode, expectedKeyCode);
    }

    public static boolean isModifierKey(int stateMask, int keyCode) {
        return stateMask == 0 && (keyCode == SWT.MOD1 || keyCode == SWT.MOD2 || keyCode == SWT.MOD3 || keyCode == SWT.MOD4);
    }

    public static Path addRoundedRectangle(Path path, float x, float y, float width, float height, float corner) {
        float r = x + width;
        float b = y + height;
        float x0 = x + width / 2.0f;
        float y0 = y + height / 2.0f;
        float y1 = Math.min(y + corner, y0);
        path.moveTo(x, y1);
        float x1 = Math.min(x + corner, x0);
        float cx1 = x + (x1 - x) / 4.0f;
        float cy1 = y + (y1 - y) / 4.0f;
        path.cubicTo(x, cy1, cx1, y, x1, y);
        float x2 = Math.max(r - corner, x0);
        path.lineTo(x2, y);
        float cx2 = r - (r - x2) / 4.0f;
        path.cubicTo(cx2, y, r, cy1, r, y1);
        float y2 = Math.max(b - corner, y0);
        path.lineTo(r, y2);
        float cy2 = b - (b - y2) / 4.0f;
        path.cubicTo(r, cy2, cx2, b, x2, b);
        path.lineTo(x1, b);
        path.cubicTo(cx1, b, x, cy2, x, y2);
        path.close();
        return path;
    }

    public static void makeNumeralInput(Control inputControl, final boolean minusPermitted, final boolean dotPermitted) {
        inputControl.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.character < ' ' || event.character > '~') {
                    event.doit = true;
                    return;
                }
                event.doit = event.character >= '0' && event.character <= '9' || minusPermitted && event.character == '-' ? true : event.character == '.' && dotPermitted;
            }
        });
    }
}

