/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.richtext;

import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.xmind.ui.richtext.IRichDocument;
import org.xmind.ui.richtext.IRichTextActionBarContributor;
import org.xmind.ui.richtext.IRichTextEditViewer;
import org.xmind.ui.richtext.IRichTextRenderer;
import org.xmind.ui.richtext.RichTextDamagerRepairer;
import org.xmind.ui.richtext.RichTextRenderer;
import org.xmind.ui.richtext.RichTextScanner;
import org.xmind.ui.richtext.RichTextViewerUndoManager;

public class RichTextEditViewer
implements IRichTextEditViewer {
    private IRichDocument document;
    private Composite control;
    private TextViewer textViewer;
    private boolean editable;
    private IRichTextRenderer renderer;
    private IRichTextActionBarContributor contributor;
    private ToolBarManager toolBarManager = null;

    public RichTextEditViewer(Composite parent) {
        this(parent, 834, null);
    }

    public RichTextEditViewer(Composite parent, IRichTextActionBarContributor contributor) {
        this(parent, 834, contributor);
    }

    public RichTextEditViewer(Composite parent, int textControlStyle) {
        this(parent, textControlStyle, null);
    }

    public RichTextEditViewer(Composite parent, int textControlStyle, IRichTextActionBarContributor contributor) {
        this.contributor = contributor;
        this.editable = (textControlStyle & 8) == 0;
        this.control = this.createControl(parent, textControlStyle);
    }

    protected Composite createControl(Composite parent, int textControlStyle) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.createContentArea(composite, textControlStyle);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RichTextEditViewer.this.handleControlDispose(e);
            }
        });
        composite.setBackground(this.textViewer.getControl().getBackground());
        return composite;
    }

    protected void createContentArea(Composite parent, int textControlStyle) {
        Control toolBar = this.createToolBar(parent);
        if (toolBar != null) {
            this.createSeparator(parent);
        }
        this.createTextControl(parent, textControlStyle);
    }

    protected Control createToolBar(Composite parent) {
        if (this.contributor == null) {
            return null;
        }
        this.contributor.init(this);
        this.toolBarManager = new ToolBarManager(0x800000);
        this.contributor.fillToolBar((IToolBarManager)this.toolBarManager);
        parent.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                RichTextEditViewer.this.toolBarManager.update(true);
            }
        });
        ToolBar toolBar = this.toolBarManager.createControl(parent);
        toolBar.setLayoutData((Object)new GridData(768));
        return toolBar;
    }

    protected void createSeparator(Composite parent) {
        Label sep = new Label(parent, 258);
        sep.setLayoutData((Object)new GridData(768));
    }

    protected Control createTextControl(Composite parent, int style) {
        this.textViewer = this.createTextViewer(parent, style);
        this.initTextViewer(this.textViewer);
        this.renderer = this.createRenderer(this.textViewer);
        Control textControl = this.textViewer.getControl();
        GridData gridData = new GridData(1808);
        gridData.heightHint = 160;
        gridData.horizontalIndent = 2;
        gridData.verticalIndent = 2;
        textControl.setLayoutData((Object)gridData);
        return textControl;
    }

    protected TextViewer createTextViewer(Composite parent, int style) {
        return new LessLatencyTextViewer(parent, style);
    }

    protected RichTextRenderer createRenderer(TextViewer textViewer) {
        return new RichTextRenderer(textViewer);
    }

    private void initTextViewer(TextViewer textViewer) {
        textViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RichTextEditViewer.this.updateToolBar(event.getSelection());
            }
        });
        textViewer.setTextDoubleClickStrategy((ITextDoubleClickStrategy)new DefaultTextDoubleClickStrategy(), "__dftl_partition_content_type");
        textViewer.setUndoManager((IUndoManager)new RichTextViewerUndoManager(25));
        textViewer.activatePlugins();
        this.addHyperlinkListener(textViewer);
    }

    private void addHyperlinkListener(TextViewer viewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        RichTextDamagerRepairer dr = new RichTextDamagerRepairer(new RichTextScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDocumentPartitioning("__dftl_partitioning");
        reconciler.install((ITextViewer)viewer);
    }

    protected void handleControlDispose(DisposeEvent e) {
        if (this.contributor != null) {
            this.contributor.dispose();
        }
        if (this.toolBarManager != null) {
            this.toolBarManager.dispose();
            this.toolBarManager = null;
        }
        if (this.document != null) {
            this.unhookDocument(this.document);
            this.document = null;
        }
    }

    public Control getControl() {
        return this.control;
    }

    public Control getFocusControl() {
        return this.textViewer.getControl();
    }

    public IRichDocument getDocument() {
        return this.document;
    }

    public TextViewer getTextViewer() {
        return this.textViewer;
    }

    protected void hookDocument(IRichDocument document) {
    }

    protected void unhookDocument(IRichDocument document) {
    }

    public Object getInput() {
        return this.document;
    }

    public void refresh() {
        this.updateToolBar(this.getSelection());
        this.updateTextControl();
    }

    public IRichTextActionBarContributor getContributor() {
        return this.contributor;
    }

    private boolean isViewerEditable() {
        return this.document != null && this.isEditable();
    }

    private void updateToolBar(ISelection selection) {
        if (this.toolBarManager == null) {
            return;
        }
        ToolBar toolbar = this.toolBarManager.getControl();
        if (toolbar != null && !toolbar.isDisposed()) {
            toolbar.setEnabled(this.isViewerEditable());
        }
        if (this.contributor != null) {
            this.contributor.selectionChanged(selection, this.isViewerEditable());
        }
        this.toolBarManager.update(false);
    }

    protected void updateTextControl() {
        this.textViewer.setEditable(this.isViewerEditable());
        if (this.document != null) {
            this.textViewer.getTextWidget().setEnabled(true);
        } else {
            this.textViewer.getTextWidget().setEnabled(false);
        }
    }

    public void setInput(Object input) {
        if (input instanceof IRichDocument) {
            this.setDocument((IRichDocument)input);
        } else {
            this.setDocument(null);
        }
    }

    public void setDocument(IRichDocument document) {
        IRichDocument oldDocument = this.document;
        this.document = document;
        this.documentChanged(document, oldDocument);
        this.textViewer.setDocument((IDocument)(document == null ? new Document() : document));
        this.refresh();
        if (document != null) {
            this.textViewer.setSelectedRange(document.getLength(), 0);
        }
    }

    protected void documentChanged(IRichDocument newDocument, IRichDocument oldDocument) {
        if (newDocument != oldDocument) {
            if (oldDocument != null) {
                this.unhookDocument(oldDocument);
            }
            if (newDocument != null) {
                this.hookDocument(newDocument);
            }
        }
    }

    public IRichTextRenderer getRenderer() {
        return this.renderer;
    }

    public ISelection getSelection() {
        return this.textViewer.getSelection();
    }

    public Point getSelectedRange() {
        return this.textViewer.getSelectedRange();
    }

    public void setSelection(ISelection selection) {
        this.textViewer.setSelection(selection);
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.textViewer.setSelection(selection, reveal);
    }

    public void setSelectedRange(int selectionOffset, int selectionLength) {
        this.textViewer.setSelectedRange(selectionOffset, selectionLength);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.textViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.textViewer.removeSelectionChangedListener(listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.textViewer.addPostSelectionChangedListener(listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.textViewer.removePostSelectionChangedListener(listener);
    }

    public void addTextInputListener(ITextInputListener listener) {
        this.textViewer.addTextInputListener(listener);
    }

    public void addTextListener(ITextListener listener) {
        this.textViewer.addTextListener(listener);
    }

    public void removeTextInputListener(ITextInputListener listener) {
        this.textViewer.removeTextInputListener(listener);
    }

    public void removeTextListener(ITextListener listener) {
        this.textViewer.removeTextListener(listener);
    }

    public boolean isSelectedRangeEmpty() {
        Point p = this.getSelectedRange();
        return p.y <= 0;
    }

    public StyledText getTextWidget() {
        return this.textViewer.getTextWidget();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        if (editable == this.editable) {
            return;
        }
        this.editable = editable;
        this.refresh();
    }

    private static class LessLatencyTextViewer
    extends TextViewer {
        private LessLatencyTextViewer(Composite parent, int styles) {
            super(parent, styles);
        }

        protected int getEmptySelectionChangedEventDelay() {
            return 100;
        }
    }
}

