/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.richtext;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.xmind.ui.font.FontDialog;
import org.xmind.ui.font.IFontChooser;
import org.xmind.ui.font.IFontChooserListener;
import org.xmind.ui.internal.ToolkitImages;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.richtext.IRichTextAction;
import org.xmind.ui.richtext.IRichTextEditViewer;
import org.xmind.ui.richtext.IRichTextRenderer;
import org.xmind.ui.richtext.RichTextMessages;
import org.xmind.ui.richtext.RichTextUtils;

public class FontAction
extends Action
implements IRichTextAction {
    private IRichTextEditViewer viewer;

    public FontAction(IRichTextEditViewer viewer) {
        this(viewer, RichTextMessages.FontAction_text, ToolkitImages.get("font.gif"), RichTextMessages.FontAction_toolTip);
    }

    public FontAction(IRichTextEditViewer viewer, String text, ImageDescriptor image, String tooltip) {
        super(text, 2);
        this.viewer = viewer;
        this.setImageDescriptor(image);
        this.setToolTipText(tooltip);
    }

    public void dispose() {
        this.viewer = null;
    }

    public void selctionChanged(IRichTextEditViewer viewer, ISelection selection) {
    }

    public void run() {
        if (this.viewer == null || this.viewer.getControl().isDisposed()) {
            return;
        }
        IRichTextRenderer renderer = this.viewer.getRenderer();
        Font selectionFont = renderer.getSelectionFont();
        Color selectionForeground = renderer.getSelectionForeground();
        final Color selectionBackground = renderer.getSelectionBackground();
        boolean selectionBold = renderer.getSelectionFontBold();
        boolean selectionItalic = renderer.getSelectionFontItalic();
        boolean selectionUnderline = renderer.getSelectionFontUnderline();
        boolean selectionStrikeout = renderer.getSelectionFontStrikeout();
        FontDialog dialog = new FontDialog(this.viewer.getControl().getShell());
        if (selectionFont != null) {
            dialog.setInitialFont(selectionFont.getFontData()[0]);
        } else {
            dialog.setInitialFont(RichTextUtils.DEFAULT_FONT_DATA);
        }
        if (selectionForeground != null) {
            dialog.setColor(selectionForeground.getRGB());
        }
        if (selectionBold) {
            dialog.setBold(selectionBold);
        }
        if (selectionItalic) {
            dialog.setItalic(selectionItalic);
        }
        if (selectionStrikeout) {
            dialog.setStrikeout(selectionStrikeout);
        }
        if (selectionUnderline) {
            dialog.setUnderline(selectionUnderline);
        }
        final StyledText textWidget = this.viewer.getTextViewer().getTextWidget();
        Point sel = textWidget.getSelectionRange();
        final int start = sel.x;
        final int length = sel.y;
        StyleRange[] oldStyles = textWidget.getStyleRanges(start, length);
        dialog.addFontChooserListener(new IFontChooserListener(){

            public void fontChanged(IFontChooser source) {
                String fontName = source.getFontName();
                int fontHeight = source.getFontHeight();
                boolean bold = source.getBold();
                boolean italic = source.getItalic();
                boolean strikeout = source.getStrikeout();
                boolean underline = source.getUnderline();
                Color foreground = ColorUtils.getColor(source.getColor());
                StyleRange sr = new StyleRange(start, length, foreground, selectionBackground);
                sr.font = FontUtils.getFont(fontName, fontHeight, bold, italic);
                sr.strikeout = strikeout;
                sr.underline = underline;
                textWidget.replaceStyleRanges(start, length, new StyleRange[]{sr});
            }
        });
        int ret = dialog.open();
        textWidget.setRedraw(false);
        textWidget.replaceStyleRanges(start, length, oldStyles);
        if (ret == 0) {
            String fontName = dialog.getFontName();
            int fontHeight = dialog.getFontHeight();
            boolean bold = dialog.getBold();
            boolean italic = dialog.getItalic();
            boolean strikeout = dialog.getStrikeout();
            boolean underline = dialog.getUnderline();
            Color foreground = ColorUtils.getColor(dialog.getColor());
            renderer.setSelectionFont(FontUtils.getFont(fontName, fontHeight, bold, italic));
            renderer.setSelectionForeground(foreground);
            renderer.setSelectionBackground(selectionBackground);
            renderer.setSelectionFontUnderline(underline);
            renderer.setSelectionFontStrikeout(strikeout);
        }
        textWidget.setRedraw(true);
        this.setChecked(false);
    }
}

