/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.io;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.xmind.ui.io.StreamInterruptedException;

public class MonitoredOutputStream
extends OutputStream {
    private OutputStream realStream;
    private IProgressMonitor monitor;

    public MonitoredOutputStream(OutputStream realStream, IProgressMonitor monitor) {
        this.realStream = realStream;
        this.monitor = monitor;
    }

    private void closeRealStream() {
        try {
            this.realStream.close();
        }
        catch (IOException iOException) {}
    }

    public void close() throws IOException {
        this.realStream.close();
    }

    public void flush() throws IOException {
        if (this.monitor.isCanceled()) {
            this.closeRealStream();
            throw new StreamInterruptedException();
        }
        this.realStream.flush();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.monitor.isCanceled()) {
            this.closeRealStream();
            throw new StreamInterruptedException();
        }
        this.realStream.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        if (this.monitor.isCanceled()) {
            this.closeRealStream();
            throw new StreamInterruptedException();
        }
        this.realStream.write(b);
    }

    public void write(int b) throws IOException {
        if (this.monitor.isCanceled()) {
            this.closeRealStream();
            throw new StreamInterruptedException();
        }
        this.realStream.write(b);
    }
}

