/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.font;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.xmind.ui.color.ColorSelection;
import org.xmind.ui.color.IColorSelection;
import org.xmind.ui.color.PaletteContents;
import org.xmind.ui.color.PaletteItem;
import org.xmind.ui.color.PaletteViewer;
import org.xmind.ui.font.IFontChooser;
import org.xmind.ui.font.IFontChooserListener;
import org.xmind.ui.font.Messages;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.viewers.ISliderContentProvider;
import org.xmind.ui.viewers.SliderViewer;

public class FontDialog
extends Dialog
implements IFontChooser {
    private static final boolean CARBON = "carbon".equals(SWT.getPlatform());
    private static final int DEFAULT_GROUP_WIDTH = -1;
    private static final int DEFAULT_GROUP_HEIGHT = CARBON ? 200 : 185;
    private static final int MIN_FONT_HEIGHT = 5;
    private static final int MAX_FONT_HEIGHT = 72;
    private static String DEFAULT_FONT_NAME = null;
    private static int DEFAULT_FONT_HEIGHT = -1;
    private static PaletteContents DEFAULT_PALLETE = null;
    private String fontName = null;
    private int fontHeight = -1;
    private RGB color = null;
    private boolean bold = false;
    private boolean italic = false;
    private boolean underline = false;
    private boolean strikeout = false;
    private FilteredTree fontTree = null;
    private Text sizeText = null;
    private ListViewer sizeList = null;
    private SliderViewer sizeScale = null;
    private Button boldButton = null;
    private Button italicButton = null;
    private Button underlineButton = null;
    private Button strikeoutButton = null;
    private PaletteViewer paletteViewer = null;
    private List<IFontChooserListener> fontDialogListeners = null;
    private boolean sizeChangedByText = false;

    public FontDialog(Shell parent) {
        super(parent);
        this.setShellStyle(67680);
    }

    protected Control createDialogArea(Composite parent) {
        Composite p = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).margins(5, 5).applyTo(p);
        Group fontGroup = new Group(p, 0);
        fontGroup.setText(Messages.FamilyGroup_text);
        GridLayoutFactory.swtDefaults().applyTo((Composite)fontGroup);
        GridDataFactory.fillDefaults().hint(-1, DEFAULT_GROUP_HEIGHT).applyTo((Control)fontGroup);
        this.createFontControl(fontGroup);
        Group sizeGroup = new Group(p, 0);
        sizeGroup.setText(Messages.HeightGroup_text);
        GridDataFactory.fillDefaults().hint(-1, DEFAULT_GROUP_HEIGHT).applyTo((Control)sizeGroup);
        this.createSizeControl(sizeGroup);
        Composite typeComposite = new Composite(p, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo(typeComposite);
        GridDataFactory.fillDefaults().hint(-1, DEFAULT_GROUP_HEIGHT).applyTo((Control)typeComposite);
        Group typeGroup = new Group(typeComposite, 0);
        typeGroup.setText(Messages.TypeGroup_text);
        GridLayoutFactory.swtDefaults().applyTo((Composite)typeGroup);
        GridDataFactory.fillDefaults().applyTo((Control)typeGroup);
        this.createTypeControl(typeGroup);
        Group colorGroup = new Group(typeComposite, 0);
        colorGroup.setText(Messages.ColorGroup_text);
        GridLayoutFactory.swtDefaults().applyTo((Composite)colorGroup);
        GridDataFactory.fillDefaults().applyTo((Control)colorGroup);
        this.createColorControl(colorGroup);
        return p;
    }

    private void createColorControl(Group parent) {
        this.paletteViewer = new PaletteViewer();
        this.paletteViewer.createControl((Composite)parent);
        this.paletteViewer.setInput(this.getPaletteContents());
        if (this.getColor() != null) {
            this.paletteViewer.setSelection(new ColorSelection(this.getColor()));
        }
        this.paletteViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IColorSelection) {
                    FontDialog.this.setColor(((IColorSelection)selection).getColor());
                } else {
                    FontDialog.this.setColor(null);
                }
                FontDialog.this.fireFontChanged();
            }
        });
        this.paletteViewer.getControl().setBackground(parent.getBackground());
    }

    protected PaletteContents getPaletteContents() {
        return FontDialog.getDefaultPaletteContents();
    }

    private static PaletteContents getDefaultPaletteContents() {
        if (DEFAULT_PALLETE == null) {
            PaletteContents paletteContent = new PaletteContents(15, 3, 5);
            paletteContent.addItem(PaletteItem.Red);
            paletteContent.addItem(PaletteItem.Orange);
            paletteContent.addItem(PaletteItem.Lemon);
            paletteContent.addItem(PaletteItem.LimeGreen);
            paletteContent.addItem(PaletteItem.Blue);
            paletteContent.addItem(PaletteItem.Turquoise);
            paletteContent.addItem(PaletteItem.Purple);
            paletteContent.addItem(PaletteItem.Rose);
            paletteContent.addItem(PaletteItem.Lavender);
            paletteContent.addItem(PaletteItem.Violet);
            paletteContent.addItem(PaletteItem.Black);
            paletteContent.addItem(PaletteItem.DarkGray);
            paletteContent.addItem(PaletteItem.Gray);
            paletteContent.addItem(PaletteItem.LightGray);
            paletteContent.addItem(PaletteItem.White);
            DEFAULT_PALLETE = paletteContent;
        }
        return DEFAULT_PALLETE;
    }

    private void createTypeControl(Group parent) {
        this.boldButton = new Button((Composite)parent, 32);
        this.boldButton.setText(Messages.BoldButton_text);
        this.boldButton.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        this.boldButton.setSelection(this.getBold());
        this.italicButton = new Button((Composite)parent, 32);
        this.italicButton.setText(Messages.ItalicButton_text);
        this.italicButton.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
        this.italicButton.setSelection(this.getItalic());
        this.underlineButton = new Button((Composite)parent, 32);
        this.underlineButton.setText(Messages.UnderlineButton_text);
        this.underlineButton.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.drawLine(e.x + 20, e.y + e.height - 4, e.x + e.width, e.y + e.height - 4);
            }
        });
        this.underlineButton.setSelection(this.getUnderline());
        this.strikeoutButton = new Button((Composite)parent, 32);
        this.strikeoutButton.setText(Messages.StrikeoutButton_text);
        this.strikeoutButton.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.drawLine(e.x + 20, e.y + e.height / 2, e.x + e.width, e.y + e.height / 2);
            }
        });
        this.strikeoutButton.setSelection(this.getStrikeout());
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                FontDialog.this.setBold(FontDialog.this.boldButton.getSelection());
                FontDialog.this.setItalic(FontDialog.this.italicButton.getSelection());
                FontDialog.this.setUnderline(FontDialog.this.underlineButton.getSelection());
                FontDialog.this.setStrikeout(FontDialog.this.strikeoutButton.getSelection());
                FontDialog.this.fireFontChanged();
            }
        };
        this.boldButton.addListener(13, listener);
        this.italicButton.addListener(13, listener);
        this.underlineButton.addListener(13, listener);
        this.strikeoutButton.addListener(13, listener);
    }

    private void createSizeControl(Group parent) {
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).applyTo((Composite)parent);
        SizeControlListener listener = new SizeControlListener();
        this.sizeText = new Text((Composite)parent, 0x1000800);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.sizeText);
        this.sizeText.addModifyListener((ModifyListener)listener);
        this.sizeList = new ListViewer((Composite)parent, 2564);
        this.sizeList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.sizeList.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.sizeList.setInput(Arrays.asList(8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 36, 48, 56, 64, 72));
        int listWidthHint = CARBON ? -1 : 40;
        GridDataFactory.fillDefaults().grab(false, true).hint(listWidthHint, -1).applyTo(this.sizeList.getControl());
        this.sizeScale = new SliderViewer((Composite)parent, 512);
        int scaleWidthHint = CARBON ? -1 : 20;
        GridDataFactory.fillDefaults().grab(false, true).hint(scaleWidthHint, -1).applyTo(this.sizeScale.getControl());
        this.sizeScale.setContentProvider(new ISliderContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getValues(Object input) {
                return new Integer[]{5, 72};
            }

            public Object getValue(Object input, double portion) {
                int value = (int)Math.round(67.0 * portion + 5.0);
                return value;
            }

            public double getPortion(Object input, Object value) {
                int v = (Integer)value;
                return (double)(v - 5) * 1.0 / 67.0;
            }
        });
        this.sizeList.addSelectionChangedListener((ISelectionChangedListener)listener);
        this.sizeScale.addSelectionChangedListener(listener);
        this.setFontHeight(this.getFontHeight());
    }

    private void createFontControl(Group parent) {
        this.fontTree = new FilteredTree((Composite)parent, 65536, new PatternFilter());
        this.fontTree.setEnabled(false);
        this.fontTree.getViewer().setContentProvider((IContentProvider)new TreeArrayContentProvider());
        FontUtils.fetchAvailableFontNames(parent.getDisplay(), new FontUtils.IFontNameListCallback(){

            @Override
            public void setAvailableFontNames(List<String> fontNames) {
                if (FontDialog.this.fontTree.isDisposed()) {
                    return;
                }
                FontDialog.this.fontTree.setEnabled(true);
                FontDialog.this.fontTree.getViewer().setInput(fontNames);
                FontDialog.this.setFontName(FontDialog.this.getFontName());
                FontDialog.this.fontTree.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                        if (sel.isEmpty()) {
                            FontDialog.this.setFontName(null);
                        } else {
                            FontDialog.this.setFontName((String)sel.getFirstElement());
                        }
                        FontDialog.this.fireFontChanged();
                    }
                });
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).hint(150, -1).applyTo((Control)this.fontTree);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.FontDialog_text);
    }

    protected Point getInitialLocation(Point initialSize) {
        Rectangle r = this.getParentShell().getBounds();
        return new Point(r.x + r.width - initialSize.x, r.y + r.height - initialSize.y);
    }

    public void addFontChooserListener(IFontChooserListener listener) {
        if (this.fontDialogListeners == null) {
            this.fontDialogListeners = new ArrayList<IFontChooserListener>();
        }
        this.fontDialogListeners.add(listener);
    }

    public void removeFontChooserListener(IFontChooserListener listener) {
        if (this.fontDialogListeners == null) {
            return;
        }
        this.fontDialogListeners.remove(listener);
    }

    protected void fireFontChanged() {
        if (this.fontDialogListeners == null) {
            return;
        }
        Object[] objectArray = this.fontDialogListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object l = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IFontChooserListener)l).fontChanged(FontDialog.this);
                }
            });
            ++n2;
        }
    }

    public RGB getColor() {
        return this.color;
    }

    public void setColor(RGB color) {
        this.color = color;
        if (this.paletteViewer != null && !this.paletteViewer.getControl().isDisposed()) {
            if (color == null) {
                this.paletteViewer.setSelection(ColorSelection.EMPTY);
            } else {
                this.paletteViewer.setSelection(new ColorSelection(color));
            }
        }
    }

    public boolean getBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
        if (this.boldButton != null && !this.boldButton.isDisposed()) {
            this.boldButton.setSelection(bold);
        }
    }

    public boolean getItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
        if (this.italicButton != null && !this.italicButton.isDisposed()) {
            this.italicButton.setSelection(italic);
        }
    }

    public boolean getUnderline() {
        return this.underline;
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
        if (this.underlineButton != null && !this.underlineButton.isDisposed()) {
            this.underlineButton.setSelection(underline);
        }
    }

    public boolean getStrikeout() {
        return this.strikeout;
    }

    public void setStrikeout(boolean strikeout) {
        this.strikeout = strikeout;
        if (this.strikeoutButton != null && !this.strikeoutButton.isDisposed()) {
            this.strikeoutButton.setSelection(strikeout);
        }
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        if (fontName == null) {
            fontName = FontDialog.getDefaultFontName();
        }
        this.fontName = fontName;
        if (this.fontTree != null && !this.fontTree.isDisposed() && this.fontTree.isEnabled()) {
            this.fontTree.setInitialText(fontName);
        }
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public void setFontHeight(int fontHeight) {
        if (fontHeight < 0) {
            fontHeight = FontDialog.getDefaultFontHeight();
        }
        this.fontHeight = fontHeight;
        if (this.sizeText != null && !this.sizeText.isDisposed() && !this.sizeChangedByText) {
            int position = -1;
            if (this.sizeText.isFocusControl()) {
                position = this.sizeText.getSelection().x;
            }
            this.sizeText.setText(Integer.toString(fontHeight));
            if (position >= 0) {
                this.sizeText.setSelection(Math.min(position, this.sizeText.getText().length()));
            }
        }
        if (this.sizeList != null && !this.sizeList.getControl().isDisposed()) {
            this.sizeList.setSelection((ISelection)new StructuredSelection((Object)fontHeight), true);
        }
        if (this.sizeScale != null && !this.sizeScale.getControl().isDisposed()) {
            this.sizeScale.setSelection((ISelection)new StructuredSelection((Object)fontHeight), true);
        }
    }

    protected static String getDefaultFontName() {
        if (DEFAULT_FONT_NAME == null) {
            DEFAULT_FONT_NAME = JFaceResources.getDefaultFont().getFontData()[0].getName();
        }
        return DEFAULT_FONT_NAME;
    }

    protected static int getDefaultFontHeight() {
        if (DEFAULT_FONT_HEIGHT < 0) {
            DEFAULT_FONT_HEIGHT = JFaceResources.getDefaultFont().getFontData()[0].getHeight();
        }
        return DEFAULT_FONT_HEIGHT;
    }

    public void setInitialFont(FontData fd) {
        this.setFontName(fd.getName());
        this.setFontHeight(fd.getHeight());
        this.setBold((fd.getStyle() & 1) != 0);
        this.setItalic((fd.getStyle() & 2) != 0);
    }

    private class SizeControlListener
    implements ModifyListener,
    ISelectionChangedListener {
        private boolean synchronizingSelection = false;

        private SizeControlListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (this.synchronizingSelection) {
                return;
            }
            IStructuredSelection ss = (IStructuredSelection)event.getSelection();
            Object o = ss.getFirstElement();
            if (o instanceof Integer) {
                int v = (Integer)o;
                this.synchronizingSelection = true;
                FontDialog.this.setFontHeight(v);
                this.synchronizingSelection = false;
                FontDialog.this.fireFontChanged();
            }
        }

        public void modifyText(ModifyEvent e) {
            int height;
            if (this.synchronizingSelection) {
                return;
            }
            try {
                height = Integer.parseInt(FontDialog.this.sizeText.getText());
            }
            catch (Exception exception) {
                return;
            }
            this.synchronizingSelection = true;
            FontDialog.this.sizeChangedByText = true;
            FontDialog.this.setFontHeight(height);
            FontDialog.this.sizeChangedByText = false;
            this.synchronizingSelection = false;
            FontDialog.this.fireFontChanged();
        }
    }

    private static class TreeArrayContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private TreeArrayContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }
}

