/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.share.jobs;

import java.io.File;
import java.io.IOException;
import net.xmind.share.Info;
import net.xmind.share.Messages;
import net.xmind.share.XmindSharePlugin;
import net.xmind.share.jobs.HttpUtils;
import net.xmind.share.jobs.IUploadJobCallback;
import net.xmind.share.jobs.OpenMapJob;
import net.xmind.share.jobs.TransferFileJob;
import org.apache.commons.httpclient.HttpClient;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.CoreException;
import org.xmind.core.IWorkbook;

public class UploadJob
extends Job {
    private Info info;
    private HttpClient client;
    private TransferFileJob uploadJob;
    private Thread uploadThread;
    private IUploadJobCallback callback;

    public UploadJob(Info info, IUploadJobCallback callback) {
        super(NLS.bind((String)Messages.UploadJob_name, (Object)info.getString("Title")));
        this.info = info;
        this.callback = callback;
        this.client = new HttpClient();
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.runWithProgress(monitor);
        }
        catch (Exception e) {
            if (this.callback != null) {
                this.callback.onError();
            }
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (MessageDialog.openQuestion(null, (String)Messages.ErrorDialog_title, (String)Messages.ErrorDialog_message)) {
                        new UploadJob(UploadJob.this.info, UploadJob.this.callback).schedule();
                    }
                }
            });
            XmindSharePlugin.getDefault().getLog().log((IStatus)new Status(4, "com.xmindshare.uploader", Messages.UploadJob_Failure_message, (Throwable)e));
            return new Status(2, "com.xmindshare.uploader", 4, Messages.UploadJob_Failure_message, null);
        }
        if (this.callback != null) {
            this.callback.onSuccess();
        }
        if (monitor.isCanceled()) {
            return new Status(8, "com.xmindshare.uploader", Messages.UploadJob_Canceled_message);
        }
        return new Status(0, "com.xmindshare.uploader", 0, Messages.UploadJob_Success_message, null);
    }

    private void runWithProgress(IProgressMonitor monitor) throws Exception {
        IWorkbook workbook;
        String title = this.info.getString("Title");
        Assert.isNotNull((Object)title);
        String userName = this.info.getString("UserID");
        Assert.isNotNull((Object)userName);
        String token = this.info.getString("Token");
        Assert.isNotNull((Object)token);
        File file = (File)this.info.getProperty("File");
        monitor.beginTask(null, 100);
        monitor.subTask(Messages.UploadJob_Task_Prepare);
        String[] data = HttpUtils.prepareUpload(this.client, userName, token, title);
        String session = data[0];
        String url = data[1];
        String mapname = data[2];
        if (url != null && (workbook = (IWorkbook)this.info.getProperty("Workbook")) != null) {
            workbook.getMeta().setValue("Share/SourceUrl", url);
            try {
                workbook.save();
            }
            catch (IOException iOException) {
            }
            catch (CoreException coreException) {}
        }
        monitor.worked(10);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask(Messages.UploadJob_Task_TransferFile);
        this.uploadJob = new TransferFileJob(userName, session, file);
        this.uploadThread = new Thread(this.uploadJob);
        this.uploadThread.setName("Upload Map (" + title + ")");
        this.uploadThread.setPriority(5);
        this.uploadThread.start();
        boolean canceled = this.progressLoop(monitor, userName, token, session);
        if (!canceled && this.uploadJob.getException() != null) {
            throw this.uploadJob.getException();
        }
        if (!monitor.isCanceled()) {
            monitor.done();
        }
        this.uploadJob = null;
        this.uploadThread = null;
        if (mapname != null) {
            final String mapURL = "http://www.xmind.net/xmind/map/" + userName + "/" + token + "/" + mapname;
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    int retCode = new MessageDialog(null, Messages.UploadJob_OpenMap_title, null, Messages.UploadJob_OpenMap_message, 0, new String[]{Messages.UploadJob_View_text, Messages.UploadJob_Close_text}, 0).open();
                    if (retCode == 0) {
                        new OpenMapJob(mapURL);
                    }
                }
            });
        }
    }

    private boolean progressLoop(IProgressMonitor monitor, String userName, String token, String session) {
        int uploaded = 0;
        boolean canceled = false;
        while (!this.uploadJob.isDone()) {
            if (!canceled && monitor.isCanceled()) {
                monitor.subTask(Messages.UploadJob_Task_Cancel);
                try {
                    HttpUtils.cancelUploading(this.client, userName, session, token);
                    canceled = true;
                }
                catch (Exception exception) {}
            }
            if (!canceled) {
                try {
                    double progress = HttpUtils.retrieveUploadingProcess(this.client, userName, session, token);
                    if (progress < 0.0) break;
                    int newUploaded = (int)(progress * 90.0);
                    if (newUploaded > uploaded) {
                        monitor.worked(newUploaded - uploaded);
                        uploaded = newUploaded;
                    }
                }
                catch (Exception exception) {}
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        return canceled;
    }
}

