/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.share;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.xmind.share.Info;
import net.xmind.share.Messages;
import net.xmind.share.dialog.UploaderDialog;
import net.xmind.share.jobs.IUploadJobCallback;
import net.xmind.share.jobs.UploadJob;
import net.xmind.signin.XMindNetEntry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.Core;
import org.xmind.core.IFileEntry;
import org.xmind.core.IMeta;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.GEF;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.mindmap.MindMapExtractor;
import org.xmind.ui.mindmap.MindMapPreviewBuilder;
import org.xmind.ui.resources.ColorUtils;

public class Uploader
implements IUploadJobCallback {
    private Shell parentShell;
    private IMindMapViewer sourceViewer;
    private IWorkbook workbook;
    private MindMapExtractor extractor;
    private Info info;
    private Point origin;
    private Image fullImage;
    private File file;

    public Uploader(Shell parentShell, IMindMapViewer sourceViewer) {
        this.parentShell = parentShell;
        this.sourceViewer = sourceViewer;
    }

    public void upload() {
        this.info = new Info();
        if (!this.signIn()) {
            this.cancel();
            return;
        }
        this.extractor = new MindMapExtractor(this.sourceViewer);
        this.workbook = this.extractor.extract();
        this.trimAttachments();
        this.generatePreview();
        if (this.fullImage == null || this.origin == null) {
            this.cancel();
            MessageDialog.openError((Shell)this.parentShell, (String)Messages.UploaderDialog_windowTitle, (String)Messages.failedToGenerateThumbnail);
            return;
        }
        String mapTitle = this.getDefaultMapTitle();
        this.info.setProperty("Title", mapTitle);
        this.info.setProperty("Description", this.getDefaultMapDescription());
        this.info.setProperty("FullImage", this.fullImage);
        this.info.setInt("Thumbnail/Origin/X", this.origin.x);
        this.info.setInt("Thumbnail/Origin/Y", this.origin.y);
        this.info.setProperty("Thumbnail/BackgroundColor", this.getBackgroundColor());
        UploaderDialog dialog = this.createUploadDialog();
        int ret = dialog.open();
        if (ret != 0) {
            this.cancel();
            return;
        }
        int x = this.info.getInt("Thumbnail/X", 0);
        int y = this.info.getInt("Thumbnail/Y", 0);
        double scale = this.info.getDouble("Thumbnail/Scale", 1.0);
        IMeta meta = this.workbook.getMeta();
        meta.setValue("Description", this.info.getString("Description"));
        meta.setValue("Thumbnail/X", String.valueOf(x));
        meta.setValue("Thumbnail/Y", String.valueOf(y));
        meta.setValue("Thumbnail/Scale", String.valueOf(scale /= 2.0));
        meta.setValue("Thumbnail/Origin/X", String.valueOf(this.origin.x));
        meta.setValue("Thumbnail/Origin/Y", String.valueOf(this.origin.y));
        meta.setValue("Thumbnail/BackgroundColor", this.info.getString("Thumbnail/BackgroundColor"));
        if (this.info.hasProperty("Share/AllowDownload")) {
            meta.setValue("Share/AllowDownload", this.info.getString("Share/AllowDownload", "1"));
        } else {
            meta.setValue("Share/AllowDownload", "1");
        }
        if (this.file == null) {
            String tempFile = Core.getWorkspace().getTempFile("upload/" + Core.getIdFactory().createId() + ".xmind");
            this.file = new File(tempFile);
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(Messages.failedToGenerateUploadFile){

            public void run() throws Exception {
                Uploader.this.workbook.save(Uploader.this.file.getAbsolutePath());
            }
        });
        if (!this.file.exists() || !this.file.canRead()) {
            this.cancel();
            return;
        }
        if (this.file != null) {
            this.info.setProperty("File", this.file);
            this.info.setProperty("Workbook", this.workbook);
            new UploadJob(this.info, this).schedule();
        }
    }

    private String getBackgroundColor() {
        Color color;
        Layer layer = this.sourceViewer.getLayer(GEF.LAYER_BACKGROUND);
        if (layer != null && (color = layer.getBackgroundColor()) != null) {
            return ColorUtils.toString((Color)color);
        }
        return "#ffffff";
    }

    private void openMyMaps() {
    }

    private boolean signIn() {
        Properties userInfo = XMindNetEntry.signIn();
        if (userInfo != null) {
            this.info.setProperty("UserID", userInfo.getProperty("USER_ID"));
            this.info.setProperty("Token", userInfo.getProperty("TOKEN"));
            return true;
        }
        return false;
    }

    private UploaderDialog createUploadDialog() {
        UploaderDialog dialog = new UploaderDialog(this.parentShell);
        dialog.setInfo(this.info);
        return dialog;
    }

    private void generatePreview() {
        final MindMapPreviewBuilder previewBuilder = new MindMapPreviewBuilder(this.workbook);
        final Display display = this.parentShell.getDisplay();
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            public void run() {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(Messages.failedToGenerateThumbnail){

                    public void run() throws Exception {
                        previewBuilder.save((Composite)Uploader.this.parentShell);
                        Uploader.this.origin = previewBuilder.getOrigin();
                        Uploader.this.fullImage = Uploader.this.getPreviewImage(Uploader.this.workbook, display);
                    }
                });
            }
        });
    }

    private void cancel() {
        this.clearTemp();
    }

    private void clearTemp() {
        if (this.fullImage != null) {
            this.fullImage.dispose();
            this.fullImage = null;
        }
        if (this.extractor != null) {
            this.extractor.delete();
            this.extractor = null;
        }
        if (this.file != null) {
            this.file.delete();
            this.file = null;
        }
        this.workbook = null;
    }

    private String getDefaultMapTitle() {
        if (this.workbook != null) {
            return this.workbook.getPrimarySheet().getRootTopic().getTitleText();
        }
        return null;
    }

    private String getDefaultMapDescription() {
        if (this.workbook != null) {
            return this.workbook.getMeta().getValue("Description");
        }
        return null;
    }

    private Image getPreviewImage(IWorkbook workbook, Display display) throws Exception {
        InputStream in;
        IFileEntry entry = workbook.getManifest().getFileEntry(MindMapPreviewBuilder.PATH_THUMBNAIL);
        if (entry != null && (in = entry.getInputStream()) != null) {
            Image image;
            try {
                image = new Image((Device)display, in);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
            return image;
        }
        return null;
    }

    public void onError() {
        this.clearTemp();
    }

    public void onSuccess() {
        this.openMyMaps();
        this.clearTemp();
    }

    public void onCancle() {
        this.clearTemp();
    }

    private void trimAttachments() {
        for (ISheet sheet : this.workbook.getSheets()) {
            this.trimAttachments(sheet.getRootTopic());
        }
    }

    private void trimAttachments(ITopic topic) {
        String hyperlink = topic.getHyperlink();
        if (hyperlink != null && HyperlinkUtils.isAttachmentURL((String)hyperlink)) {
            topic.setHyperlink(null);
        }
    }
}

