/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.viewers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.xmind.ui.internal.ToolkitImages;
import org.xmind.ui.viewers.ISliderContentProvider;
import org.xmind.ui.viewers.Messages;
import org.xmind.ui.viewers.SWTUtils;
import org.xmind.ui.viewers.SliderViewer;

public class ImagePreviewViewer {
    protected static final int PREF_WIDTH = 300;
    protected static final int PREF_HEIGHT = 180;
    protected static final double MAX_RATIO = 5.0;
    protected static final double MIN_RATIO = 0.1;
    protected static final double MID_RATIO = 1.0;
    protected static final int BORDER_WIDTH = 1;
    protected static final int STEPPING_DISTANCE = 5;
    protected static final int TEXT_MARGIN = 3;
    private boolean fill;
    private int prefWidth = 300;
    private int prefHeight = 180;
    private double maxRatio = 5.0;
    private double minRatio = 0.1;
    private double x = 0.0;
    private double y = 0.0;
    private double ratio = 1.0;
    private Image image;
    private Composite composite;
    private Canvas canvas;
    private Point startLoc;
    private double startX;
    private double startY;
    private SliderViewer slider;
    private IAction zoomInAction;
    private IAction zoomOutAction;
    private boolean updatingRatioSelection = false;
    private boolean disabled = false;
    private String title = null;
    private int titlePlacement = 0;
    private ISelectionChangedListener sliderListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (ImagePreviewViewer.this.updatingRatioSelection) {
                return;
            }
            ISelection selection = event.getSelection();
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof Double) {
                ImagePreviewViewer.this.changeRatio((Double)element);
                ImagePreviewViewer.this.setFocus();
            }
        }
    };

    public ImagePreviewViewer() {
        this(false);
    }

    public ImagePreviewViewer(boolean fill) {
        this.fill = fill;
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.composite.setLayout((Layout)layout);
        Composite composite2 = new Composite(this.composite, 0);
        GridLayout layout2 = new GridLayout();
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.horizontalSpacing = 0;
        layout2.verticalSpacing = 10;
        composite2.setLayout((Layout)layout2);
        composite2.setLayoutData((Object)new GridData(this.fill ? 4 : 2, this.fill ? 4 : 2, true, true));
        this.createCanvas(composite2);
        this.createRatioControls(composite2);
    }

    public void setBackgroundColor(Color color) {
        if (this.slider != null && !this.slider.getControl().isDisposed()) {
            this.slider.getControl().setBackground(color);
        }
    }

    protected void createCanvas(Composite parent) {
        this.canvas = new Canvas(parent, 0x20000000);
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.widthHint = this.getPrefWidth() + 1 + 1;
        layoutData.heightHint = this.getPrefHeight() + 1 + 1;
        layoutData.minimumWidth = layoutData.widthHint;
        layoutData.minimumHeight = layoutData.heightHint;
        this.canvas.setLayoutData((Object)layoutData);
        this.hookCanvas(this.canvas, new Listener(){

            public void handleEvent(Event event) {
                ImagePreviewViewer.this.handleCanvasEvent(event);
            }
        });
        this.canvas.setCursor(parent.getDisplay().getSystemCursor(21));
        this.updateCanvas();
    }

    protected void createRatioControls(Composite parent) {
        Composite bar = new Composite(parent, 0);
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 2;
        layoutData.verticalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = false;
        layoutData.widthHint = this.getPrefWidth();
        bar.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 30;
        layout.horizontalSpacing = 1;
        layout.marginHeight = 0;
        bar.setLayout((Layout)layout);
        ToolBar zoomOutBar = new ToolBar(bar, 0x800000);
        zoomOutBar.setLayoutData((Object)new GridData(1, 2, false, false));
        if (this.zoomOutAction == null) {
            this.zoomOutAction = new ZoomOutAction();
        }
        new ActionContributionItem(this.zoomOutAction).fill(zoomOutBar, 0);
        this.slider = new SliderViewer(bar, 256);
        GridData sliderLayoutData = new GridData(2, 2, true, false);
        sliderLayoutData.widthHint = 200;
        sliderLayoutData.minimumWidth = 80;
        this.slider.getControl().setLayoutData((Object)sliderLayoutData);
        this.slider.setContentProvider(new PreviewSliderContentProvider());
        this.slider.setLabelProvider((IBaseLabelProvider)new PreviewSliderLabelProvider());
        this.slider.setInput(this);
        this.updateRatioSelection(this.ratio);
        this.slider.addSelectionChangedListener(this.sliderListener);
        ToolBar zoomInBar = new ToolBar(bar, 0x800000);
        zoomInBar.setLayoutData((Object)new GridData(3, 2, false, false));
        if (this.zoomInAction == null) {
            this.zoomInAction = new ZoomInAction();
        }
        new ActionContributionItem(this.zoomInAction).fill(zoomInBar, 0);
        this.updateRatioControls();
    }

    private void updateCanvas() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.setEnabled(this.getImage() != null && !this.isDisabled());
        }
    }

    protected void updateRatioControls() {
        boolean ratioControlEnabled;
        boolean bl = ratioControlEnabled = this.getImage() != null && !this.isDisabled();
        if (this.zoomOutAction != null) {
            this.zoomOutAction.setEnabled(ratioControlEnabled);
        }
        if (this.zoomInAction != null) {
            this.zoomInAction.setEnabled(ratioControlEnabled);
        }
        if (this.slider != null && !this.slider.getControl().isDisposed()) {
            this.slider.getControl().setEnabled(ratioControlEnabled);
        }
    }

    protected void hookCanvas(Canvas canvas, Listener listener) {
        canvas.addListener(9, listener);
        canvas.addListener(3, listener);
        canvas.addListener(5, listener);
        canvas.addListener(4, listener);
        canvas.addListener(1, listener);
    }

    protected void handleCanvasEvent(Event event) {
        switch (event.type) {
            case 9: {
                this.paintCanvas(event);
                break;
            }
            case 3: {
                if (event.button != 1) break;
                this.startDragging(event);
                break;
            }
            case 4: {
                if (event.button != 1) break;
                this.endDragging(event);
                break;
            }
            case 5: {
                if ((event.stateMask & SWT.BUTTON_MASK) != 524288) break;
                this.drag(event);
                break;
            }
            case 1: {
                this.handleKeyDown(event);
            }
        }
    }

    protected void handleKeyDown(Event event) {
        int stateMask = event.stateMask;
        int keyCode = event.keyCode;
        if (SWTUtils.matchKey(stateMask, keyCode, 0, 0x1000001)) {
            this.moveUp();
        } else if (SWTUtils.matchKey(stateMask, keyCode, 0, 0x1000002)) {
            this.moveDown();
        } else if (SWTUtils.matchKey(stateMask, keyCode, 0, 0x1000003)) {
            this.moveLeft();
        } else if (SWTUtils.matchKey(stateMask, keyCode, 0, 0x1000004)) {
            this.moveRight();
        } else if (SWTUtils.matchKey(stateMask, keyCode, 0, 9)) {
            ((Control)event.widget).traverse(16);
        } else if (SWTUtils.matchKey(stateMask, keyCode, 131072, 9)) {
            ((Control)event.widget).traverse(8);
        }
    }

    public void moveUp() {
        this.move(this.x, this.y, 0, -5);
    }

    public void moveDown() {
        this.move(this.x, this.y, 0, 5);
    }

    public void moveLeft() {
        this.move(this.x, this.y, -5, 0);
    }

    public void moveRight() {
        this.move(this.x, this.y, 5, 0);
    }

    private void paintCanvas(Event event) {
        GC gc = event.gc;
        Rectangle area = this.canvas.getClientArea();
        this.drawImage(gc, area);
        this.drawTitle(gc, area);
        gc.setClipping(area);
        gc.setForeground(event.display.getSystemColor(15));
        gc.drawRectangle(area.x, area.y, area.width - 1, area.height - 1);
    }

    private void drawTitle(GC gc, Rectangle area) {
        if (this.title == null) {
            return;
        }
        gc.setFont(this.composite.getFont());
        gc.setForeground(this.composite.getForeground());
        Point size = gc.stringExtent(this.title);
        int x = (this.titlePlacement & 0x4000) != 0 ? area.x + 3 : ((this.titlePlacement & 0x20000) != 0 ? area.x + area.width - size.x - 3 : area.x + (area.width - size.x) / 2);
        int y = (this.titlePlacement & 0x80) != 0 ? area.y + 3 : ((this.titlePlacement & 0x400) != 0 ? area.y + area.height - size.y - 3 : area.y + (area.height - size.y) / 2);
        gc.drawString(this.title, x, y, true);
    }

    protected void drawImage(GC gc, Rectangle area) {
        if (this.image != null && !this.image.isDisposed()) {
            this.drawImage(gc, area, this.image, this.image.getBounds());
        }
    }

    private void drawImage(GC gc, Rectangle area, Image image, Rectangle imgSize) {
        double srcWidth = Math.min((double)imgSize.width, (double)area.width / this.ratio);
        double srcHeight = Math.min((double)imgSize.height, (double)area.height / this.ratio);
        double srcX = Math.max(0.0, Math.min((double)imgSize.width - srcWidth, this.x));
        double srcY = Math.max(0.0, Math.min((double)imgSize.height - srcHeight, this.y));
        double destWidth = srcWidth * this.ratio;
        double destHeight = srcHeight * this.ratio;
        double destX = (double)(area.x + 1) + ((double)(area.width - 1 - 1) - destWidth) / 2.0;
        double destY = (double)(area.y + 1) + ((double)(area.height - 1 - 1) - destHeight) / 2.0;
        gc.setAntialias(1);
        gc.drawImage(image, (int)srcX, (int)srcY, (int)srcWidth, (int)srcHeight, (int)destX, (int)destY, (int)destWidth, (int)destHeight);
    }

    private void startDragging(Event event) {
        if (this.image == null || this.image.isDisposed()) {
            return;
        }
        this.startLoc = new Point(event.x, event.y);
        this.startX = this.x;
        this.startY = this.y;
    }

    private void endDragging(Event event) {
        this.startLoc = null;
    }

    private void drag(Event event) {
        if (this.startLoc == null || this.image == null || this.image.isDisposed()) {
            return;
        }
        this.move(this.startX, this.startY, event.x - this.startLoc.x, event.y - this.startLoc.y);
    }

    public void move(double startX, double startY, int dx, int dy) {
        int refHeight;
        int refWidth;
        if (this.image == null || this.image.isDisposed()) {
            return;
        }
        Rectangle imgSize = this.image.getBounds();
        if (this.canvas != null && !this.canvas.isDisposed()) {
            Rectangle area = this.canvas.getClientArea();
            refWidth = area.width;
            refHeight = area.height;
        } else {
            refWidth = this.getPrefWidth();
            refHeight = this.getPrefHeight();
        }
        double width = Math.min((double)imgSize.width, (double)refWidth / this.ratio);
        double height = Math.min((double)imgSize.height, (double)refHeight / this.ratio);
        double newX = Math.max(0.0, Math.min((double)imgSize.width - width, startX - (double)dx / this.ratio));
        double newY = Math.max(0.0, Math.min((double)imgSize.height - height, startY - (double)dy / this.ratio));
        if (newX != this.x || newY != this.y) {
            this.setX(newX);
            this.setY(newY);
            if (this.canvas != null && !this.canvas.isDisposed()) {
                this.canvas.redraw();
            }
        }
    }

    public Control getControl() {
        return this.composite;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
    }

    public double getRatio() {
        return this.ratio;
    }

    public int getPrefHeight() {
        return this.prefHeight;
    }

    public void setPrefHeight(int prefHeight) {
        if (prefHeight == this.prefHeight) {
            return;
        }
        int oldPrefHeight = this.prefHeight;
        this.prefHeight = prefHeight;
        this.updatePrefSize(this.getPrefWidth(), oldPrefHeight);
    }

    public int getPrefWidth() {
        return this.prefWidth;
    }

    public void setPrefWidth(int prefWidth) {
        if (prefWidth == this.prefWidth) {
            return;
        }
        int oldPrefWidth = this.prefWidth;
        this.prefWidth = prefWidth;
        this.updatePrefSize(oldPrefWidth, this.getPrefHeight());
    }

    private void updatePrefSize(int oldPrefWidth, int oldPrefHeight) {
        this.changeRatio(this.getRatio(), oldPrefWidth, oldPrefHeight);
    }

    public double getMaxRatio() {
        return this.maxRatio;
    }

    public void setMaxRatio(double maxRatio) {
        this.maxRatio = maxRatio;
    }

    public double getMinRatio() {
        return this.minRatio;
    }

    public void setMinRatio(double minRatio) {
        this.minRatio = minRatio;
    }

    public void zoomIn() {
        if (this.ratio < 1.0) {
            this.changeRatio(Math.min(1.0, this.ratio + 0.1));
        } else {
            this.changeRatio(this.ratio + 0.5);
        }
    }

    public void zoomOut() {
        if (this.ratio <= 1.0) {
            this.changeRatio(this.ratio - 0.1);
        } else {
            this.changeRatio(Math.max(1.0, this.ratio - 0.3));
        }
    }

    public void setFocus() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.setFocus();
        }
    }

    public void changeRatio(double ratio) {
        this.changeRatio(ratio, this.getPrefWidth(), this.getPrefHeight());
    }

    private void changeRatio(double ratio, int oldPrefWidth, int oldPrefHeight) {
        ratio = Math.max(this.getMinRatio(), Math.min(this.getMaxRatio(), ratio));
        double oldRatio = this.ratio;
        this.setRatio(ratio);
        double newRatio = this.ratio;
        if (this.image != null) {
            Rectangle imgSize = this.image.getBounds();
            double oldWidth = Math.min((double)imgSize.width, (double)oldPrefWidth / oldRatio);
            double oldHeight = Math.min((double)imgSize.height, (double)oldPrefHeight / oldRatio);
            double oldCenterX = this.x + oldWidth / 2.0;
            double oldCenterY = this.y + oldHeight / 2.0;
            double newWidth = Math.min((double)imgSize.width, (double)this.getPrefWidth() / newRatio);
            double newHeight = Math.min((double)imgSize.height, (double)this.getPrefHeight() / newRatio);
            this.setX(Math.min((double)imgSize.width - newWidth, Math.max(0.0, oldCenterX - newWidth / 2.0)));
            this.setY(Math.min((double)imgSize.height - newHeight, Math.max(0.0, oldCenterY - newHeight / 2.0)));
        }
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
        this.updateRatioSelection(newRatio);
    }

    protected void updateRatioSelection(double ratio) {
        if (this.slider != null && !this.slider.getControl().isDisposed()) {
            this.updatingRatioSelection = true;
            this.slider.setSelection((ISelection)new StructuredSelection((Object)ratio));
            this.updatingRatioSelection = false;
        }
    }

    public void setImage(Image image) {
        if (image != null) {
            Rectangle imgSize = image.getBounds();
            this.setImage(image, imgSize.x + imgSize.width / 2, imgSize.y + imgSize.height / 2);
        } else {
            this.setImage(null, 0.0, 0.0);
        }
    }

    public void setImage(Image image, double centerX, double centerY) {
        this.image = image;
        if (image != null) {
            Rectangle imgSize = image.getBounds();
            double horizontalRatio = (double)this.getPrefWidth() / (double)imgSize.width;
            double verticalRatio = (double)this.getPrefHeight() / (double)imgSize.height;
            this.setRatio(Math.max(0.6, Math.min(horizontalRatio, verticalRatio)));
            double width = Math.min((double)imgSize.width, (double)this.getPrefWidth() / this.getRatio());
            double height = Math.min((double)imgSize.height, (double)this.getPrefHeight() / this.getRatio());
            this.setX(Math.max(0.0, Math.min((double)imgSize.width - width, centerX - width / 2.0)));
            this.setY(Math.max(0.0, Math.min((double)imgSize.height - height, centerY - height / 2.0)));
        }
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
        this.updateCanvas();
        this.updateRatioControls();
        this.updateRatioSelection(this.ratio);
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        this.updateCanvas();
        this.updateRatioControls();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title == this.title || title != null && title.equals(this.title)) {
            return;
        }
        this.title = title;
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
    }

    public int getTitlePlacement() {
        return this.titlePlacement;
    }

    public void setTitlePlacement(int titlePlacement) {
        if (titlePlacement == this.titlePlacement) {
            return;
        }
        this.titlePlacement = titlePlacement;
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
    }

    private final class PreviewSliderContentProvider
    implements ISliderContentProvider {
        private PreviewSliderContentProvider() {
        }

        public double getPortion(Object input, Object value) {
            double v = (Double)value;
            if (v < 1.0) {
                return (v - ImagePreviewViewer.this.getMinRatio()) / (1.0 - ImagePreviewViewer.this.getMinRatio()) / 2.0;
            }
            return (v - 1.0) / (ImagePreviewViewer.this.getMaxRatio() - 1.0) / 2.0 + 0.5;
        }

        public Object getValue(Object input, double portion) {
            double v = portion > 0.476 && portion < 0.515 ? 1.0 : (portion < 0.5 ? portion * 2.0 * (1.0 - ImagePreviewViewer.this.getMinRatio()) + ImagePreviewViewer.this.getMinRatio() : (portion - 0.5) * 2.0 * (ImagePreviewViewer.this.getMaxRatio() - 1.0) + 1.0);
            return v;
        }

        public Object[] getValues(Object input) {
            return new Double[]{ImagePreviewViewer.this.getMinRatio(), 1.0, ImagePreviewViewer.this.getMaxRatio()};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static final class PreviewSliderLabelProvider
    extends LabelProvider {
        private PreviewSliderLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Double) {
                double v = (Double)element;
                return NLS.bind((String)"{0}%", (Object)((int)(v * 100.0)));
            }
            return super.getText(element);
        }
    }

    private class ZoomInAction
    extends Action {
        public ZoomInAction() {
            super(null, ToolkitImages.get("zoomin.gif", true));
            this.setDisabledImageDescriptor(ToolkitImages.get("zoomin.gif", false));
            this.setToolTipText(Messages.ZoomIn_toolTip);
        }

        public void run() {
            ImagePreviewViewer.this.zoomIn();
            ImagePreviewViewer.this.setFocus();
        }
    }

    private class ZoomOutAction
    extends Action {
        public ZoomOutAction() {
            super(null, ToolkitImages.get("zoomout.gif", true));
            this.setDisabledImageDescriptor(ToolkitImages.get("zoomout.gif", false));
            this.setToolTipText(Messages.ZoomOut_toolTip);
        }

        public void run() {
            ImagePreviewViewer.this.zoomOut();
            ImagePreviewViewer.this.setFocus();
        }
    }
}

