/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.richtext;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.xmind.ui.richtext.IRichDocument;
import org.xmind.ui.richtext.IRichDocumentUndoListener;
import org.xmind.ui.richtext.IRichDocumentUndoManager;
import org.xmind.ui.richtext.RichDocumentUndoEvent;
import org.xmind.ui.richtext.RichDocumentUndoManagerRegistry;

public class RichTextViewerUndoManager
implements IUndoManager,
IUndoManagerExtension {
    private KeyAndMouseListener fKeyAndMouseListener;
    private TextInputListener fTextInputListener;
    private ITextViewer fTextViewer;
    private int fUndoLevel;
    private IRichDocumentUndoManager fDocumentUndoManager;
    private IRichDocument fDocument;
    private IRichDocumentUndoListener fDocumentUndoListener;

    public RichTextViewerUndoManager(int undoLevel) {
        this.fUndoLevel = undoLevel;
    }

    private boolean isConnected() {
        return this.fTextViewer != null && this.fDocumentUndoManager != null;
    }

    public IRichDocumentUndoManager getDocumentUndoManager() {
        return this.fDocumentUndoManager;
    }

    public void beginCompoundChange() {
        if (this.isConnected()) {
            this.fDocumentUndoManager.beginCompoundChange();
        }
    }

    public void endCompoundChange() {
        if (this.isConnected()) {
            this.fDocumentUndoManager.endCompoundChange();
        }
    }

    private void addListeners() {
        StyledText text = this.fTextViewer.getTextWidget();
        if (text != null) {
            this.fKeyAndMouseListener = new KeyAndMouseListener();
            text.addMouseListener((MouseListener)this.fKeyAndMouseListener);
            text.addKeyListener((KeyListener)this.fKeyAndMouseListener);
            this.fTextInputListener = new TextInputListener();
            this.fTextViewer.addTextInputListener((ITextInputListener)this.fTextInputListener);
        }
    }

    private void removeListeners() {
        StyledText text = this.fTextViewer.getTextWidget();
        if (text != null) {
            if (this.fKeyAndMouseListener != null) {
                text.removeMouseListener((MouseListener)this.fKeyAndMouseListener);
                text.removeKeyListener((KeyListener)this.fKeyAndMouseListener);
                this.fKeyAndMouseListener = null;
            }
            if (this.fTextInputListener != null) {
                this.fTextViewer.removeTextInputListener((ITextInputListener)this.fTextInputListener);
                this.fTextInputListener = null;
            }
        }
    }

    public void setMaximalUndoLevel(int undoLevel) {
        this.fUndoLevel = Math.max(0, undoLevel);
        if (this.isConnected()) {
            this.fDocumentUndoManager.setMaximalUndoLevel(this.fUndoLevel);
        }
    }

    public void connect(ITextViewer textViewer) {
        if (this.fTextViewer == null && textViewer != null) {
            this.fTextViewer = textViewer;
            this.addListeners();
        }
        IDocument doc = this.fTextViewer.getDocument();
        this.connectDocumentUndoManager(doc);
    }

    public void disconnect() {
        if (this.fTextViewer != null) {
            this.removeListeners();
            this.fTextViewer = null;
        }
        this.disconnectDocumentUndoManager();
    }

    public void reset() {
        if (this.isConnected()) {
            this.fDocumentUndoManager.reset();
        }
    }

    public boolean redoable() {
        if (this.isConnected()) {
            return this.fDocumentUndoManager.redoable();
        }
        return false;
    }

    public boolean undoable() {
        if (this.isConnected()) {
            return this.fDocumentUndoManager.undoable();
        }
        return false;
    }

    public void redo() {
        if (this.isConnected()) {
            try {
                this.fDocumentUndoManager.redo();
            }
            catch (ExecutionException executionException) {}
        }
    }

    public void undo() {
        if (this.isConnected()) {
            try {
                this.fDocumentUndoManager.undo();
            }
            catch (ExecutionException executionException) {}
        }
    }

    private void selectAndReveal(int offset, int length) {
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fTextViewer;
            extension.exposeModelRange((IRegion)new Region(offset, length));
        } else if (!this.fTextViewer.overlapsWithVisibleRegion(offset, length)) {
            this.fTextViewer.resetVisibleRegion();
        }
        this.fTextViewer.setSelectedRange(offset, length);
        this.fTextViewer.revealRange(offset, length);
    }

    public IUndoContext getUndoContext() {
        if (this.isConnected()) {
            return this.fDocumentUndoManager.getUndoContext();
        }
        return null;
    }

    private void connectDocumentUndoManager(IDocument document) {
        this.disconnectDocumentUndoManager();
        if (document != null && document instanceof IRichDocument) {
            this.fDocument = (IRichDocument)document;
            RichDocumentUndoManagerRegistry.connect(this.fDocument);
            this.fDocumentUndoManager = RichDocumentUndoManagerRegistry.getDocumentUndoManager(this.fDocument);
            this.fDocumentUndoManager.connect(this);
            this.setMaximalUndoLevel(this.fUndoLevel);
            this.fDocumentUndoListener = new RichDocumentUndoListener();
            this.fDocumentUndoManager.addDocumentUndoListener(this.fDocumentUndoListener);
        } else {
            this.fDocument = null;
        }
    }

    private void disconnectDocumentUndoManager() {
        if (this.fDocumentUndoManager != null) {
            this.fDocumentUndoManager.disconnect(this);
            RichDocumentUndoManagerRegistry.disconnect(this.fDocument);
            this.fDocumentUndoManager.removeDocumentUndoListener(this.fDocumentUndoListener);
            this.fDocumentUndoListener = null;
            this.fDocumentUndoManager = null;
        }
    }

    public void commit() {
        if (this.isConnected()) {
            this.fDocumentUndoManager.commit();
        }
    }

    private class KeyAndMouseListener
    implements MouseListener,
    KeyListener {
        private KeyAndMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 1) {
                RichTextViewerUndoManager.this.commit();
            }
        }

        public void mouseUp(MouseEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: {
                    RichTextViewerUndoManager.this.commit();
                }
            }
        }
    }

    private class RichDocumentUndoListener
    implements IRichDocumentUndoListener {
        private RichDocumentUndoListener() {
        }

        public void documentUndoNotification(RichDocumentUndoEvent event) {
            if (!RichTextViewerUndoManager.this.isConnected()) {
                return;
            }
            int eventType = event.getEventType();
            if ((eventType & 1) != 0 || (eventType & 2) != 0) {
                if (event.isCompound()) {
                    ITextViewerExtension extension = null;
                    if (RichTextViewerUndoManager.this.fTextViewer instanceof ITextViewerExtension) {
                        extension = (ITextViewerExtension)RichTextViewerUndoManager.this.fTextViewer;
                    }
                    if (extension != null) {
                        extension.setRedraw(false);
                    }
                }
            } else if ((eventType & 4) != 0 || (eventType & 8) != 0) {
                StyledText widget;
                if (event.isCompound()) {
                    ITextViewerExtension extension = null;
                    if (RichTextViewerUndoManager.this.fTextViewer instanceof ITextViewerExtension) {
                        extension = (ITextViewerExtension)RichTextViewerUndoManager.this.fTextViewer;
                    }
                    if (extension != null) {
                        extension.setRedraw(true);
                    }
                }
                if (RichTextViewerUndoManager.this.fTextViewer != null && (widget = RichTextViewerUndoManager.this.fTextViewer.getTextWidget()) != null && !widget.isDisposed() && widget.isFocusControl()) {
                    RichTextViewerUndoManager.this.selectAndReveal(event.getOffset(), event.getText() == null ? 0 : event.getText().length());
                }
            }
        }
    }

    private class TextInputListener
    implements ITextInputListener {
        private TextInputListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            RichTextViewerUndoManager.this.disconnectDocumentUndoManager();
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            RichTextViewerUndoManager.this.connectDocumentUndoManager(newInput);
        }
    }
}

