/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.richtext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.xmind.ui.richtext.Hyperlink;
import org.xmind.ui.richtext.IRichDocument;
import org.xmind.ui.richtext.IRichDocumentListener;
import org.xmind.ui.richtext.ImagePlaceHolder;
import org.xmind.ui.richtext.LineStyle;

public class RichDocument
extends Document
implements IRichDocument {
    private StyleRange[] textStyles = EMPTY_TEXT_STYLES;
    private ImagePlaceHolder[] images = EMPTY_IMAGES;
    private LineStyle[] lineStyles = EMPTY_LINE_STYLES;
    private Hyperlink[] hyperlinks = EMPTY_HYPERLINK;
    private List<IRichDocumentListener> listeners = null;

    public RichDocument() {
    }

    public RichDocument(String initialContent) {
        super(initialContent);
    }

    public void addRichDocumentListener(IRichDocumentListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IRichDocumentListener>();
        }
        this.listeners.add(listener);
    }

    public void removeRichDocumentListener(IRichDocumentListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    protected void fireTextStylesChanged(final StyleRange[] oldTextStyles, final StyleRange[] newTextStyles) {
        if (this.listeners == null) {
            return;
        }
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IRichDocumentListener)listener).textStyleChanged(RichDocument.this, oldTextStyles, newTextStyles);
                }
            });
            ++n2;
        }
    }

    protected void fireImagesChanged(final ImagePlaceHolder[] oldImages, final ImagePlaceHolder[] newImages) {
        if (this.listeners == null) {
            return;
        }
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IRichDocumentListener)listener).imageChanged(RichDocument.this, oldImages, newImages);
                }
            });
            ++n2;
        }
    }

    protected void fireLineStylesChanged(final LineStyle[] oldLineStyles, final LineStyle[] newLineStyles) {
        if (this.listeners == null) {
            return;
        }
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IRichDocumentListener)listener).lineStyleChanged(RichDocument.this, oldLineStyles, newLineStyles);
                }
            });
            ++n2;
        }
    }

    protected void fireHyperlinkChanged(final Hyperlink[] oldHyperlinks, final Hyperlink[] newHyperlinks) {
        if (this.listeners == null) {
            return;
        }
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IRichDocumentListener)listener).hyperlinkChanged(RichDocument.this, oldHyperlinks, newHyperlinks);
                }
            });
            ++n2;
        }
    }

    public StyleRange findTextStyle(int offset, int length) {
        int end = length == 0 ? 0 : 1;
        StyleRange[] styleRangeArray = this.textStyles;
        int n = this.textStyles.length;
        int n2 = 0;
        while (n2 < n) {
            StyleRange sr = styleRangeArray[n2];
            if (sr.start <= offset && offset <= sr.start + sr.length - end) {
                return sr;
            }
            ++n2;
        }
        return null;
    }

    public Image findImage(int offset) {
        ImagePlaceHolder[] imagePlaceHolderArray = this.images;
        int n = this.images.length;
        int n2 = 0;
        while (n2 < n) {
            ImagePlaceHolder imagePlaceHolder = imagePlaceHolderArray[n2];
            if (imagePlaceHolder.offset == offset) {
                return imagePlaceHolder.image;
            }
            ++n2;
        }
        return null;
    }

    public LineStyle findLineStyle(int startLine) {
        LineStyle[] lineStyleArray = this.lineStyles;
        int n = this.lineStyles.length;
        int n2 = 0;
        while (n2 < n) {
            LineStyle style = lineStyleArray[n2];
            if (style.lineIndex == startLine) {
                return style;
            }
            ++n2;
        }
        return null;
    }

    public Hyperlink findHyperlink(int offset) {
        Hyperlink[] hyperlinkArray = this.hyperlinks;
        int n = this.hyperlinks.length;
        int n2 = 0;
        while (n2 < n) {
            Hyperlink hyper = hyperlinkArray[n2];
            int start = hyper.start;
            int end = hyper.end();
            if (start <= offset && offset <= end) {
                return hyper;
            }
            ++n2;
        }
        return null;
    }

    public ImagePlaceHolder[] getImages() {
        return this.images;
    }

    public LineStyle[] getLineStyles() {
        return this.lineStyles;
    }

    public StyleRange[] getTextStyles() {
        return this.textStyles;
    }

    public Hyperlink[] getHyperlinks() {
        return this.hyperlinks;
    }

    public void setImages(ImagePlaceHolder[] images) {
        Object[] newImages;
        Object[] oldImages;
        if (images == null) {
            images = EMPTY_IMAGES;
        }
        if (!RichDocument.equals(oldImages = this.images, newImages = images)) {
            this.images = images;
            this.fireImagesChanged((ImagePlaceHolder[])oldImages, (ImagePlaceHolder[])newImages);
        }
    }

    public void setLineStyles(LineStyle[] lines) {
        Object[] newLineStyles;
        Object[] oldLineStyles;
        if (lines == null) {
            lines = EMPTY_LINE_STYLES;
        }
        if (!RichDocument.equals(oldLineStyles = this.lineStyles, newLineStyles = lines)) {
            this.lineStyles = lines;
            this.fireLineStylesChanged((LineStyle[])oldLineStyles, (LineStyle[])newLineStyles);
        }
    }

    public void setTextStyles(StyleRange[] styles) {
        Object[] newTextStyles;
        Object[] oldTextStyles;
        if (styles == null) {
            styles = EMPTY_TEXT_STYLES;
        }
        if (!RichDocument.equals(oldTextStyles = this.textStyles, newTextStyles = styles)) {
            this.textStyles = styles;
            this.fireTextStylesChanged((StyleRange[])oldTextStyles, (StyleRange[])newTextStyles);
        }
    }

    public void setHyperlinks(Hyperlink[] hyperlinks) {
        Object[] newhyperlinks;
        Object[] oldHyperlinks;
        if (hyperlinks == null) {
            hyperlinks = EMPTY_HYPERLINK;
        }
        if (!RichDocument.equals(oldHyperlinks = this.hyperlinks, newhyperlinks = hyperlinks)) {
            this.hyperlinks = hyperlinks;
            this.fireHyperlinkChanged((Hyperlink[])oldHyperlinks, (Hyperlink[])newhyperlinks);
        }
    }

    private static boolean equals(Object[] a1, Object[] a2) {
        return Arrays.equals(a1, a2);
    }
}

