/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.richtext;

public class LineStyle
implements Cloneable {
    public static final int DEFAULT_ALIGNMENT = 16384;
    public int lineIndex;
    public int alignment = 16384;
    public int indent = 0;

    public LineStyle() {
        this(0);
    }

    public LineStyle(int startLine) {
        this.lineIndex = startLine;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LineStyle)) {
            return false;
        }
        LineStyle that = (LineStyle)obj;
        return this.lineIndex == that.lineIndex && this.alignment == that.alignment && this.indent == that.indent;
    }

    public boolean similarTo(LineStyle that) {
        if (that == null) {
            return false;
        }
        return this.alignment == that.alignment && this.indent == that.indent;
    }

    public boolean isUnstyled() {
        return this.alignment == 16384 && this.indent == 0;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            LineStyle clone = new LineStyle(this.lineIndex);
            clone.alignment = this.alignment;
            clone.indent = this.indent;
            return clone;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append("LineStyle{lineIndex=");
        sb.append(this.lineIndex);
        sb.append(",alignment=");
        switch (this.alignment) {
            case 0x1000000: {
                sb.append("center");
                break;
            }
            case 131072: {
                sb.append("right");
                break;
            }
            default: {
                sb.append("left");
            }
        }
        sb.append(",indent=");
        sb.append(this.indent);
        sb.append("}");
        return sb.toString();
    }
}

