/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.dialogs;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.ui.dialogs.SmoothPopupDialog;
import org.xmind.ui.resources.FontUtils;

public class SimpleInfoPopupDialog
extends SmoothPopupDialog {
    private String infoText;
    private IAction leftAction;
    private IAction rightAction;
    private int iconId;
    private Image icon;

    public SimpleInfoPopupDialog(Shell parent, String title, String infoText) {
        this(parent, title, infoText, 0, null, null);
    }

    public SimpleInfoPopupDialog(Shell parent, String title, String infoText, int iconId) {
        this(parent, title, infoText, iconId, null, null);
    }

    public SimpleInfoPopupDialog(Shell parent, String title, String infoText, int iconId, IAction leftAction, IAction rightAction) {
        super(parent, true, title);
        this.infoText = infoText;
        this.iconId = iconId;
        this.leftAction = leftAction;
        this.rightAction = rightAction;
    }

    protected Control createDialogArea(Composite parent) {
        boolean hasRightAction;
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        boolean hasIcon = this.hasIcon();
        boolean hasInfo = this.hasInfo();
        if (hasIcon || hasInfo) {
            Composite infoArea = new Composite(composite, 524288);
            int numColumns = hasIcon && hasInfo ? 2 : 1;
            GridLayout infoAreaLayout = new GridLayout(numColumns, false);
            infoAreaLayout.marginWidth = 0;
            infoAreaLayout.marginHeight = 0;
            infoArea.setLayout((Layout)infoAreaLayout);
            GridData infoAreaLayoutData = new GridData(4, 4, true, true);
            infoAreaLayoutData.widthHint = 180;
            infoAreaLayoutData.heightHint = 100;
            infoArea.setLayoutData((Object)infoAreaLayoutData);
            if (hasIcon) {
                Label iconLabel = new Label(infoArea, 0x1000000);
                iconLabel.setImage(this.getIcon());
                iconLabel.setLayoutData((Object)new GridData(4, 2, !hasInfo, true));
            }
            if (hasInfo) {
                Label info = new Label(infoArea, 0x1000040);
                info.setText(this.getInfoText());
                info.setFont(this.getInfoFont());
                info.setLayoutData((Object)new GridData(4, 2, true, true));
            }
        }
        boolean hasLeftAction = this.leftAction != null;
        boolean bl = hasRightAction = this.rightAction != null;
        if (hasLeftAction || hasRightAction) {
            Composite actionBar = new Composite(composite, 524288);
            int numColumns = hasLeftAction && hasRightAction ? 2 : 1;
            GridLayout infoAreaLayout = new GridLayout(numColumns, false);
            infoAreaLayout.marginWidth = 0;
            infoAreaLayout.marginHeight = 0;
            actionBar.setLayout((Layout)infoAreaLayout);
            actionBar.setLayoutData((Object)new GridData(4, 4, true, !hasInfo && !hasIcon));
            if (hasLeftAction) {
                Control left = this.createHyperlink(actionBar, this.leftAction);
                GridData leftLayoutData = new GridData(1, 0x1000008, true, !hasInfo && !hasIcon);
                left.setLayoutData((Object)leftLayoutData);
            }
            if (hasRightAction) {
                Control right = this.createHyperlink(actionBar, this.rightAction);
                GridData rightLayoutData = new GridData(0x1000008, 0x1000008, true, !hasInfo && !hasIcon);
                right.setLayoutData((Object)rightLayoutData);
            }
        }
        return composite;
    }

    protected Control createHyperlink(Composite parent, final IAction action) {
        Hyperlink hyperlink = new Hyperlink(parent, 0);
        hyperlink.setText(this.getHyperlinkText(action));
        hyperlink.setUnderlined(true);
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                action.run();
            }
        });
        return hyperlink;
    }

    protected String getHyperlinkText(IAction action) {
        String text = action.getText();
        if (text != null) {
            text = Action.removeAcceleratorText((String)text);
            text = Action.removeMnemonics((String)text);
            return text;
        }
        return "";
    }

    public IAction getLeftAction() {
        return this.leftAction;
    }

    public IAction getRightAction() {
        return this.rightAction;
    }

    protected boolean hasHyperlink() {
        return this.leftAction != null;
    }

    protected void openHyperlink(final IAction action) {
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                action.run();
            }
        });
    }

    protected Font getInfoFont() {
        return FontUtils.getNewHeight("org.eclipse.jface.defaultfont", 10);
    }

    public String getInfoText() {
        return this.infoText;
    }

    protected boolean hasInfo() {
        return this.infoText != null;
    }

    protected Image getIcon() {
        if (this.icon == null && this.iconId > 0) {
            this.icon = this.getShell().getDisplay().getSystemImage(this.iconId);
        }
        return this.icon;
    }

    protected boolean hasIcon() {
        return this.iconId > 0 && this.getIcon() != null;
    }
}

