/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.color;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.RGB;
import org.xmind.ui.color.PaletteItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaletteContents {
    private static PaletteContents instance = null;
    private List<PaletteItem> items;
    private int prefRows;
    private int prefColumns;

    public static PaletteContents getDefault() {
        if (instance == null) {
            PaletteContents palette = new PaletteContents(30, 5, 6);
            palette.addItem(PaletteItem.Black);
            palette.addItem(PaletteItem.Red);
            palette.addItem(PaletteItem.Yellow);
            palette.addItem(PaletteItem.Green);
            palette.addItem(PaletteItem.Blue);
            palette.addItem(PaletteItem.Purple);
            palette.addItem(PaletteItem.DarkGray);
            palette.addItem(PaletteItem.DarkRed);
            palette.addItem(PaletteItem.DarkYellow);
            palette.addItem(PaletteItem.DarkGreen);
            palette.addItem(PaletteItem.DarkBlue);
            palette.addItem(PaletteItem.DarkPurple);
            palette.addItem(PaletteItem.Gray);
            palette.addItem(PaletteItem.Rose);
            palette.addItem(PaletteItem.Orange);
            palette.addItem(PaletteItem.Lemon);
            palette.addItem(PaletteItem.LimeGreen);
            palette.addItem(PaletteItem.Turquoise);
            palette.addItem(PaletteItem.LightGray);
            palette.addItem(PaletteItem.Copper);
            palette.addItem(PaletteItem.GoldenOlive);
            palette.addItem(PaletteItem.Beige);
            palette.addItem(PaletteItem.Sapphire);
            palette.addItem(PaletteItem.Lavender);
            palette.addItem(PaletteItem.White);
            palette.addItem(PaletteItem.Khaki);
            palette.addItem(PaletteItem.ForestGreen);
            palette.addItem(PaletteItem.AntiqueBlue);
            palette.addItem(PaletteItem.Indigo);
            palette.addItem(PaletteItem.Violet);
            instance = palette;
        }
        return instance;
    }

    public PaletteContents() {
        this(10);
    }

    public PaletteContents(int num) {
        this(num, PaletteContents.calcRows(num));
    }

    public PaletteContents(int num, int preferredRows) {
        this(num, preferredRows, PaletteContents.calcColumns(num, preferredRows));
    }

    public PaletteContents(int num, int preferredRows, int preferredColumns) {
        if (num <= 0) {
            throw new IllegalArgumentException();
        }
        this.items = new ArrayList<PaletteItem>(num);
        this.prefRows = Math.min(Math.max(preferredRows, 1), num);
        this.prefColumns = Math.min(Math.max(preferredColumns, 1), num);
    }

    public PaletteContents(PaletteItem[] items) {
        this.items = new ArrayList<PaletteItem>((Collection)Arrays.asList(items));
        this.prefRows = PaletteContents.calcRows(items.length);
        this.prefColumns = PaletteContents.calcColumns(items.length, this.prefRows);
    }

    public void addItem(RGB color, String description) {
        this.addItem(new PaletteItem(color, description));
    }

    public void addItem(int r, int g, int b, String description) {
        this.addItem(new RGB(r, g, b), description);
    }

    public void addItem(int color, String description) {
        this.addItem(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, description);
    }

    public void addItem(PaletteItem item) {
        this.items.add(item);
    }

    public void clear() {
        this.items.clear();
    }

    public RGB getColor(int index) {
        return this.items.get((int)index).color;
    }

    public String getDescription(int index) {
        return this.items.get((int)index).description;
    }

    public int getPreferredRows() {
        return this.prefRows;
    }

    public int getPreferredColumns() {
        return this.prefColumns;
    }

    public int size() {
        return this.items.size();
    }

    public PaletteItem[] toArray() {
        return this.items.toArray(new PaletteItem[this.items.size()]);
    }

    public List<PaletteItem> toList() {
        return Collections.unmodifiableList(this.items);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PaletteContents)) {
            return false;
        }
        PaletteContents that = (PaletteContents)obj;
        return this.items.equals(that.items);
    }

    public int hashCode() {
        return this.items.hashCode();
    }

    private static int calcRows(int num) {
        return (int)Math.sqrt(num);
    }

    private static int calcColumns(int num, int rows) {
        return rows == 0 ? 0 : (num + rows - 1) / rows;
    }
}

