/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.color;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorBlockImageDescriptor
extends ImageDescriptor {
    public static final int DEFAULT_WIDTH = 16;
    public static final int DEFAULT_HEIGHT = 16;
    private RGB rgb;
    private Point size;

    private ColorBlockImageDescriptor(RGB color, Point size) {
        this.rgb = color;
        if (size == null) {
            this.size = new Point(16, 16);
        } else {
            int width = size.x < 0 ? 16 : size.x;
            int height = size.y < 0 ? 16 : size.y;
            this.size = new Point(width, height);
        }
    }

    public ImageData getImageData() {
        Display display = Display.getCurrent();
        int width = this.size.x;
        int height = this.size.y;
        Image image = new Image((Device)display, width, height);
        GC gc = new GC((Drawable)image);
        gc.setLineWidth(1);
        gc.setLineStyle(1);
        gc.setAntialias(1);
        if (this.rgb != null) {
            Color color = new Color((Device)display, this.rgb);
            gc.setBackground(color);
            gc.fillRectangle(0, 0, width, height);
            color.dispose();
        } else {
            gc.setBackground(display.getSystemColor(1));
            gc.fillRectangle(0, 0, width, height);
            gc.setForeground(display.getSystemColor(3));
            gc.drawLine(0, height - 1, width - 1, 0);
        }
        gc.setForeground(display.getSystemColor(16));
        gc.drawRectangle(0, 0, width - 1, height - 1);
        gc.dispose();
        ImageData imageData = image.getImageData();
        image.dispose();
        return imageData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ColorBlockImageDescriptor)) {
            return false;
        }
        ColorBlockImageDescriptor that = (ColorBlockImageDescriptor)((Object)obj);
        return that.size.equals((Object)this.size) && (that.rgb == this.rgb || that.rgb != null && that.rgb.equals((Object)this.rgb));
    }

    public String toString() {
        return "{ColorBlockImageDescriptor: color=" + this.rgb + ", size=" + this.size + "}";
    }

    public static ColorBlockImageDescriptor createFromColor(Color color, Point size) {
        return new ColorBlockImageDescriptor(color.getRGB(), size);
    }

    public static ColorBlockImageDescriptor createFromColor(Color color) {
        return new ColorBlockImageDescriptor(color.getRGB(), null);
    }

    public static ColorBlockImageDescriptor createFromRGB(RGB rgb, Point size) {
        return new ColorBlockImageDescriptor(rgb, size);
    }

    public static ColorBlockImageDescriptor createFromRGB(RGB rgb) {
        return new ColorBlockImageDescriptor(rgb, null);
    }
}

