/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.actions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.BaseNewWizardMenu;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.actions.NewFromMoreTemplateAction;
import org.xmind.ui.internal.actions.NewFromTemplateFileAction;
import org.xmind.ui.internal.actions.NewFromTemplateURLAction;
import org.xmind.ui.internal.actions.NewWorkbookAction;
import org.xmind.ui.util.ResourceFinder;

public class NewMenu
extends BaseNewWizardMenu {
    private static final String TEMPLATES_PATH = "templates";
    private static final String TEMPLATES_DIR = "templates/";
    private IAction newWorkbookAction;
    private IAction newFromTemplateAction;

    public NewMenu(IWorkbenchWindow window) {
        super(window, "org.xmind.ui.newMenu");
        this.newWorkbookAction = new NewWorkbookAction(window);
        this.newFromTemplateAction = new NewFromMoreTemplateAction(window);
    }

    public IAction getNewWorkbookAction() {
        return this.newWorkbookAction;
    }

    public IAction getNewFromTemplateAction() {
        return this.newFromTemplateAction;
    }

    protected void addItems(List list) {
        list.add(new ActionContributionItem(this.newWorkbookAction));
        list.add(new Separator());
        this.addTemplateFileActions(list);
        list.add(new Separator());
        list.add(new ActionContributionItem(this.newFromTemplateAction));
        list.add(new Separator());
        super.addItems(list);
    }

    private void addTemplateFileActions(List list) {
        Bundle bundle = Platform.getBundle((String)"org.xmind.ui");
        if (bundle == null) {
            return;
        }
        Element element = this.getTemplateListElement(bundle);
        if (element == null) {
            String mainPath = this.getTemplatePath(bundle);
            if (mainPath == null) {
                return;
            }
            File dir = new File(mainPath);
            if (!dir.isDirectory()) {
                return;
            }
            String[] stringArray = dir.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.endsWith(".xmt")) {
                    String path = new File(dir, name).getAbsolutePath();
                    list.add(new ActionContributionItem((IAction)new NewFromTemplateFileAction(this.getWindow(), path)));
                }
                ++n2;
            }
        } else {
            Properties properties = this.getTemplateListProperties(bundle);
            Iterator it = DOMUtils.childElementIterByTag((Node)element, (String)"template");
            while (it.hasNext()) {
                URL url;
                Element templateEle = (Element)it.next();
                String resourcePath = templateEle.getAttribute("resource");
                if ("".equals(resourcePath)) continue;
                if (!resourcePath.startsWith("/")) {
                    resourcePath = TEMPLATES_DIR + resourcePath;
                }
                if ((url = this.findTemplateResource(bundle, resourcePath)) == null) continue;
                String name = templateEle.getAttribute("name");
                if (name.startsWith("%")) {
                    name = properties != null ? properties.getProperty(name.substring(1)) : null;
                }
                if (name == null || "".equals(name)) {
                    name = FileUtils.getNoExtensionFileName((String)resourcePath);
                }
                NewFromTemplateURLAction action = new NewFromTemplateURLAction(this.getWindow(), url, name);
                list.add(new ActionContributionItem((IAction)action));
            }
        }
    }

    private URL findTemplateResource(Bundle bundle, String resourcePath) {
        return FileLocator.find((Bundle)bundle, (IPath)new Path("$nl$/" + resourcePath), null);
    }

    private Properties getTemplateListProperties(Bundle bundle) {
        URL propURL = ResourceFinder.findResource((Bundle)bundle, (String)TEMPLATES_DIR, (String)TEMPLATES_PATH, (String)".properties");
        if (propURL != null) {
            Properties properties;
            InputStream is = propURL.openStream();
            try {
                Properties properties2 = new Properties();
                properties2.load(is);
                properties = properties2;
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
            }
            is.close();
            return properties;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Element getTemplateListElement(Bundle bundle) {
        URL xmlURL = FileLocator.find((Bundle)bundle, (IPath)new Path("templates/templates.xml"), null);
        if (xmlURL == null) {
            return null;
        }
        try {
            InputStream is = xmlURL.openStream();
            if (is == null) return null;
            try {
                Document doc = DOMUtils.loadDocument((InputStream)is);
                if (doc == null) return null;
                Element element = doc.getDocumentElement();
                return element;
            }
            finally {
                is.close();
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private String getTemplatePath(Bundle bundle) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(TEMPLATES_PATH), null);
        if (url == null) {
            return null;
        }
        try {
            url = FileLocator.toFileURL((URL)url);
        }
        catch (IOException iOException) {
            return null;
        }
        return url.getFile();
    }
}

