/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbench;
import org.xmind.cathy.internal.CathyPlugin;

public class AutoSaveService
implements IPropertyChangeListener {
    private IWorkbench workbench;
    private AutoSaveJob job = null;

    public AutoSaveService(IWorkbench workbench) {
        this.workbench = workbench;
        CathyPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.checkState();
    }

    public void dispose() {
        this.stopJob();
        this.workbench = null;
        CathyPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    private void checkState() {
        if (this.isEnabled()) {
            this.ensureJobRunning();
        } else {
            this.stopJob();
        }
    }

    private void ensureJobRunning() {
        if (this.workbench == null) {
            return;
        }
        if (this.job != null) {
            return;
        }
        this.job = new AutoSaveJob(this.getIntervals());
    }

    private void stopJob() {
        if (this.job != null) {
            this.job.stop();
            this.job = null;
        }
    }

    private boolean isEnabled() {
        return CathyPlugin.getDefault().getPreferenceStore().getBoolean("autoSaveEnabled");
    }

    private int getIntervals() {
        return CathyPlugin.getDefault().getPreferenceStore().getInt("autoSaveIntervals") * 60000;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("autoSaveEnabled".equals(property)) {
            this.checkState();
        } else if ("autoSaveIntervals".equals(property) && this.job != null) {
            this.job.setIntervals(this.getIntervals());
        }
    }

    private void doSaveAll() {
        if (this.workbench == null) {
            return;
        }
        try {
            this.workbench.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (AutoSaveService.this.workbench == null) {
                        return;
                    }
                    AutoSaveService.this.workbench.saveAllEditors(false);
                }
            });
        }
        catch (Throwable e) {
            CathyPlugin.log(e, "Error occurred while auto saving.");
        }
    }

    static /* synthetic */ void access$1(AutoSaveService autoSaveService) {
        autoSaveService.doSaveAll();
    }

    private class AutoSaveJob {
        private Job job;
        private int intervals = -1;

        public AutoSaveJob(int intervals) {
            this.intervals = intervals;
            this.job = new AutoSaveJobImpl("Auto Save All Editors");
            this.job.setSystem(true);
            this.job.setPriority(30);
            this.job.schedule();
        }

        public void stop() {
            this.job.cancel();
            Thread thread = this.job.getThread();
            if (thread != null) {
                thread.interrupt();
            }
        }

        public void setIntervals(int intervals) {
            this.intervals = intervals;
            Thread thread = this.job.getThread();
            if (thread != null) {
                thread.interrupt();
            }
        }

        static /* synthetic */ int access$0(AutoSaveJob autoSaveJob) {
            return autoSaveJob.intervals;
        }

        static /* synthetic */ AutoSaveService access$1(AutoSaveJob autoSaveJob) {
            return autoSaveJob.AutoSaveService.this;
        }

        private class AutoSaveJobImpl
        extends Job {
            private AutoSaveJobImpl(String name) {
                super(name);
            }

            /*
             * Unable to fully structure code
             */
            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled() || AutoSaveService.access$0(AutoSaveJob.access$1(AutoSaveJob.this)) == null) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    Thread.sleep(AutoSaveJob.access$0(AutoSaveJob.this));
                    ** GOTO lbl18
                }
                catch (InterruptedException v0) {
                    if (!monitor.isCanceled() && AutoSaveService.access$0(AutoSaveJob.access$1(AutoSaveJob.this)) != null) ** GOTO lbl18
                    return Status.CANCEL_STATUS;
                }
lbl-1000:
                // 1 sources

                {
                    AutoSaveService.access$1(AutoSaveJob.access$1(AutoSaveJob.this));
                    if (monitor.isCanceled() || AutoSaveService.access$0(AutoSaveJob.access$1(AutoSaveJob.this)) == null) {
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        Thread.sleep(AutoSaveJob.access$0(AutoSaveJob.this));
                        continue;
                    }
                    catch (InterruptedException v1) {
                        if (!monitor.isCanceled() && AutoSaveService.access$0(AutoSaveJob.access$1(AutoSaveJob.this)) != null) continue;
                        return Status.CANCEL_STATUS;
                    }
lbl18:
                    // 4 sources

                    ** while (!monitor.isCanceled())
                }
lbl19:
                // 1 sources

                return Status.OK_STATUS;
            }
        }
    }
}

