/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.style;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.style.IStyle;
import org.xmind.gef.IViewer;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.graphicalpolicy.IStyleValueProvider;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.decorations.IArrowDecoration;
import org.xmind.ui.decorations.IBoundaryDecoration;
import org.xmind.ui.decorations.IBranchConnectionDecoration;
import org.xmind.ui.decorations.IDecorationDescriptor;
import org.xmind.ui.decorations.IRelationshipDecoration;
import org.xmind.ui.decorations.ISummaryDecoration;
import org.xmind.ui.decorations.ITopicDecoration;
import org.xmind.ui.internal.decorations.ArrowDecorationAdapter;
import org.xmind.ui.internal.decorations.BoundaryDecorationAdapter;
import org.xmind.ui.internal.decorations.BranchConnectionDecorationAdapter;
import org.xmind.ui.internal.decorations.CurlySummaryDecoration;
import org.xmind.ui.internal.decorations.CurvedRelationshipDecoration;
import org.xmind.ui.internal.decorations.DefaultBranchDecoration;
import org.xmind.ui.internal.decorations.RelationshipDecorationAdapter;
import org.xmind.ui.internal.decorations.RoundedRectBoundaryDecoration;
import org.xmind.ui.internal.decorations.RoundedRectTopicDecoration;
import org.xmind.ui.internal.decorations.StraightBranchConnection;
import org.xmind.ui.internal.decorations.SummaryDecorationAdapter;
import org.xmind.ui.internal.decorations.TopicDecorationAdapter;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.style.TextStyleData;
import org.xmind.ui.util.MindMapUtils;

public class StyleUtils {
    private static Pattern trimNumber = null;

    private StyleUtils() {
    }

    public static IStyleSelector getStyleSelector(IGraphicalPart part) {
        if (part == null) {
            return null;
        }
        return (IStyleSelector)part.getAdapter(IStyleSelector.class);
    }

    public static RGB getRGB(IGraphicalPart part, IStyleSelector ss, String key, String decorationId) {
        if (part != null && ss != null) {
            String value = ss.getStyleValue(part, key);
            return StyleUtils.convertRGB(key, value);
        }
        return null;
    }

    public static RGB convertRGB(String key, String value) {
        if ("none".equals(value)) {
            return null;
        }
        if ("$system$".equals(value)) {
            return StyleUtils.getSystemRGB(key, null);
        }
        return ColorUtils.toRGB((String)value);
    }

    public static Color getColor(IGraphicalPart part, IStyleSelector ss, String key, String decorationId, String defaultColor) {
        String value;
        if (part != null && ss != null && (value = ss.getStyleValue(part, key, StyleUtils.getDecorationDefaultValueProvider(decorationId, key))) != null) {
            return StyleUtils.convertColor(key, value);
        }
        return StyleUtils.convertColor(key, defaultColor);
    }

    public static Color convertColor(String key, String value) {
        if ("none".equals(value)) {
            return null;
        }
        if ("$system$".equals(value)) {
            return StyleUtils.getSystemColor(key, null);
        }
        return ColorUtils.getColor((String)value);
    }

    private static RGB getSystemRGB(String key, RGB defaultValue) {
        if ("svg:fill".equals(key)) {
            return Display.getCurrent().getSystemColor(22).getRGB();
        }
        if ("line-color".equals(key)) {
            return Display.getCurrent().getSystemColor(23).getRGB();
        }
        if ("fo:color".equals(key)) {
            return Display.getCurrent().getSystemColor(21).getRGB();
        }
        return defaultValue;
    }

    public static Color getSystemColor(String key, Color defaultValue) {
        if ("svg:fill".equals(key)) {
            return Display.getCurrent().getSystemColor(22);
        }
        if ("line-color".equals(key)) {
            return Display.getCurrent().getSystemColor(23);
        }
        if ("fo:color".equals(key)) {
            return Display.getCurrent().getSystemColor(21);
        }
        return defaultValue;
    }

    public static int getInteger(IGraphicalPart part, IStyleSelector ss, String key, int defaultValue) {
        return StyleUtils.getInteger(part, ss, key, null, defaultValue);
    }

    public static int getInteger(IGraphicalPart part, IStyleSelector ss, String key, String decorationId, int defaultValue) {
        String value;
        if (part != null && ss != null && (value = ss.getStyleValue(part, key, StyleUtils.getDecorationDefaultValueProvider(decorationId, key))) != null) {
            value = StyleUtils.trimNumber(value);
            try {
                return Integer.parseInt(value);
            }
            catch (Exception exception) {}
        }
        return defaultValue;
    }

    public static double getDouble(IGraphicalPart part, IStyleSelector ss, String key, double defaultValue) {
        String value;
        if (part != null && ss != null && (value = ss.getStyleValue(part, key)) != null) {
            value = StyleUtils.trimNumber(value);
            try {
                return Double.parseDouble(value);
            }
            catch (Exception exception) {}
        }
        return defaultValue;
    }

    public static Font getFont(IGraphicalPart part, IStyleSelector ss, String key) {
        Font f;
        String value;
        if (part != null && ss != null && (value = ss.getStyleValue(part, key)) != null && (f = FontUtils.getFont((String)value)) != null) {
            return f;
        }
        return null;
    }

    public static Font getFont(IGraphicalPart part, IStyleSelector ss, String key, Font defaultValue) {
        Font f = StyleUtils.getFont(part, ss, key);
        if (f != null) {
            return f;
        }
        return defaultValue;
    }

    public static String getString(IGraphicalPart part, IStyleSelector ss, String key, String defaultValue) {
        String value;
        if (part != null && ss != null && (value = ss.getStyleValue(part, key)) != null) {
            return value;
        }
        return defaultValue;
    }

    public static TextStyleData getTextStyleData(IGraphicalPart part, IStyleSelector ss, TextStyleData defaultData) {
        int align;
        String decoration;
        RGB c;
        String style;
        TextStyleData data;
        Object cache = MindMapUtils.getCache((IPart)part, "org.xmind.ui.cache.textStyle");
        if (cache instanceof TextStyleData) {
            return (TextStyleData)cache;
        }
        if (defaultData == null) {
            defaultData = data = new TextStyleData();
        } else {
            data = new TextStyleData(defaultData);
        }
        String name = StyleUtils.getString(part, ss, "fo:font-family", defaultData.name);
        if ("$system$".equals(name)) {
            name = JFaceResources.getDefaultFont().getFontData()[0].getName();
        }
        data.name = name;
        data.height = StyleUtils.getInteger(part, ss, "fo:font-size", defaultData.height);
        String weight = StyleUtils.getString(part, ss, "fo:font-weight", null);
        if (weight != null) {
            data.bold = weight.contains("bold");
        }
        if ((style = StyleUtils.getString(part, ss, "fo:font-style", null)) != null) {
            data.italic = style.contains("italic");
        }
        if ((c = StyleUtils.getRGB(part, ss, "fo:color", null)) != null) {
            data.color = c;
        }
        if ((decoration = StyleUtils.getString(part, ss, "fo:text-decoration", null)) != null) {
            data.underline = decoration.contains("underline");
            data.strikeout = decoration.contains("line-through");
        }
        data.align = align = StyleUtils.getAlignValue(part, ss, "fo:text-align");
        return data;
    }

    public static int getAlign(IGraphicalPart part, IStyleSelector ss, String key) {
        return StyleUtils.getAlignValue(part, ss, "fo:text-align");
    }

    private static int getAlignValue(IGraphicalPart part, IStyleSelector ss, String key) {
        if (part != null && ss != null) {
            String value = ss.getStyleValue(part, key);
            if ("center".equals(value)) {
                return 2;
            }
            if ("right".equals(value)) {
                return 4;
            }
            return 1;
        }
        return 1;
    }

    public static FontData getCompositeFontData(IGraphicalPart part, IStyleSelector ss, FontData defaultFontData) {
        if (defaultFontData == null) {
            defaultFontData = JFaceResources.getDefaultFont().getFontData()[0];
        }
        TextStyleData data = StyleUtils.getTextStyleData(part, ss, new TextStyleData(defaultFontData));
        return data.createFontData();
    }

    public static Font getCompositeFont(IGraphicalPart part, IStyleSelector ss, Font defaultFont) {
        if (defaultFont == null) {
            defaultFont = JFaceResources.getDefaultFont();
        }
        TextStyleData data = StyleUtils.getTextStyleData(part, ss, new TextStyleData(defaultFont.getFontData()[0]));
        return data.createFont();
    }

    public static TextStyle getTextStyle(IGraphicalPart part, IStyleSelector ss) {
        Object cache = MindMapUtils.getCache((IPart)part, "org.xmind.ui.cache.textStyle");
        if (cache instanceof TextStyle) {
            return (TextStyle)cache;
        }
        TextStyleData data = StyleUtils.getTextStyleData(part, ss, null);
        return data.createTextStyle();
    }

    public static int getMajorSpacing(IGraphicalPart part, int defaultValue) {
        IStyleSelector ss = StyleUtils.getStyleSelector(part);
        String connectionId = StyleUtils.getString(part, ss, "line-class", null);
        return StyleUtils.getInteger(part, ss, "spacing-major", connectionId, defaultValue);
    }

    public static int getLineStyle(IGraphicalPart part, IStyleSelector ss, String decorationId, int defaultValue) {
        return StyleUtils.getLineStyle(part, ss, "line-pattern", decorationId, defaultValue);
    }

    public static int getLineStyle(IGraphicalPart part, IStyleSelector ss, String key, String decorationId, int defaultValue) {
        String value;
        if (part != null && ss != null && (value = ss.getStyleValue(part, key, StyleUtils.getDecorationDefaultValueProvider(decorationId, key))) != null) {
            return StyleUtils.toSWTLineStyle(value, defaultValue);
        }
        return defaultValue;
    }

    public static int toSWTLineStyle(String value, int defaultValue) {
        if ("solid".equals(value)) {
            return 1;
        }
        if ("dash".equals(value)) {
            return 2;
        }
        if ("dash-dot".equals(value)) {
            return 4;
        }
        if ("dash-dot-dot".equals(value)) {
            return 5;
        }
        if ("dot".equals(value)) {
            return 3;
        }
        return defaultValue;
    }

    public static int getAlpha(IGraphicalPart part, IStyleSelector ss, int defaultValue) {
        return StyleUtils.getAlpha(part, ss, "svg:opacity", defaultValue);
    }

    public static int getAlpha(IGraphicalPart part, IStyleSelector ss, String key, int defaultValue) {
        double opacity;
        if (part != null && ss != null && (opacity = StyleUtils.getDouble(part, ss, key, -1.0)) >= 0.0) {
            return (int)(opacity * 255.0);
        }
        return defaultValue;
    }

    public static String trimNumber(String value) {
        if (value != null) {
            Matcher m;
            value = value.trim();
            if (trimNumber == null) {
                trimNumber = Pattern.compile("^([\\d\\.]+)([^\\d\\.]*)");
            }
            if ((m = trimNumber.matcher(value)).find()) {
                value = m.group(1);
            }
        }
        return value;
    }

    public static boolean isSameDecoration(IDecoration oldDecoration, String newId) {
        if (newId != null) {
            if (oldDecoration == null) {
                return false;
            }
            String oldId = oldDecoration.getId();
            return newId.equals(oldId);
        }
        return oldDecoration == null;
    }

    public static IDecoration createDecoration(IGraphicalPart part, String id) {
        IDecoration decoration = MindMapUI.getMindMapDecorationFactory().createDecoration(id, part);
        if (decoration != null) {
            decoration.setId(id);
        }
        return decoration;
    }

    public static IArrowDecoration createArrowDecoration(IGraphicalPart part, String id) {
        IDecoration decoration;
        IDecoration iDecoration = decoration = id == null ? null : StyleUtils.createDecoration(part, id);
        if (decoration instanceof IArrowDecoration) {
            return (IArrowDecoration)decoration;
        }
        if (decoration != null) {
            return new ArrowDecorationAdapter(decoration);
        }
        return null;
    }

    public static IBoundaryDecoration createBoundaryDecoration(IGraphicalPart part, String id) {
        IDecoration decoration;
        IDecoration iDecoration = decoration = id == null ? null : StyleUtils.createDecoration(part, id);
        if (decoration instanceof IBoundaryDecoration) {
            return (IBoundaryDecoration)decoration;
        }
        if (decoration != null) {
            return new BoundaryDecorationAdapter(decoration);
        }
        return new RoundedRectBoundaryDecoration(id);
    }

    public static IBranchConnectionDecoration createBranchConnection(IGraphicalPart part, String id) {
        IDecoration decoration;
        IDecoration iDecoration = decoration = id == null ? null : StyleUtils.createDecoration(part, id);
        if (decoration instanceof IBranchConnectionDecoration) {
            return (IBranchConnectionDecoration)decoration;
        }
        if (decoration != null) {
            return new BranchConnectionDecorationAdapter(decoration);
        }
        return new StraightBranchConnection(id);
    }

    public static IDecoration createBranchDecoration(IGraphicalPart part, String id) {
        IDecoration decoration;
        IDecoration iDecoration = decoration = id == null ? null : StyleUtils.createDecoration(part, id);
        if (decoration != null) {
            return decoration;
        }
        if (part instanceof IBranchPart) {
            return new DefaultBranchDecoration((IBranchPart)part, id);
        }
        return null;
    }

    public static IRelationshipDecoration createRelationshipDecoration(IGraphicalPart part, String id) {
        IDecoration decoration;
        IDecoration iDecoration = decoration = id == null ? null : StyleUtils.createDecoration(part, id);
        if (decoration instanceof IRelationshipDecoration) {
            return (IRelationshipDecoration)decoration;
        }
        if (decoration != null) {
            return new RelationshipDecorationAdapter(decoration);
        }
        return new CurvedRelationshipDecoration(id);
    }

    public static ISummaryDecoration createSummaryDecoration(IGraphicalPart part, String id) {
        IDecoration decoration;
        IDecoration iDecoration = decoration = id == null ? null : StyleUtils.createDecoration(part, id);
        if (decoration instanceof ISummaryDecoration) {
            return (ISummaryDecoration)decoration;
        }
        if (decoration != null) {
            return new SummaryDecorationAdapter(decoration);
        }
        return new CurlySummaryDecoration(id);
    }

    public static ITopicDecoration createTopicDecoration(IGraphicalPart part, String id) {
        IDecoration decoration;
        IDecoration iDecoration = decoration = id == null ? null : StyleUtils.createDecoration(part, id);
        if (decoration instanceof ITopicDecoration) {
            return (ITopicDecoration)decoration;
        }
        if (decoration != null) {
            return new TopicDecorationAdapter(decoration);
        }
        return new RoundedRectTopicDecoration(id);
    }

    public static boolean isBranchLineTapered(IBranchPart branch, IStyleSelector ss) {
        if (branch != null && ss != null && branch.isCentral()) {
            ISheetPart sheet;
            IViewer viewer;
            String value = ss.getUserValue((IGraphicalPart)branch, "line-tapered");
            if (value == null && (viewer = branch.getSite().getViewer()) != null && (sheet = (ISheetPart)viewer.getAdapter(ISheetPart.class)) != null) {
                value = StyleUtils.getStyleSelector(sheet).getUserValue((IGraphicalPart)sheet, "line-tapered");
            }
            if (value == null) {
                value = ss.getStyleValue((IGraphicalPart)branch, "line-tapered");
            }
            return value != null && value.contains("tapered");
        }
        return false;
    }

    public static String getIndexedBranchLineColor(IBranchPart branch) {
        int index;
        IBranchPart parent = branch.getParentBranch();
        if (parent != null && (index = parent.getSubBranches().indexOf(branch)) >= 0) {
            String[] colors;
            IViewer viewer;
            IStyleSelector parentSS = StyleUtils.getStyleSelector(parent);
            String value = parentSS.getUserValue((IGraphicalPart)parent, "multi-line-colors");
            ISheetPart sheet = null;
            if (value == null && (viewer = parent.getSite().getViewer()) != null && (sheet = (ISheetPart)viewer.getAdapter(ISheetPart.class)) != null) {
                value = StyleUtils.getStyleSelector(sheet).getUserValue((IGraphicalPart)sheet, "multi-line-colors");
            }
            if (value == null) {
                value = parentSS.getStyleValue((IGraphicalPart)parent, "multi-line-colors");
            }
            if (value != null && !"none".equals(value) && (colors = (value = value.trim()).split("[\\s]+")).length > 0) {
                String color = colors[index %= colors.length].trim();
                return color;
            }
            return null;
        }
        return null;
    }

    public static Color getBranchConnectionColor(IBranchPart branch, IStyleSelector ss, IBranchPart child, int childIndex, Color defaultColor) {
        if (child != null) {
            IStyleSelector childSS = StyleUtils.getStyleSelector(child);
            String shapeId = StyleUtils.getString(child, childSS, "line-class", null);
            String defaultValue = defaultColor == null ? null : ColorUtils.toString((Color)defaultColor);
            return StyleUtils.getColor(child, childSS, "line-color", shapeId, defaultValue);
        }
        return defaultColor;
    }

    public static String addUnitPixel(int number) {
        return String.valueOf(String.valueOf(number)) + "px";
    }

    public static String addUnitPoint(int number) {
        return String.valueOf(String.valueOf(number)) + "pt";
    }

    public static IStyleValueProvider getDecorationDefaultValueProvider(String decorationId, String key) {
        IDecorationDescriptor descriptor;
        if (decorationId != null && (descriptor = MindMapUI.getDecorationManager().getDecorationDescriptor(decorationId)) != null) {
            return descriptor.getDefaultValueProvider(key);
        }
        return null;
    }

    public static String toTextDecoration(boolean underline, boolean strikeout) {
        if (underline || strikeout) {
            if (!underline) {
                return "line-through";
            }
            if (!strikeout) {
                return "underline";
            }
            return "underline line-through";
        }
        return "normal";
    }

    public static boolean isBold(IStyle style) {
        if (style != null) {
            String weight = style.getProperty("fo:font-weight");
            return weight != null && weight.contains("bold");
        }
        return false;
    }

    public static boolean isItalic(IStyle style) {
        if (style != null) {
            String weight = style.getProperty("fo:font-style");
            return weight != null && weight.contains("italic");
        }
        return false;
    }

    public static boolean isUnderline(IStyle style) {
        if (style != null) {
            String weight = style.getProperty("fo:text-decoration");
            return weight != null && weight.contains("underline");
        }
        return false;
    }

    public static boolean isStrikeout(IStyle style) {
        if (style != null) {
            String weight = style.getProperty("fo:text-decoration");
            return weight != null && weight.contains("line-through");
        }
        return false;
    }
}

