/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.mindmap;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.Core;
import org.xmind.core.IFileEntry;
import org.xmind.core.IManifest;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.dom.FileEntryImpl;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.util.Properties;
import org.xmind.ui.mindmap.MindMapImageExtractor;
import org.xmind.ui.util.ImageFormat;
import org.xmind.ui.util.Logger;

public class MindMapPreviewBuilder {
    private static boolean DEBUG = false;
    public static final ImageFormat DEFAULT_FORMAT = ImageFormat.JPEG;
    public static String PATH_THUMBNAIL = "Thumbnails/thumbnail" + (String)DEFAULT_FORMAT.getExtensions().get(0);
    private IWorkbook workbook;
    private ISheet sheet;
    private ITopic centralTopic;
    private Properties properties;
    private Point origin;
    private ImageFormat format = DEFAULT_FORMAT;
    private int resizeStrategy = 0;
    private int widthHint = -1;
    private int heightHint = -1;
    private static long t = -1L;

    public MindMapPreviewBuilder(IWorkbook workbook) {
        this.workbook = workbook;
        this.sheet = workbook.getPrimarySheet();
        this.centralTopic = this.sheet.getRootTopic();
    }

    public MindMapPreviewBuilder(ISheet sheet, ITopic centralTopic) {
        this.workbook = sheet.getOwnedWorkbook();
        this.sheet = sheet;
        this.centralTopic = centralTopic;
    }

    public void setProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.set(key, value);
    }

    public ITopic getCentralTopic() {
        return this.centralTopic;
    }

    public ISheet getSheet() {
        return this.sheet;
    }

    public IWorkbook getWorkbook() {
        return this.workbook;
    }

    public void setResizeStrategy(int resizeStrategy, int widthHint, int heightHint) {
        this.resizeStrategy = resizeStrategy;
        this.widthHint = widthHint;
        this.heightHint = heightHint;
    }

    public int getResizeStrategy() {
        return this.resizeStrategy;
    }

    public int getWidthHint() {
        return this.widthHint;
    }

    public int getHeightHint() {
        return this.heightHint;
    }

    public String build(Display display) throws IOException {
        String path = Core.getWorkspace().getTempFile(this.newTempFileName());
        this.build(display, path);
        return path;
    }

    public void build(Display display, String targetPath) throws IOException {
        FileOutputStream out = new FileOutputStream(targetPath);
        try {
            this.build(display, null, out);
        }
        finally {
            out.close();
        }
    }

    public String build(Composite parent) throws IOException {
        String path = Core.getWorkspace().getTempFile(this.newTempFileName());
        this.build(parent, path);
        return path;
    }

    public void build(Composite parent, String targetPath) throws IOException {
        FileOutputStream out = new FileOutputStream(targetPath);
        try {
            this.build(null, parent, out);
        }
        finally {
            out.close();
        }
    }

    private void build(Display display, Composite parent, OutputStream out) throws IOException {
        ImageLoader saver;
        MindMapImageExtractor imageExtractor;
        ISheet sheet = this.getSheet();
        ITopic centralTopic = this.getCentralTopic();
        if (parent != null && !parent.isDisposed()) {
            display = parent.getDisplay();
            imageExtractor = new MindMapImageExtractor(parent, sheet, centralTopic);
        } else {
            imageExtractor = new MindMapImageExtractor(display, sheet, centralTopic);
        }
        imageExtractor.setResizeStrategy(this.resizeStrategy, this.widthHint, this.heightHint);
        if (this.properties != null) {
            for (String key : this.properties.keySet()) {
                imageExtractor.setProperty(key, this.properties.get(key));
            }
        }
        try {
            saver = new ImageLoader();
            MindMapPreviewBuilder.log("Start building");
            MindMapPreviewBuilder.log("Start building image");
            try {
                display.syncExec(new Runnable(){

                    public void run() {
                        Image image = imageExtractor.getImage();
                        MindMapPreviewBuilder.log("End building image");
                        MindMapPreviewBuilder.this.origin = imageExtractor.getOrigin();
                        MindMapPreviewBuilder.log("Start getting image data");
                        saver.data = new ImageData[]{image.getImageData()};
                    }
                });
            }
            catch (Throwable e) {
                Logger.log(e);
                imageExtractor.dispose();
                try {
                    out.close();
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            imageExtractor.dispose();
            try {
                out.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        MindMapPreviewBuilder.log("End getting image data");
        MindMapPreviewBuilder.log("Start saving image data");
        saver.save(out, this.getFormat().getSWTFormat());
        MindMapPreviewBuilder.log("End saving image data");
        imageExtractor.dispose();
        try {
            out.close();
        }
        catch (IOException iOException) {}
    }

    public Point getOrigin() {
        return this.origin;
    }

    private static void log(String message) {
        if (!DEBUG) {
            return;
        }
        if (t < 0L) {
            t = System.currentTimeMillis();
        }
        long c = System.currentTimeMillis();
        System.out.println("[" + (c - t) + "] " + message);
        t = c;
    }

    public void save(Display display) throws IOException {
        IManifest manifest = this.workbook.getManifest();
        IFileEntry entry = this.createThumbnailEntry(manifest, false);
        OutputStream out = entry.getOutputStream();
        if (out == null) {
            throw new IOException("No output stream is available on this entry.");
        }
        this.build(display, null, out);
        entry.decreaseReference();
        entry.increaseReference();
    }

    public void save(Composite parent) throws IOException {
        IManifest manifest = this.workbook.getManifest();
        IFileEntry entry = this.createThumbnailEntry(manifest, false);
        OutputStream out = entry.getOutputStream();
        if (out == null) {
            throw new IOException("No output stream is available on this entry.");
        }
        this.build(null, parent, out);
        entry.decreaseReference();
        entry.increaseReference();
    }

    public void saveFrom(InputStream previewStream) throws IOException {
        IManifest manifest = this.workbook.getManifest();
        IFileEntry entry = this.createThumbnailEntry(manifest, true);
        OutputStream out = entry.getOutputStream();
        if (out == null) {
            throw new IOException("No output stream is available on this entry.");
        }
        FileUtils.transfer((InputStream)previewStream, (OutputStream)out, (boolean)true);
        entry.decreaseReference();
        entry.increaseReference();
    }

    public void saveFrom(String previewLocation) throws IOException {
        this.saveFrom(new FileInputStream(previewLocation));
    }

    private IFileEntry createThumbnailEntry(IManifest manifest, boolean ignoreEncryption) {
        IFileEntry entry = manifest.createFileEntry(PATH_THUMBNAIL, this.getFormat().getMediaType());
        ((FileEntryImpl)entry).setIgnoreEncryption(ignoreEncryption);
        return entry;
    }

    private String newTempFileName() {
        return "export/" + Core.getIdFactory().createId() + (String)this.getFormat().getExtensions().get(0);
    }

    public ImageFormat getFormat() {
        if (this.format == null) {
            this.format = DEFAULT_FORMAT;
        }
        return this.format;
    }

    public void setFormat(ImageFormat format) {
        this.format = format;
    }
}

