/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xmind.core.IBoundary;
import org.xmind.core.IControlPoint;
import org.xmind.core.IFileEntry;
import org.xmind.core.IHtmlNotesContent;
import org.xmind.core.IImage;
import org.xmind.core.IImageSpan;
import org.xmind.core.ILegend;
import org.xmind.core.IManifest;
import org.xmind.core.INotes;
import org.xmind.core.INumbering;
import org.xmind.core.IParagraph;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.IPositioned;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ISpan;
import org.xmind.core.ITextSpan;
import org.xmind.core.ITitled;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.style.IStyled;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.core.util.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMind2008Exporter {
    private IWorkbook sourceWorkbook;
    private String targetPath;
    private IProgressMonitor monitor;
    private Document contentDocument;
    private Document styleDocument;
    private Document metaDocument;
    private Document manifestDocument;

    public XMind2008Exporter(IWorkbook sourceWorkbook, String targetPath) {
        this.sourceWorkbook = sourceWorkbook;
        this.targetPath = targetPath;
    }

    public IProgressMonitor getMonitor() {
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public IWorkbook getSourceWorkbook() {
        return this.sourceWorkbook;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public void export() throws InvocationTargetException, InterruptedException {
        this.saveContent();
        this.saveStyles();
        this.saveMeta();
        this.saveManifest();
        try {
            ZipOutputStream os = new ZipOutputStream(new FileOutputStream(this.getTargetPath()));
            try {
                os.putNextEntry(new ZipEntry("content.xml"));
                this.save(os, this.contentDocument);
                os.putNextEntry(new ZipEntry("styles.xml"));
                this.save(os, this.styleDocument);
                os.putNextEntry(new ZipEntry("meta.xml"));
                this.save(os, this.metaDocument);
                os.putNextEntry(new ZipEntry("META-INF/manifest.xml"));
                this.save(os, this.manifestDocument);
                IManifest manifest = this.sourceWorkbook.getManifest();
                for (IFileEntry entry : manifest.getFileEntries()) {
                    String path;
                    if (entry.isDirectory() || !this.shouldCopyEntry(path = entry.getPath())) continue;
                    this.copyEntry(os, entry, path);
                }
            }
            catch (Throwable throwable) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void copyEntry(ZipOutputStream os, IFileEntry entry, String path) throws InvocationTargetException {
        InputStream is = entry.getInputStream();
        if (is == null) {
            return;
        }
        if (path.startsWith("attachments/")) {
            path = XMind2008Exporter.upperFirst(path);
        }
        try {
            try {
                os.putNextEntry(new ZipEntry(path));
                FileUtils.transfer((InputStream)is, (OutputStream)os, (boolean)false);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {}
    }

    private boolean shouldCopyEntry(String path) {
        return !"content.xml".equals(path) && !"styles.xml".equals(path) && !"meta.xml".equals(path) && !"META-INF/manifest.xml".equals(path);
    }

    private void saveManifest() throws InvocationTargetException {
        Element docEle;
        this.manifestDocument = this.createDocument();
        Document sourceDoc = (Document)this.sourceWorkbook.getManifest().getAdapter(Document.class);
        if (sourceDoc != null) {
            docEle = (Element)this.manifestDocument.importNode(sourceDoc.getDocumentElement(), true);
            this.downgradeManifest(docEle);
            this.manifestDocument.appendChild(docEle);
        } else {
            docEle = DOMUtils.createElement((Node)this.manifestDocument, (String)"manifest");
        }
        docEle.setAttribute("xmlns", "urn:xmind:xmap:xmlns:manifest:1.0");
    }

    private void downgradeManifest(Element element) {
        if ("file-entry".equals(element.getTagName())) {
            String path = element.getAttribute("full-path");
            if (path.startsWith("attachments/")) {
                path = XMind2008Exporter.upperFirst(path);
            }
            element.setAttribute("full-path", path);
        }
        Iterator it = DOMUtils.childElementIter((Node)element);
        while (it.hasNext()) {
            this.downgradeManifest((Element)it.next());
        }
    }

    private void saveMeta() throws InvocationTargetException {
        this.metaDocument = this.createDocument();
        Element docEle = DOMUtils.createElement((Node)this.metaDocument, (String)"xmap-meta");
        docEle.setAttribute("xmlns", "urn:xmind:xmap:xmlns:meta:1.0");
        docEle.setAttribute("version", "1.0");
    }

    private void saveStyles() throws InvocationTargetException {
        this.styleDocument = this.createDocument();
        Element docEle = DOMUtils.createElement((Node)this.styleDocument, (String)"xmap-styles");
        docEle.setAttribute("xmlns", "urn:xmind:xmap:xmlns:style:1.0");
        docEle.setAttribute("xmlns:fo", "http://www.w3.org/1999/XSL/Format");
        docEle.setAttribute("xmlns:svg", "http://www.w3.org/2000/svg");
        docEle.setAttribute("version", "1.0");
        docEle.setAttribute("version", "1.0");
        IStyleSheet styleSheet = this.sourceWorkbook.getStyleSheet();
        if (styleSheet.isEmpty()) {
            return;
        }
        this.saveStyleContent(docEle, styleSheet);
    }

    private void saveStyleContent(Element docEle, IStyleSheet styleSheet) {
        Document sourceDoc = (Document)styleSheet.getAdapter(Document.class);
        if (sourceDoc == null) {
            return;
        }
        Element sourceDocEle = sourceDoc.getDocumentElement();
        Iterator it = DOMUtils.childElementIter((Node)sourceDocEle);
        Document doc = docEle.getOwnerDocument();
        while (it.hasNext()) {
            Element sourceEle = (Element)it.next();
            Element targetEle = (Element)doc.importNode(sourceEle, true);
            this.downgradeStyles(targetEle);
            docEle.appendChild(targetEle);
        }
    }

    private void downgradeStyles(Element element) {
        this.downgradeStyle(element);
        Iterator it = DOMUtils.childElementIter((Node)element);
        while (it.hasNext()) {
            this.downgradeStyles((Element)it.next());
        }
    }

    private void downgradeStyle(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        Map<String, String> added = null;
        int i = 0;
        while (i < attributes.getLength()) {
            Attr attr = (Attr)attributes.item(i);
            String name = attr.getName();
            String value = attr.getValue();
            if ("type".equals(name)) {
                attr.setValue(XMind2008Exporter.upperFirst(value));
            } else if ("style-family".equals(name)) {
                attr.setValue(XMind2008Exporter.upperFirst(value));
            } else if ("multi-line-colors".equals(name)) {
                if (value != null && !"none".equals(value)) {
                    added = this.add(added, "rainbowcolor", "true");
                }
            } else if ("line-tapered".equals(name) && value.contains("tapered")) {
                added = this.add(added, "spinylines", "true");
            }
            if ("none".equals(value)) {
                attr.setValue("$none$");
            } else if (HyperlinkUtils.isAttachmentURL((String)value)) {
                value = this.toAttachmentURL(value);
                attr.setValue(value);
            }
            ++i;
        }
        if (added != null) {
            for (Map.Entry e : added.entrySet()) {
                element.setAttribute((String)e.getKey(), (String)e.getValue());
            }
        }
    }

    private Map<String, String> add(Map<String, String> map, String key, String value) {
        if (map == null) {
            map = new HashMap<String, String>();
        }
        map.put(key, value);
        return map;
    }

    private void save(OutputStream os, Document document) throws InvocationTargetException {
        try {
            DOMUtils.save((Node)document, (OutputStream)os, (boolean)false);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    private void saveContent() throws InvocationTargetException {
        this.contentDocument = this.createDocument();
        Element docEle = DOMUtils.createElement((Node)this.contentDocument, (String)"xmap-content");
        docEle.setAttribute("xmlns", "urn:xmind:xmap:xmlns:content:1.0");
        docEle.setAttribute("xmlns:xhtml", "http://www.w3.org/1999/xhtml");
        docEle.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        docEle.setAttribute("xmlns:fo", "http://www.w3.org/1999/XSL/Format");
        docEle.setAttribute("xmlns:svg", "http://www.w3.org/2000/svg");
        docEle.setAttribute("version", "1.0");
        this.saveMaps(docEle);
    }

    private void saveMaps(Element parentEle) {
        for (ISheet sheet : this.sourceWorkbook.getSheets()) {
            this.saveMap(parentEle, sheet);
        }
    }

    private void saveMap(Element parentEle, ISheet sheet) {
        Element mapEle = DOMUtils.createElement((Node)parentEle, (String)"map");
        DOMUtils.replaceId((Element)mapEle, (String)sheet.getId());
        this.saveTheme(mapEle, sheet);
        this.saveTitle(mapEle, (ITitled)sheet);
        this.saveStyle(mapEle, (IStyled)sheet);
        this.saveRootTopic(mapEle, sheet);
        this.saveRelationships(mapEle, sheet.getRelationships());
        this.saveLegend(mapEle, sheet.getLegend());
    }

    private void saveTheme(Element mapEle, ISheet sheet) {
        DOMUtils.setAttribute((Element)mapEle, (String)"theme", (Object)sheet.getThemeId());
    }

    private void saveRootTopic(Element mapEle, ISheet sheet) {
        Element rootTopicEle = DOMUtils.createElement((Node)mapEle, (String)"root-topic");
        this.saveTopic(rootTopicEle, sheet.getRootTopic());
    }

    private void saveTopic(Element topicEle, ITopic topic) {
        DOMUtils.replaceId((Element)topicEle, (String)topic.getId());
        this.saveFolded(topicEle, topic);
        this.saveHyperlink(topicEle, topic);
        this.saveStructureClass(topicEle, topic);
        this.saveStyle(topicEle, (IStyled)topic);
        this.saveTitle(topicEle, (ITitled)topic);
        this.savePosition(topicEle, (IPositioned)topic);
        this.saveImage(topicEle, topic);
        this.saveLabels(topicEle, topic);
        this.saveMarkers(topicEle, topic);
        this.saveNotes(topicEle, topic);
        this.saveNumbering(topicEle, topic);
        this.saveAttachedSubtopics(topicEle, topic.getChildren("attached"));
        this.saveDetachedSubtopics(topicEle, topic.getChildren("detached"));
        this.saveDetachedSubtopics(topicEle, topic.getChildren("summary"));
        this.saveBoundaries(topicEle, topic);
    }

    private void saveBoundaries(Element topicEle, ITopic topic) {
        Set boundaries = topic.getBoundaries();
        if (boundaries.isEmpty()) {
            return;
        }
        Element boundariesEle = DOMUtils.createElement((Node)topicEle, (String)"boundaries");
        for (IBoundary boundary : boundaries) {
            this.saveBoundary(boundariesEle, boundary);
        }
    }

    private void saveBoundary(Element boundariesEle, IBoundary boundary) {
        Element boundaryEle = DOMUtils.createElement((Node)boundariesEle, (String)"boundary");
        DOMUtils.setAttribute((Element)boundaryEle, (String)"start-index", (Object)String.valueOf(boundary.getStartIndex()));
        DOMUtils.setAttribute((Element)boundaryEle, (String)"end-index", (Object)String.valueOf(boundary.getEndIndex()));
        this.saveStyle(boundaryEle, (IStyled)boundary);
    }

    private void saveDetachedSubtopics(Element topicEle, List<ITopic> subtopics) {
        if (subtopics.isEmpty()) {
            return;
        }
        Element subtopicsEle = DOMUtils.createElement((Node)topicEle, (String)"detached-topics");
        this.saveSubtopics(subtopicsEle, subtopics);
    }

    private void saveAttachedSubtopics(Element topicEle, List<ITopic> subtopics) {
        if (subtopics.isEmpty()) {
            return;
        }
        Element subtopicsEle = DOMUtils.createElement((Node)topicEle, (String)"attached-topics");
        this.saveSubtopics(subtopicsEle, subtopics);
    }

    private void saveSubtopics(Element subtopicsEle, List<ITopic> subtopics) {
        for (ITopic subtopic : subtopics) {
            Element subtopicEle = DOMUtils.createElement((Node)subtopicsEle, (String)"topic");
            this.saveTopic(subtopicEle, subtopic);
        }
    }

    private void saveNumbering(Element topicEle, ITopic topic) {
        INumbering numbering = topic.getNumbering();
        String format = numbering.getNumberFormat();
        String prefix = numbering.getPrefix();
        String suffix = numbering.getSuffix();
        boolean prepend = numbering.prependsParentNumbers();
        if (prepend && format == null && prefix == null && suffix == null) {
            return;
        }
        Element numEle = DOMUtils.createElement((Node)topicEle, (String)"numbering");
        if (!prepend) {
            DOMUtils.setAttribute((Element)numEle, (String)"inherited", (Object)"false");
        }
        if (format != null) {
            DOMUtils.setAttribute((Element)numEle, (String)"number-format", (Object)format);
        }
        if (prefix != null) {
            DOMUtils.setAttribute((Element)numEle, (String)"prefix", (Object)prefix);
        }
        if (suffix != null) {
            DOMUtils.setAttribute((Element)numEle, (String)"suffix", (Object)suffix);
        }
    }

    private void saveNotes(Element topicEle, ITopic topic) {
        IHtmlNotesContent html;
        INotes notes = topic.getNotes();
        if (notes.isEmpty()) {
            return;
        }
        Element notesEle = DOMUtils.createElement((Node)topicEle, (String)"notes");
        IPlainNotesContent plain = (IPlainNotesContent)notes.getContent("plain");
        if (plain != null) {
            String textContent = plain.getTextContent();
            DOMUtils.createText((Node)notesEle, (String)"plain", (String)textContent);
        }
        if ((html = (IHtmlNotesContent)notes.getContent("html")) != null) {
            this.saveHtmlNotesContent(notesEle, html, topic.getOwnedWorkbook());
        }
    }

    private void saveHtmlNotesContent(Element notesEle, IHtmlNotesContent html, IWorkbook workbook) {
        Element richEle = DOMUtils.createElement((Node)notesEle, (String)"rich");
        for (IParagraph p : html.getParagraphs()) {
            Element pEle = DOMUtils.createElement((Node)richEle, (String)"xhtml:p");
            this.saveStyle(pEle, (IStyled)p);
            for (ISpan span : p.getSpans()) {
                if (span instanceof IImageSpan) {
                    this.saveImageSpan(pEle, (IImageSpan)span);
                    continue;
                }
                this.saveTextSpan(pEle, (ITextSpan)span);
            }
        }
    }

    private void saveImageSpan(Element pEle, IImageSpan span) {
        String source = span.getSource();
        if (source == null) {
            return;
        }
        if (HyperlinkUtils.isAttachmentURL((String)source)) {
            source = this.toAttachmentURL(source);
        }
        Element imgEle = DOMUtils.createElement((Node)pEle, (String)"xhtml:img");
        DOMUtils.setAttribute((Element)imgEle, (String)"xhtml:src", (Object)source);
    }

    private void saveTextSpan(Element pEle, ITextSpan span) {
        String styleId = span.getStyleId();
        if (styleId == null) {
            Text textNode = pEle.getOwnerDocument().createTextNode(span.getTextContent());
            pEle.appendChild(textNode);
        } else {
            Element spanEle = DOMUtils.createElement((Node)pEle, (String)"xhtml:span");
            DOMUtils.setAttribute((Element)spanEle, (String)"style-id", (Object)styleId);
            spanEle.setTextContent(span.getTextContent());
        }
    }

    private void saveMarkers(Element topicEle, ITopic topic) {
        Set markerRefs = topic.getMarkerRefs();
        if (markerRefs.isEmpty()) {
            return;
        }
        Element markersEle = DOMUtils.createElement((Node)topicEle, (String)"markers");
        IMarkerSheet markerSheet = topic.getOwnedWorkbook().getMarkerSheet();
        for (IMarkerRef mr : markerRefs) {
            Element markerEle = DOMUtils.createElement((Node)markersEle, (String)"marker");
            IMarker marker = mr.getMarker();
            if (marker == null) continue;
            IMarkerSheet ownedSheet = marker.getOwnedSheet();
            String type = ownedSheet != null && !ownedSheet.equals(markerSheet) ? "Brainy" : "User";
            IMarkerGroup group = marker.getParent();
            String id = group != null ? "#" + group.getId() + "/" + marker.getId() : marker.getId();
            DOMUtils.setAttribute((Element)markerEle, (String)"id", (Object)id);
            DOMUtils.setAttribute((Element)markerEle, (String)"type", (Object)type);
        }
    }

    private void saveLabels(Element topicEle, ITopic topic) {
        Set labels = topic.getLabels();
        if (labels.isEmpty()) {
            return;
        }
        Element labelsEle = DOMUtils.createElement((Node)topicEle, (String)"labels");
        for (String label : labels) {
            Element labelEle = DOMUtils.createElement((Node)labelsEle, (String)"label");
            labelEle.setTextContent(label);
        }
    }

    private void saveImage(Element topicEle, ITopic topic) {
        int height;
        IImage image = topic.getImage();
        String source = image.getSource();
        if (source == null) {
            return;
        }
        Element imgEle = DOMUtils.createElement((Node)topicEle, (String)"xhtml:img");
        if (HyperlinkUtils.isAttachmentURL((String)source)) {
            source = this.toAttachmentURL(source);
        }
        DOMUtils.setAttribute((Element)imgEle, (String)"xhtml:src", (Object)source);
        int width = image.getWidth();
        if (width != -1) {
            DOMUtils.setAttribute((Element)imgEle, (String)"svg:width", (Object)String.valueOf(width));
        }
        if ((height = image.getHeight()) != -1) {
            DOMUtils.setAttribute((Element)imgEle, (String)"svg:height", (Object)String.valueOf(height));
        }
        DOMUtils.setAttribute((Element)imgEle, (String)"align", (Object)image.getAlignment());
    }

    private void saveHyperlink(Element topicEle, ITopic topic) {
        String url = topic.getHyperlink();
        if (url == null) {
            return;
        }
        if (HyperlinkUtils.isAttachmentURL((String)url)) {
            url = this.toAttachmentURL(url);
        }
        DOMUtils.setAttribute((Element)topicEle, (String)"xlink:href", (Object)url);
    }

    private String toAttachmentURL(String url) {
        String path = HyperlinkUtils.toAttachmentPath((String)url);
        String attId = FileUtils.getNoExtensionFileName((String)path);
        return HyperlinkUtils.toAttachmentURL((String)("#" + attId));
    }

    private void savePosition(Element element, IPositioned positionOwner) {
        if (positionOwner.hasPosition()) {
            this.savePosition(element, positionOwner.getPosition());
        }
    }

    private void saveFolded(Element topicEle, ITopic topic) {
        if (topic.isFolded()) {
            DOMUtils.setAttribute((Element)topicEle, (String)"extended", (Object)"false");
        }
    }

    private void saveStructureClass(Element topicEle, ITopic topic) {
        String structureClass = topic.getStructureClass();
        structureClass = this.downgradeStructureClass(structureClass);
        DOMUtils.setAttribute((Element)topicEle, (String)"structure-class", (Object)structureClass);
    }

    private String downgradeStructureClass(String structureClass) {
        if (structureClass == null) {
            return null;
        }
        if ("org.xmind.ui.logic.left".equals(structureClass)) {
            structureClass = "org.xmind.branchPolicy.org-chart.left";
        } else if ("org.xmind.ui.logic.right".equals(structureClass)) {
            structureClass = "org.xmind.branchPolicy.org-chart.right";
        } else if ("org.xmind.ui.spreadsheet".equals(structureClass)) {
            structureClass = "org.xmind.branchPolicy.chart2d";
        } else if (structureClass.startsWith("org.xmind.ui.")) {
            structureClass = "org.xmind.branchPolicy." + structureClass.substring(13);
        }
        return structureClass;
    }

    private void savePosition(Element element, Point p) {
        if (p == null) {
            return;
        }
        Element posEle = DOMUtils.createElement((Node)element, (String)"position");
        DOMUtils.setAttribute((Element)posEle, (String)"svg:x", (Object)String.valueOf(p.x));
        DOMUtils.setAttribute((Element)posEle, (String)"svg:y", (Object)String.valueOf(p.y));
    }

    private void saveLegend(Element parentEle, ILegend legend) {
        Element legendEle = DOMUtils.createElement((Node)parentEle, (String)"legend");
        if (legend.isVisible()) {
            DOMUtils.setAttribute((Element)legendEle, (String)"svg:visibility", (Object)"visible");
        }
        this.savePosition(legendEle, (IPositioned)legend);
        for (String markerId : legend.getMarkerIds()) {
            Element markerDescriptionEle = DOMUtils.createElement((Node)legendEle, (String)"marker");
            DOMUtils.replaceId((Element)markerDescriptionEle, (String)markerId);
            DOMUtils.setAttribute((Element)markerDescriptionEle, (String)"description", (Object)legend.getMarkerDescription(markerId));
        }
    }

    private void saveRelationships(Element parentEle, Set<IRelationship> relationships) {
        if (relationships.isEmpty()) {
            return;
        }
        Element relationshipsEle = DOMUtils.createElement((Node)parentEle, (String)"relationships");
        for (IRelationship relationship : relationships) {
            this.saveRelationship(relationshipsEle, relationship);
        }
    }

    private void saveRelationship(Element relationshipsEle, IRelationship relationship) {
        Element relationshipEle = DOMUtils.createElement((Node)relationshipsEle, (String)"relationship");
        DOMUtils.replaceId((Element)relationshipEle, (String)relationship.getId());
        DOMUtils.setAttribute((Element)relationshipEle, (String)"from-id", (Object)relationship.getEnd1Id());
        DOMUtils.setAttribute((Element)relationshipEle, (String)"to-id", (Object)relationship.getEnd2Id());
        this.saveStyle(relationshipEle, (IStyled)relationship);
        this.saveTitle(relationshipEle, (ITitled)relationship);
        this.saveControlPoint(relationshipEle, relationship.getControlPoint(0), 0);
    }

    private void saveControlPoint(Element relationshipEle, IControlPoint controlPoint, int index) {
        Point position = controlPoint.getPosition();
        if (position == null) {
            return;
        }
        String attrName = "control-point" + String.valueOf(index + 1);
        String value = String.format("%d, %d", position.x, position.y);
        DOMUtils.setAttribute((Element)relationshipEle, (String)attrName, (Object)value);
    }

    private void saveStyle(Element element, IStyled styleOwner) {
        if (styleOwner == null) {
            return;
        }
        String styleId = styleOwner.getStyleId();
        if (styleId == null) {
            return;
        }
        DOMUtils.setAttribute((Element)element, (String)"style-id", (Object)styleId);
    }

    private void saveTitle(Element element, ITitled titleOwner) {
        if (titleOwner == null || !titleOwner.hasTitle()) {
            return;
        }
        DOMUtils.setText((Node)element, (String)"title", (String)titleOwner.getTitleText());
    }

    private Document createDocument() throws InvocationTargetException {
        try {
            return DOMUtils.doCreateDocument();
        }
        catch (ParserConfigurationException e) {
            throw new InvocationTargetException(e);
        }
    }

    private static String upperFirst(String string) {
        return String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1);
    }
}

