/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.xmind.core.INotesContent;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.ISheet;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.ui.internal.wizards.ITextExportPart;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.wizards.ExportPart;
import org.xmind.ui.wizards.ExportUtils;
import org.xmind.ui.wizards.Exporter;
import org.xmind.ui.wizards.IExportPart;
import org.xmind.ui.wizards.IExporter;
import org.xmind.ui.wizards.RelationshipDescription;

class TextExporter
extends Exporter {
    private PrintStream ps;

    public TextExporter(ISheet sheet, ITopic centralTopic) {
        super(sheet, centralTopic);
    }

    public void setPrintStream(PrintStream ps) {
        this.ps = ps;
    }

    public boolean canStart() {
        return super.canStart() && this.ps != null;
    }

    protected void write(IProgressMonitor monitor, IExportPart part) throws InvocationTargetException, InterruptedException {
        if (this.ps == null) {
            return;
        }
        if (part instanceof ITextExportPart) {
            ((ITextExportPart)part).write(this.ps);
        }
    }

    public void init() {
        this.appendTopic(this.getCentralTopic());
    }

    private void appendTopic(ITopic topic) {
        if (!topic.equals(this.getCentralTopic())) {
            this.append(new EmptyLinePart(this));
        }
        this.append(new TitlePart((IExporter)this, topic));
        this.collectTopicContent(topic);
    }

    private void collectTopicContent(ITopic topic) {
        List<RelationshipDescription> relationships;
        INotesContent content;
        Set markers = topic.getMarkerRefs();
        Set labels = topic.getLabels();
        if (!markers.isEmpty() || !labels.isEmpty()) {
            this.append(new TagsPart(this, topic, markers, labels));
        }
        if ((content = topic.getNotes().getContent("plain")) instanceof IPlainNotesContent) {
            this.append(new EmptyLinePart(this));
            this.append(new NotesPart((IExporter)this, (IPlainNotesContent)content));
        }
        if (!(relationships = ExportUtils.getRelationships(topic, this.getRelationships())).isEmpty()) {
            this.append(new EmptyLinePart(this));
            this.append(new RelationshipsPart(this, topic, relationships));
        }
        for (ITopic child : topic.getChildren("attached")) {
            this.appendTopic(child);
        }
        for (ISummary summary : topic.getSummaries()) {
            ITopic summaryTopic = summary.getTopic();
            if (summaryTopic == null) continue;
            this.appendSummaryTopic(topic, summary, summaryTopic);
        }
        for (ITopic child : topic.getChildren("detached")) {
            this.appendTopic(child);
        }
    }

    private void appendSummaryTopic(ITopic parent, ISummary summary, ITopic summaryTopic) {
        this.append(new EmptyLinePart(this));
        this.append(new TitlePart((IExporter)this, summaryTopic));
        this.append(new SummaryPart((IExporter)this, summary));
        this.collectTopicContent(summaryTopic);
    }

    private static class EmptyLinePart
    extends ExportPart
    implements ITextExportPart {
        public EmptyLinePart(IExporter exporter) {
            this(exporter, 1);
        }

        public EmptyLinePart(IExporter exporter, int lineNumber) {
            super(exporter, lineNumber);
        }

        public void write(PrintStream ps) {
            int lineNumber = (Integer)this.getElement();
            int i = 0;
            while (i < lineNumber) {
                ps.println();
                ++i;
            }
        }
    }

    private static class NotesPart
    extends ExportPart
    implements ITextExportPart {
        public NotesPart(IExporter exporter, IPlainNotesContent element) {
            super(exporter, element);
        }

        public void write(PrintStream ps) {
            IPlainNotesContent content = (IPlainNotesContent)this.getElement();
            String textContent = content.getTextContent();
            ps.println(textContent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RelationshipsPart
    extends ExportPart
    implements ITextExportPart {
        private List<RelationshipDescription> relationships;

        public RelationshipsPart(IExporter exporter, ITopic element, List<RelationshipDescription> relationships) {
            super(exporter, element);
            this.relationships = relationships;
        }

        @Override
        public void write(PrintStream ps) {
            ps.print(WizardMessages.Export_SeeAlso);
            ps.print(' ');
            Iterator<RelationshipDescription> relIt = this.relationships.iterator();
            while (relIt.hasNext()) {
                ps.print(relIt.next().description);
                if (!relIt.hasNext()) continue;
                ps.print(", ");
            }
            ps.println();
        }
    }

    private static class SummaryPart
    extends ExportPart
    implements ITextExportPart {
        public SummaryPart(IExporter exporter, ISummary summary) {
            super(exporter, summary);
        }

        public void write(PrintStream ps) {
            ISummary summary = (ISummary)this.getElement();
            ps.print('(');
            List topics = summary.getEnclosingTopics();
            Iterator topicIt = topics.iterator();
            while (topicIt.hasNext()) {
                ITopic topic = (ITopic)topicIt.next();
                ps.print(topic.getTitleText());
                if (!topicIt.hasNext()) continue;
                ps.print(", ");
            }
            ps.println(')');
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TagsPart
    extends ExportPart
    implements ITextExportPart {
        private Set<IMarkerRef> markers;
        private Set<String> labels;

        public TagsPart(IExporter exporter, ITopic element, Set<IMarkerRef> markers, Set<String> labels) {
            super(exporter, element);
            this.markers = markers;
            this.labels = labels;
        }

        @Override
        public void write(PrintStream ps) {
            ps.print(WizardMessages.Export_Tags);
            ps.print(' ');
            boolean hasMarkers = false;
            boolean hasLabels = !this.labels.isEmpty();
            Iterator<IMarkerRef> markerIt = this.markers.iterator();
            while (markerIt.hasNext()) {
                IMarker marker = markerIt.next().getMarker();
                if (marker == null) continue;
                hasMarkers = true;
                ps.print(marker.getName());
                if (!markerIt.hasNext()) continue;
                ps.print(", ");
            }
            if (hasMarkers && hasLabels) {
                ps.print(", ");
            }
            if (hasLabels) {
                Iterator<String> labelIt = this.labels.iterator();
                while (labelIt.hasNext()) {
                    ps.print(labelIt.next());
                    if (!labelIt.hasNext()) continue;
                    ps.print(", ");
                }
            }
            ps.println();
        }
    }

    private static class TitlePart
    extends ExportPart
    implements ITextExportPart {
        public TitlePart(IExporter exporter, ITopic element) {
            super(exporter, element);
        }

        public void write(PrintStream ps) {
            ITopic topic = (ITopic)this.getElement();
            String numberingText = ExportUtils.getNumberingText(topic, this.getExporter().getCentralTopic());
            if (numberingText != null && !"".equals(numberingText)) {
                ps.print(numberingText);
                ps.print(' ');
            }
            ps.println(topic.getTitleText());
        }
    }
}

