/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import java.io.File;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.xmind.ui.browser.BrowserSupport;
import org.xmind.ui.internal.MarkerImpExpUtils;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.wizards.WizardMessages;

public class MarkerImportWizard
extends Wizard
implements IImportWizard {
    private static final String PAGE_NAME = "org.xmind.ui.MarkerImportWizardPage";
    private boolean openMarkerManagerPageOnFinish;
    private String sourcePath;
    private IWorkbench workbench;

    public MarkerImportWizard() {
        this(true);
    }

    public MarkerImportWizard(boolean openMarkerManagerPageOnFinish) {
        this.openMarkerManagerPageOnFinish = openMarkerManagerPageOnFinish;
        this.setWindowTitle(WizardMessages.MarkerImportWizard_windowTitle);
    }

    public void addPages() {
        this.addPage((IWizardPage)new MarkerImportWizardPage());
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public boolean hasSourcePath() {
        return this.sourcePath != null;
    }

    public boolean performFinish() {
        final boolean[] finished = new boolean[1];
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                MarkerImpExpUtils.importMarkerPackage(MarkerImportWizard.this.sourcePath);
                finished[0] = true;
                if (MarkerImportWizard.this.openMarkerManagerPageOnFinish) {
                    MarkerImportWizard.this.openMarkerManagerPage();
                } else {
                    MarkerImportWizard.this.openMarkerView();
                }
            }

            public void handleException(Throwable e) {
                finished[0] = false;
                super.handleException(e);
            }
        });
        return finished[0];
    }

    private void openMarkerView() {
        IWorkbenchPage page;
        IWorkbenchWindow window;
        if (this.workbench != null && (window = this.workbench.getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
            try {
                page.showView("org.xmind.ui.MarkerView");
            }
            catch (PartInitException partInitException) {}
        }
    }

    private void openMarkerManagerPage() {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                PreferencesUtil.createPreferenceDialogOn(null, (String)"org.xmind.ui.MarkersPrefPage", null, null).open();
            }
        });
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
    }

    private class MarkerImportWizardPage
    extends WizardPage {
        private Button fromFileButton;
        private Button fromDirectoryButton;
        private Text fileInput;
        private Button fileBrowseButton;
        private Text folderInput;
        private Button folderBrowseButton;
        private FormToolkit formToolkit;
        private boolean modifyingPathInput;
        private boolean settingTargetPath;
        private boolean pathModified;
        private Listener widgetListener;

        protected MarkerImportWizardPage() {
            super(MarkerImportWizard.PAGE_NAME, WizardMessages.MarkerImportPage_title, null);
            this.modifyingPathInput = false;
            this.settingTargetPath = false;
            this.pathModified = false;
            this.setDescription(WizardMessages.MarkerImportPage_description);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 5;
            gridLayout.marginHeight = 5;
            gridLayout.verticalSpacing = 5;
            gridLayout.horizontalSpacing = 5;
            composite.setLayout((Layout)gridLayout);
            this.setControl((Control)composite);
            this.formToolkit = new FormToolkit(parent.getDisplay());
            composite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MarkerImportWizardPage.this.formToolkit.dispose();
                }
            });
            this.formToolkit.setBackground(null);
            this.fromFileButton = new Button(composite, 16);
            this.fromFileButton.setText(WizardMessages.ImportPage_FromFile_text);
            this.hookWidget((Widget)this.fromFileButton, 13);
            Control fileGroup = this.createFileControls(composite);
            fileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            Label blank = new Label(composite, 0);
            blank.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            blank.setText(" ");
            this.fromDirectoryButton = new Button(composite, 16);
            this.fromDirectoryButton.setText(WizardMessages.MarkerImportPage_FromFolder_text);
            this.hookWidget((Widget)this.fromDirectoryButton, 13);
            Control directoryGroup = this.createFolderGroup(composite);
            directoryGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            this.setFileOrFolder(true);
        }

        protected Control createFileControls(Composite parent) {
            Composite group = new Composite(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            group.setLayout((Layout)layout);
            Label blank = new Label(group, 64);
            blank.setLayoutData((Object)new GridData(1, 2, false, false));
            blank.setText("  ");
            this.fileInput = new Text(group, 2052);
            if (MarkerImportWizard.this.getSourcePath() != null) {
                this.fileInput.setText(MarkerImportWizard.this.getSourcePath());
            }
            this.fileInput.setLayoutData((Object)new GridData(4, 4, true, false));
            this.hookWidget((Widget)this.fileInput, 24);
            this.hookWidget((Widget)this.fileInput, 15);
            this.fileBrowseButton = new Button(group, 8);
            this.fileBrowseButton.setText(WizardMessages.ImportPage_Browse_text);
            int width = this.fileBrowseButton.computeSize((int)-1, (int)-1).x;
            GridData layoutData = new GridData(3, 2, false, false);
            layoutData.widthHint = Math.max(93, width);
            this.fileBrowseButton.setLayoutData((Object)layoutData);
            this.hookWidget((Widget)this.fileBrowseButton, 13);
            FormText descriptionText = this.createDescriptionText(group);
            descriptionText.setText(WizardMessages.MarkerImportPage_FromFile_description, true, true);
            return group;
        }

        private FormText createDescriptionText(Composite parent) {
            FormText descriptionText = this.formToolkit.createFormText(parent, true);
            descriptionText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    final Object href = e.getHref();
                    if (href instanceof String) {
                        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                            public void run() throws Exception {
                                BrowserSupport.getInstance().createBrowser().openURL((String)href);
                            }
                        });
                    }
                }
            });
            descriptionText.setLayoutData((Object)new GridData(4, 4, true, false));
            ((GridData)descriptionText.getLayoutData()).horizontalSpan = 3;
            ((GridData)descriptionText.getLayoutData()).widthHint = 400;
            return descriptionText;
        }

        private Control createFolderGroup(Composite parent) {
            Composite group = new Composite(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            group.setLayout((Layout)layout);
            Label blank = new Label(group, 64);
            blank.setLayoutData((Object)new GridData(1, 2, false, false));
            blank.setText("  ");
            this.folderInput = new Text(group, 2052);
            if (MarkerImportWizard.this.getSourcePath() != null) {
                this.folderInput.setText(MarkerImportWizard.this.getSourcePath());
            }
            this.folderInput.setLayoutData((Object)new GridData(4, 4, true, false));
            this.hookWidget((Widget)this.folderInput, 24);
            this.hookWidget((Widget)this.folderInput, 15);
            this.folderBrowseButton = new Button(group, 8);
            this.folderBrowseButton.setText(WizardMessages.ImportPage_Browse_text);
            int width = this.folderBrowseButton.computeSize((int)-1, (int)-1).x;
            GridData layoutData = new GridData(3, 2, false, false);
            layoutData.widthHint = Math.max(93, width);
            this.folderBrowseButton.setLayoutData((Object)layoutData);
            this.hookWidget((Widget)this.folderBrowseButton, 13);
            FormText descriptionText = this.createDescriptionText(group);
            descriptionText.setText(WizardMessages.MarkerImportPage_FromFolder_description, true, true);
            return group;
        }

        protected void hookWidget(Widget widget, int eventType) {
            if (this.widgetListener == null) {
                this.widgetListener = new WidgetListener();
            }
            widget.addListener(eventType, this.widgetListener);
        }

        protected void handleWidgetEvent(Event event) {
            if (event.widget == this.fileInput) {
                if (event.type == 24) {
                    this.pathModified = true;
                    if (!this.settingTargetPath) {
                        this.modifyingPathInput = true;
                        this.setSourcePath(this.fileInput.getText());
                        this.modifyingPathInput = false;
                    }
                    this.updateStatus();
                } else if (event.type == 15) {
                    this.fileInput.setSelection(new Point(0, this.fileInput.getText().length()));
                }
            } else if (event.widget == this.fileBrowseButton) {
                this.openFileDialog();
                this.fileInput.setFocus();
            } else if (event.widget == this.folderInput) {
                if (event.type == 24) {
                    this.pathModified = true;
                    if (!this.settingTargetPath) {
                        this.modifyingPathInput = true;
                        this.setSourcePath(this.folderInput.getText());
                        this.modifyingPathInput = false;
                    }
                    this.updateStatus();
                } else if (event.type == 15) {
                    this.folderInput.setSelection(new Point(0, this.folderInput.getText().length()));
                }
            } else if (event.widget == this.folderBrowseButton) {
                this.openDirectoryDialog();
                this.folderInput.setFocus();
            } else if (event.widget == this.fromFileButton) {
                this.setFileOrFolder(true);
            } else if (event.widget == this.fromDirectoryButton) {
                this.setFileOrFolder(false);
            }
        }

        private void setFileOrFolder(boolean fileOrFolder) {
            this.fromFileButton.setSelection(fileOrFolder);
            this.fromDirectoryButton.setSelection(!fileOrFolder);
            this.fileInput.setEnabled(fileOrFolder);
            this.fileBrowseButton.setEnabled(fileOrFolder);
            this.folderInput.setEnabled(!fileOrFolder);
            this.folderBrowseButton.setEnabled(!fileOrFolder);
            Text input = fileOrFolder ? this.fileInput : this.folderInput;
            input.setFocus();
            this.setSourcePath(input.getText());
        }

        public void dispose() {
            super.dispose();
            this.fileInput = null;
            this.fileBrowseButton = null;
            this.folderBrowseButton = null;
            this.folderInput = null;
            this.modifyingPathInput = false;
            this.settingTargetPath = false;
            this.pathModified = false;
        }

        protected void openFileDialog() {
            FileDialog dialog = this.createFileDialog();
            String path = dialog.open();
            if (path != null) {
                this.setSourcePath(path);
            }
        }

        protected FileDialog createFileDialog() {
            FileDialog dialog = new FileDialog(this.getShell(), 4096);
            dialog.setText(WizardMessages.ImportPage_FileDialog_text);
            String ext = "*.xmp";
            dialog.setFilterExtensions(new String[]{ext});
            dialog.setFilterNames(new String[]{NLS.bind((String)"{0} ({1})", (Object)DialogMessages.MarkerPackageFilterName, (Object)ext)});
            if (MarkerImportWizard.this.getSourcePath() != null) {
                File file = new File(MarkerImportWizard.this.getSourcePath());
                dialog.setFilterPath(file.getParent());
                dialog.setFileName(file.getName());
            }
            return dialog;
        }

        protected void openDirectoryDialog() {
            DirectoryDialog dialog = this.createDirectoryDialog();
            String path = dialog.open();
            if (path != null) {
                this.setSourcePath(path);
            }
        }

        private DirectoryDialog createDirectoryDialog() {
            DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
            dialog.setText(WizardMessages.MarkerImportPage_FolderDialog_title);
            return dialog;
        }

        protected void updateStatus() {
            this.setPageComplete(this.isPageCompletable());
            String warningMessage = this.generateWarningMessage();
            if (warningMessage != null) {
                this.setMessage(warningMessage, 2);
            } else {
                this.setMessage(null);
            }
            this.setErrorMessage(this.generateErrorMessage());
        }

        protected String generateWarningMessage() {
            return null;
        }

        protected String generateErrorMessage() {
            if (this.pathModified && !MarkerImportWizard.this.hasSourcePath()) {
                return WizardMessages.ImportPage_FileNotExists_message;
            }
            return null;
        }

        protected boolean isPageCompletable() {
            return MarkerImportWizard.this.hasSourcePath();
        }

        protected void setSourcePath(String path) {
            MarkerImportWizard.this.setSourcePath(path);
            if (!this.modifyingPathInput) {
                this.settingTargetPath = true;
                if (this.fileInput.isEnabled()) {
                    this.fileInput.setText(path);
                } else {
                    this.folderInput.setText(path);
                }
                this.settingTargetPath = false;
            }
        }

        private class WidgetListener
        implements Listener {
            private WidgetListener() {
            }

            public void handleEvent(Event event) {
                MarkerImportWizardPage.this.handleWidgetEvent(event);
            }
        }
    }
}

