/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.core.style.IStyle;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;
import org.xmind.ui.internal.views.StyleFigureUtils;

public class StyleFigure
extends Figure {
    private static final Rectangle RECT = new Rectangle();
    private IStyle style;

    public IStyle getStyle() {
        return this.style;
    }

    public void setStyle(IStyle style) {
        if (style == this.style) {
            return;
        }
        this.style = style;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        GraphicsUtils.fixGradientBugForCarbon((Graphics)graphics, (IFigure)this);
        super.paint(graphics);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        this.drawStyle(graphics);
    }

    protected void drawStyle(Graphics graphics) {
        if (this.style == null) {
            return;
        }
        graphics.setAntialias(1);
        graphics.setTextAntialias(1);
        Rectangle r = this.getClientArea(RECT);
        this.drawStyle(graphics, this.style, r);
    }

    private void drawStyle(Graphics graphics, IStyle style, Rectangle r) {
        String type = style.getType();
        if ("topic".equalsIgnoreCase(type)) {
            StyleFigureUtils.drawTopic(graphics, StyleFigure.topicBounds(r), style, null, false);
        } else if ("boundary".equalsIgnoreCase(type)) {
            StyleFigureUtils.drawBoundary(graphics, StyleFigure.boundaryBounds(r), style, null);
        } else if ("relationship".equalsIgnoreCase(type)) {
            StyleFigureUtils.drawRelationship(graphics, StyleFigure.relBounds(r), style, null);
        } else if ("map".equalsIgnoreCase(type)) {
            StyleFigureUtils.drawSheetBackground(graphics, StyleFigure.sheetBounds(r), style, null);
        }
    }

    public static Rectangle topicBounds(Rectangle r) {
        int width = r.width * 7 / 8;
        int height = width * 9 / 20;
        int x = r.x + r.width / 2 - width / 2;
        int y = r.y + r.height / 2 - height / 2;
        return new Rectangle(x, y, width, height);
    }

    public static Rectangle boundaryBounds(Rectangle r) {
        int width = r.width * 7 / 8;
        int height = width * 7 / 10;
        int x = r.x + r.width / 2 - width / 2;
        int y = r.y + r.height / 2 - height / 2;
        return new Rectangle(x, y, width, height);
    }

    public static Rectangle relBounds(Rectangle r) {
        int width = r.width * 6 / 8;
        int height = width * 7 / 10;
        int x = r.x + r.width / 2 - width / 2;
        int y = r.y + r.height / 2 - height / 2;
        return new Rectangle(x, y, width, height);
    }

    public static Rectangle sheetBounds(Rectangle r) {
        int width = r.width * 7 / 8;
        int height = width * 7 / 8;
        int x = r.x + r.width / 2 - width / 2;
        int y = r.y + r.height / 2 - height / 2;
        return new Rectangle(x, y, width, height);
    }
}

