/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import java.util.List;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.dom.RelationshipImpl;
import org.xmind.core.internal.event.CoreEventSupport;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.draw2d.AbstractAnchor;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.ReferencedFigure;
import org.xmind.gef.draw2d.SelectionFigure;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRootPart;
import org.xmind.gef.service.IFeedback;
import org.xmind.gef.service.IFeedbackService;
import org.xmind.ui.internal.mindmap.NodePart;
import org.xmind.ui.internal.mindmap.RelationshipFeedback;
import org.xmind.ui.internal.mindmap.RelationshipPart;
import org.xmind.ui.mindmap.IConnectionPart;
import org.xmind.ui.mindmap.INodePart;
import org.xmind.ui.mindmap.IRelationshipPart;

public class RelationshipDummy {
    private IGraphicalViewer viewer;
    private INodePart sn;
    private INodePart tn;
    private IRelationshipPart rel;
    private ITopic t1;
    private ITopic t2;
    private IRelationship r;
    private IFeedbackService feedbackService;
    private RelationshipFeedback feedback;

    public RelationshipDummy(IFigure layer, IGraphicalPart sourceNode, Point cursorPosition, IGraphicalViewer viewer) {
        this.viewer = viewer;
        this.createDummyModels();
        this.sn = new DummyNodePart(sourceNode);
        this.tn = new DummyNodePart();
        this.rel = new DummyRelPart();
        this.activateParts(layer);
        ((IReferencedFigure)this.tn.getFigure()).setReference(cursorPosition);
        this.feedbackService = (IFeedbackService)viewer.getService(IFeedbackService.class);
        if (this.feedbackService != null) {
            SelectionFigure selectionDummy = this.feedbackService.setSelected(this.sn.getFigure());
            selectionDummy.setSelectionAlpha(144);
        }
    }

    public RelationshipDummy(IFigure layer, IRelationshipPart sourceRel, int pointId, IGraphicalViewer viewer) {
        this.viewer = viewer;
        this.createDummyModels();
        IRelationship sr = sourceRel.getRelationship();
        this.r.setStyleId(sr.getStyleId());
        this.r.getControlPoint(0).setPosition(sr.getControlPoint(0).getPosition());
        this.r.getControlPoint(1).setPosition(sr.getControlPoint(1).getPosition());
        this.tn = null;
        this.sn = null;
        if (pointId == 1) {
            this.sn = new DummyNodePart();
        } else if (pointId == 2) {
            this.tn = new DummyNodePart();
        }
        if (this.sn == null) {
            this.sn = new DummyNodePart(sourceRel.getSourceNode());
        }
        if (this.tn == null) {
            this.tn = new DummyNodePart(sourceRel.getTargetNode());
        }
        this.rel = new DummyRelPart();
        this.activateParts(layer);
        this.feedbackService = (IFeedbackService)viewer.getService(IFeedbackService.class);
        if (this.feedbackService != null) {
            this.feedback = new RelationshipFeedback(this.rel);
            this.feedback.setAlpha(224);
            this.feedbackService.addFeedback((IFeedback)this.feedback);
        }
    }

    private void createDummyModels() {
        ISheet sheet = (ISheet)this.viewer.getAdapter(ISheet.class);
        IWorkbook wb = sheet.getOwnedWorkbook();
        this.t1 = wb.createTopic();
        this.t2 = wb.createTopic();
        this.r = wb.createRelationship();
        this.r.setEnd1Id(this.t1.getId());
        this.r.setEnd2Id(this.t2.getId());
        ((RelationshipImpl)this.r).setCoreEventSupport((ICoreEventSupport)new CoreEventSupport());
    }

    private void activateParts(IFigure layer) {
        IRootPart root = this.viewer.getRootPart();
        this.sn.setModel(this.t1);
        this.sn.setParent((IPart)root);
        layer.add(this.sn.getFigure());
        this.sn.addNotify();
        this.sn.getStatus().activate();
        this.tn.setModel(this.t2);
        this.tn.setParent((IPart)root);
        layer.add(this.tn.getFigure());
        this.tn.addNotify();
        this.tn.getStatus().activate();
        this.rel.setModel(this.r);
        this.rel.setParent((IPart)root);
        layer.add(this.rel.getFigure());
        this.rel.addNotify();
        this.rel.getStatus().activate();
    }

    public INodePart getSourceNodeDummy() {
        return this.sn;
    }

    public INodePart getTargetNodeDummy() {
        return this.tn;
    }

    public IRelationshipPart getRelDummy() {
        return this.rel;
    }

    public void refreshFeedback() {
        if (this.feedbackService == null) {
            return;
        }
        if (this.feedback != null) {
            this.feedback.update();
        }
    }

    public void dispose() {
        if (this.feedbackService != null) {
            if (this.sn != null) {
                this.feedbackService.removeSelection(this.sn.getFigure());
            }
            this.feedbackService.removeFeedback((IFeedback)this.feedback);
            this.feedbackService = null;
        }
        if (this.rel != null) {
            this.rel.getStatus().deactivate();
            this.rel.removeNotify();
            this.rel.getFigure().getParent().remove(this.rel.getFigure());
            this.rel.setParent(null);
            this.rel = null;
        }
        if (this.tn != null) {
            this.tn.getStatus().deactivate();
            this.tn.removeNotify();
            this.tn.getFigure().getParent().remove(this.tn.getFigure());
            this.tn.setParent(null);
            this.tn = null;
        }
        if (this.sn != null) {
            this.sn.getStatus().deactivate();
            this.sn.removeNotify();
            this.sn.getFigure().getParent().remove(this.sn.getFigure());
            this.sn.setParent(null);
            this.sn = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DummyNodePart
    extends NodePart
    implements FigureListener {
        private IGraphicalPart source;
        private IAnchor anchor = null;

        public DummyNodePart(IGraphicalPart source) {
            this.source = source;
        }

        public DummyNodePart() {
            this(null);
        }

        @Override
        protected void fillSourceConnections(List<IConnectionPart> list) {
        }

        @Override
        protected void fillTargetConnections(List<IConnectionPart> list) {
        }

        protected IFigure createFigure() {
            ReferencedFigure fig = new ReferencedFigure();
            if (this.source != null) {
                fig.setBounds(this.source.getFigure().getBounds());
            } else {
                fig.setSize(5, 5);
            }
            return fig;
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (this.source != null) {
                this.source.getFigure().addFigureListener((FigureListener)this);
            }
        }

        @Override
        public void removeNotify() {
            if (this.source != null) {
                this.source.getFigure().removeFigureListener((FigureListener)this);
            }
            super.removeNotify();
        }

        @Override
        public IAnchor getSourceAnchor(IGraphicalPart connection) {
            return this.getAnchor();
        }

        @Override
        public IAnchor getTargetAnchor(IGraphicalPart connection) {
            return this.getAnchor();
        }

        private IAnchor getAnchor() {
            if (this.anchor == null) {
                this.anchor = this.source != null && this.source instanceof INodePart ? ((INodePart)this.source).getSourceAnchor(null) : new ReferenceAnchor(this.getFigure());
            }
            return this.anchor;
        }

        public void figureMoved(IFigure source) {
            this.getFigure().setBounds(source.getBounds());
        }
    }

    private class DummyRelPart
    extends RelationshipPart {
        private DummyRelPart() {
        }

        protected INodePart findSourceNode() {
            return RelationshipDummy.this.sn;
        }

        protected INodePart findTargetNode() {
            return RelationshipDummy.this.tn;
        }
    }

    private static class ReferenceAnchor
    extends AbstractAnchor {
        public ReferenceAnchor(IFigure owner) {
            super(owner);
        }

        public PrecisionPoint getLocation(double x, double y, double expansion) {
            return this.getReferencePoint();
        }
    }
}

