/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Image;
import org.xmind.gef.GEF;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.event.DragDropEvent;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IPart;
import org.xmind.gef.status.IStatusListener;
import org.xmind.gef.status.StatusEvent;
import org.xmind.gef.tool.GraphicalTool;
import org.xmind.ui.branch.ILockableBranchStructureExtension;
import org.xmind.ui.branch.IMovableBranchStructureExtension;
import org.xmind.ui.internal.tools.BranchDummy;
import org.xmind.ui.internal.tools.TopicMoveToolHelper;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.tools.ITopicMoveToolHelper;
import org.xmind.ui.tools.ParentSearchKey;
import org.xmind.ui.tools.ParentSearcher;

public class MindMapDndTool
extends GraphicalTool
implements IStatusListener {
    private static ITopicMoveToolHelper defaultHelper = null;
    private BranchDummy dummy = null;
    private IBranchPart targetParent = null;
    private ParentSearcher parentSearcher = null;
    private ParentSearchKey key = null;
    private boolean insideTopicAllowed = false;
    private ITopicMoveToolHelper helper = null;
    private Request request = null;
    private Image image = null;

    public MindMapDndTool() {
        this.getStatus().addStatusListener((IStatusListener)this);
    }

    private boolean acceptEvent(DragDropEvent de) {
        if ((de.operations & 1) != 0) {
            de.detail = 1;
            return true;
        }
        if ((de.operations & 4) != 0) {
            de.detail = 4;
            return true;
        }
        return false;
    }

    protected boolean handleDragStarted(DragDropEvent de) {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        this.targetParent = null;
        this.request = null;
        this.insideTopicAllowed = this.isInsideTopicAllowed(de);
        if (this.acceptEvent(de)) {
            this.createDummy(de);
            this.lockBranchStructures((IPart)this.getTargetViewer().getRootPart());
            return true;
        }
        return false;
    }

    private void lockBranchStructures(IPart part) {
        IBranchPart branch;
        IStructure sa;
        if (part instanceof IBranchPart && (sa = (branch = (IBranchPart)part).getBranchPolicy().getStructure(branch)) instanceof ILockableBranchStructureExtension) {
            ((ILockableBranchStructureExtension)sa).lock(branch);
        }
        for (IPart child : part.getChildren()) {
            this.lockBranchStructures(child);
        }
    }

    private void unlockBranchStructures(IPart part) {
        IBranchPart branch;
        IStructure sa;
        if (part instanceof IBranchPart && (sa = (branch = (IBranchPart)part).getBranchPolicy().getStructure(branch)) instanceof ILockableBranchStructureExtension) {
            ((ILockableBranchStructureExtension)sa).unlock(branch);
        }
        for (IPart child : part.getChildren()) {
            this.unlockBranchStructures(child);
        }
    }

    private void createDummy(DragDropEvent de) {
        if (this.dummy != null) {
            this.dummy.dispose();
            this.dummy = null;
        }
        this.dummy = new BranchDummy(this.getTargetViewer(), false);
        this.decorateDummy(this.dummy, de);
    }

    protected void decorateDummy(BranchDummy dummy, DragDropEvent de) {
        dummy.setStyle("shape-class", "org.xmind.topicShape.noBorder");
        dummy.getTopic().setTitleText("");
        dummy.getBranch().refresh();
    }

    protected boolean isInsideTopicAllowed(DragDropEvent de) {
        return true;
    }

    protected boolean handleDragOver(DragDropEvent de) {
        if (this.acceptEvent(de) && this.dummy != null) {
            this.key = new ParentSearchKey(null, (IReferencedFigure)this.dummy.getBranch().getTopicPart().getFigure(), this.getCursorPosition());
            this.key.setFeedback(this.dummy.getBranch());
            this.targetParent = this.updateTargetParent();
            this.updateWithParent(this.targetParent);
            return true;
        }
        return false;
    }

    private IBranchPart updateTargetParent() {
        return this.getParentSearcher().searchTargetParent((IPart)this.getTargetViewer().getRootPart(), this.key);
    }

    private void updateWithParent(IBranchPart parent) {
        this.updateDummyWithParent(parent);
        this.updateHelperWithParent(parent);
    }

    private void updateDummyWithParent(IBranchPart parent) {
        this.updateDummyPosition(this.getCursorPosition());
    }

    protected void updateDummyPosition(Point pos) {
        IFigure fig = this.dummy.getBranch().getFigure();
        if (fig != null) {
            if (fig instanceof IReferencedFigure) {
                ((IReferencedFigure)fig).setReference(pos);
            } else {
                fig.setLocation(pos);
            }
        }
    }

    private void updateHelperWithParent(IBranchPart parent) {
        ITopicMoveToolHelper oldHelper = this.helper;
        ITopicMoveToolHelper newHelper = this.getHelper(parent);
        if (newHelper != oldHelper) {
            if (oldHelper != null) {
                oldHelper.deactivate(this.getDomain(), (IViewer)this.getTargetViewer());
            }
            if (newHelper != null) {
                newHelper.activate(this.getDomain(), (IViewer)this.getTargetViewer());
            }
            this.helper = newHelper;
        }
        if (this.helper != null) {
            this.helper.update(parent, this.key);
        }
    }

    private ITopicMoveToolHelper getHelper(IBranchPart parent) {
        return MindMapDndTool.getDefaultHelper();
    }

    protected static ITopicMoveToolHelper getDefaultHelper() {
        if (defaultHelper == null) {
            defaultHelper = new TopicMoveToolHelper();
        }
        return defaultHelper;
    }

    protected ParentSearcher getParentSearcher() {
        if (this.parentSearcher == null) {
            this.parentSearcher = new ParentSearcher(this.insideTopicAllowed);
        }
        return this.parentSearcher;
    }

    protected boolean handleDragDismissed(DragDropEvent de) {
        if (this.acceptEvent(de)) {
            this.createRequest(de);
            this.destroyDummy();
            this.changeActiveTool("default tool");
            return true;
        }
        return false;
    }

    private IPart findDropTarget(IPart target) {
        if (target == null) {
            return null;
        }
        if (target.hasRole("drop target role")) {
            return target;
        }
        return this.findDropTarget(target.getParent());
    }

    private void createRequest(DragDropEvent de) {
        IStructure structure;
        ITopicPart targetTopic;
        this.request = new Request("drop");
        Object target = this.findDropTarget(de.target);
        if (target == null) {
            target = (ISheetPart)this.getTargetViewer().getAdapter(ISheetPart.class);
        }
        this.request.setPrimaryTarget(target);
        ITopicPart iTopicPart = targetTopic = this.targetParent == null ? null : this.targetParent.getTopicPart();
        if (targetTopic != null) {
            this.request.setParameter("parent", (Object)targetTopic);
            int targetIndex = -1;
            if (!this.isFloatMove() && this.targetParent != null) {
                targetIndex = this.getParentSearcher().getIndex(this.targetParent, this.key);
            }
            this.request.setParameter("index", (Object)targetIndex);
        }
        if (!this.isFloatMove()) {
            Point position = this.getCursorPosition();
            this.request.setParameter("position", (Object)position);
        }
        if (this.isCopyMove()) {
            this.request.setParameter("copy", (Object)Boolean.TRUE);
        }
        if (this.targetParent != null && (structure = this.targetParent.getBranchPolicy().getStructure(this.targetParent)) instanceof IMovableBranchStructureExtension) {
            ((IMovableBranchStructureExtension)structure).decorateMoveInRequest(this.targetParent, this.key, null, this.request);
        }
    }

    private void destroyDummy() {
        this.unlockBranchStructures((IPart)this.getTargetViewer().getRootPart());
        if (this.helper != null) {
            this.helper.deactivate(this.getDomain(), (IViewer)this.getTargetViewer());
            this.helper = null;
        }
        if (this.dummy != null) {
            this.dummy.dispose();
            this.dummy = null;
        }
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }

    private boolean isFloatMove() {
        return this.getStatus().isStatus(8);
    }

    private boolean isCopyMove() {
        if (GEF.IS_CARBON) {
            return this.getStatus().isStatus(2);
        }
        return this.getStatus().isStatus(4);
    }

    protected boolean handleDrop(DragDropEvent de) {
        if (this.acceptEvent(de) && this.request != null) {
            this.request.setParameter("dndData", (Object)de.dndData);
            try {
                this.getDomain().handleRequest(this.request);
            }
            finally {
                this.request = null;
            }
            return true;
        }
        return false;
    }

    public void statusChanged(StatusEvent event) {
    }
}

