/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Cursor;
import org.xmind.gef.GEF;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.internal.tools.ImageMoveToolHelper;
import org.xmind.ui.mindmap.IImagePart;
import org.xmind.ui.mindmap.IMindMapImages;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.tools.DummyMoveTool;
import org.xmind.ui.util.MindMapUtils;

public class ImageMoveTool
extends DummyMoveTool {
    private ITopicPart targetParent = null;
    private ImageMoveToolHelper helper = null;

    public void setSource(IGraphicalEditPart source) {
        Assert.isTrue((boolean)(source instanceof IImagePart));
        super.setSource(source);
    }

    protected IFigure createDummy() {
        Layer layer = this.getTargetViewer().getLayer(GEF.LAYER_PRESENTATION);
        if (layer != null) {
            SizeableImageFigure dummy = new SizeableImageFigure(((IImagePart)this.getSource()).getImage());
            dummy.setStretched(true);
            dummy.setConstrained(false);
            dummy.setBounds(this.getSource().getFigure().getBounds());
            dummy.setAlpha(192);
            layer.add((IFigure)dummy);
            return dummy;
        }
        return null;
    }

    protected void onMoving(Point currentPos, MouseDragEvent me) {
        super.onMoving(currentPos, me);
        this.targetParent = this.findTopicPart(me.target);
        if (this.helper == null) {
            this.helper = new ImageMoveToolHelper();
            this.helper.activate(this.getDomain(), (IViewer)this.getTargetViewer());
        }
        this.helper.update(this.targetParent, this.getDummy(), currentPos);
    }

    private ITopicPart findTopicPart(IPart p) {
        return MindMapUtils.findTopicPart(p);
    }

    protected void end() {
        if (this.helper != null) {
            this.helper.deactivate(this.getDomain(), (IViewer)this.getTargetViewer());
            this.helper = null;
        }
        super.end();
    }

    private boolean isCopyMove() {
        if (GEF.IS_CARBON) {
            return this.getStatus().isStatus(2);
        }
        return this.getStatus().isStatus(4);
    }

    protected Request createRequest() {
        boolean copy = this.isCopyMove();
        Request request = new Request(copy ? "copy to" : "move to");
        request.setPrimaryTarget((IPart)this.getSource());
        request.setParameter("parent", (Object)this.targetParent);
        if (this.helper != null) {
            this.helper.decorateMoveRequest(request, this.getCursorPosition());
        }
        return request;
    }

    public Cursor getCurrentCursor(Point pos, IPart host) {
        if (this.isCopyMove()) {
            return MindMapUI.getImages().getCursor(IMindMapImages.CURSOR_ADD);
        }
        return super.getCurrentCursor(pos, host);
    }
}

