/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.event.KeyEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.IGraphicalTool;
import org.xmind.gef.tool.ITool;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.tools.BranchDummy;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.tools.DummyCreateTool;
import org.xmind.ui.viewers.SWTUtils;

public class FloatingTopicCreateTool
extends DummyCreateTool {
    private Request request;
    private Point position;
    private BranchDummy branchDummy = null;

    protected void onActivated(ITool prevTool) {
        this.request = null;
        if (prevTool instanceof IGraphicalTool) {
            this.setCursorPosition(((IGraphicalTool)prevTool).getCursorPosition());
        }
        super.onActivated(prevTool);
        this.createDummy();
    }

    protected void onDeactivated(ITool nextTool) {
        super.onDeactivated(nextTool);
        this.request = null;
    }

    protected void handleSingleRequest(Request request) {
        if (!this.getStatus().isStatus(1)) {
            return;
        }
        if (this.request == null && "create floating".equals(request.getType())) {
            this.request = request;
            this.pack();
        } else {
            super.handleSingleRequest(request);
        }
    }

    protected Request createRequest() {
        if (this.position == null) {
            return null;
        }
        Request req = this.request != null ? this.request : new Request("create floating");
        req.setParameter("position", (Object)this.position);
        ISheetPart sheet = (ISheetPart)this.getTargetViewer().getAdapter(ISheetPart.class);
        if (sheet != null) {
            req.setPrimaryTarget((IPart)sheet);
        }
        return req;
    }

    protected IFigure doCreateDummy() {
        if (this.branchDummy == null) {
            this.branchDummy = new BranchDummy(this.getTargetViewer(), true);
            this.branchDummy.getTopic().setTitleText(MindMapMessages.TitleText_FloatingTopic);
            this.pack();
        }
        IFigure figure = this.branchDummy.getBranch().getFigure();
        if (this.getCursorPosition() != null) {
            if (figure instanceof IReferencedFigure) {
                ((IReferencedFigure)figure).setReference(this.getCursorPosition());
            } else {
                Dimension size = figure.getSize();
                figure.setLocation(this.getCursorPosition().getTranslated(-size.width / 2, -size.height / 2));
            }
        }
        return figure;
    }

    private void pack() {
        Object param;
        if (this.branchDummy == null) {
            return;
        }
        if (this.request != null && (param = this.request.getParameter("property.structureClass")) instanceof String) {
            this.branchDummy.getTopic().setStructureClass((String)param);
        }
        this.branchDummy.pack();
    }

    protected void destroyDummy(IFigure dummy) {
        if (this.branchDummy != null) {
            this.branchDummy.dispose();
            this.branchDummy = null;
        }
        super.destroyDummy(dummy);
    }

    protected void updateDummyPosition(IFigure dummy, Point pos) {
        this.position = pos;
        ((IReferencedFigure)dummy).setReference(pos);
    }

    protected boolean canCancelOnRightMouseDown(MouseEvent me) {
        return true;
    }

    protected boolean canFinish(String requestType) {
        return this.position != null;
    }

    protected boolean canFinishOnLeftMouseDown(MouseEvent me) {
        return this.position != null;
    }

    protected boolean shouldCancel(KeyEvent ke) {
        return SWTUtils.matchKey((int)ke.getState(), (int)ke.keyCode, (int)0, (int)27);
    }
}

