/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.properties.GraphicalPropertySheetPage;
import org.xmind.ui.internal.properties.PropertySectionContributorManager;
import org.xmind.ui.mindmap.ICategoryAnalyzation;
import org.xmind.ui.mindmap.ICategoryManager;
import org.xmind.ui.mindmap.MindMapUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MindMapPropertySheetPage
extends GraphicalPropertySheetPage {
    private static PropertySectionContributorManager manager = PropertySectionContributorManager.getInstance();

    public MindMapPropertySheetPage(IGraphicalEditor editor) {
        super(editor);
    }

    protected void selectionChanged(ISelection selection) {
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setRedraw(false);
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            List<String> newVisibleSectionIds = manager.getApplicableSectionIds(ss.toArray());
            List oldVisibleSectionIds = this.getVisibleSectionIds();
            if (!MindMapPropertySheetPage.equalsList(oldVisibleSectionIds, newVisibleSectionIds)) {
                List oldSectionIds = this.getSectionIds();
                ArrayList<String> toAdd = new ArrayList<String>(newVisibleSectionIds);
                toAdd.removeAll(oldSectionIds);
                for (String id : toAdd) {
                    this.addSection(id, newVisibleSectionIds, oldSectionIds);
                    oldSectionIds = this.getSectionIds();
                }
                ArrayList toHide = new ArrayList(oldSectionIds);
                toHide.removeAll(newVisibleSectionIds);
                Iterator iterator = oldSectionIds.iterator();
                while (iterator.hasNext()) {
                    String id;
                    this.setSectionVisible(id, !toHide.contains(id = (String)iterator.next()));
                }
                this.reflow();
            }
            this.setTitle(this.calcTitle(ss.toArray()));
        } else {
            this.setTitle(null);
        }
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setRedraw(true);
        }
    }

    private void addSection(String id, List<String> newVisibleSectionIds, List<String> oldSectionIds) {
        this.addSection(id, manager.createSection(id));
        String aboveId = this.findAboveId(id, oldSectionIds, newVisibleSectionIds);
        this.moveSectionAfter(id, aboveId);
    }

    private String findAboveId(String id, List<String> oldSectionIds, List<String> newSectionIds) {
        int index = newSectionIds.indexOf(id);
        int i = index - 1;
        while (i >= 0) {
            String aboveId = newSectionIds.get(i);
            if (oldSectionIds.contains(aboveId)) {
                return aboveId;
            }
            --i;
        }
        return null;
    }

    private static boolean equalsList(List<String> list1, List<String> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        int i = 0;
        while (i < list1.size()) {
            String s2;
            String s1 = list1.get(i);
            if (!s1.equals(s2 = list2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String calcTitle(Object[] objects) {
        if (objects == null || objects.length == 0) {
            return null;
        }
        ICategoryManager typeManager = MindMapUI.getCategoryManager();
        ICategoryAnalyzation result = typeManager.analyze(objects);
        return typeManager.getCategoryName(result.getMainCategory());
    }
}

