/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.print;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.xmind.gef.GEF;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.util.Properties;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.mindmap.MindMapViewer;
import org.xmind.ui.internal.print.PrintConstants;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.UnitConvertor;
import org.xmind.ui.viewers.SWTUtils;

public class PageSetupDialog
extends TitleAreaDialog {
    private static final String SECTION_ID = "org.xmind.ui.PageSetupDialog";
    private static final int VIEWER_WIDTH = 480;
    private static final int VIEWER_HEIGHT = 360;
    private IGraphicalEditor sourceEditor;
    private IGraphicalEditorPage sourcePge;
    private IMindMapViewer sourceViewer;
    private IMindMap sourceMindMap;
    private Button backgroundCheck;
    private Button borderCheck;
    private Map<String, Text> inputControls;
    private Combo unitChooser;
    private Map<String, IAction[]> actions;
    private MindMapViewer previewViewer;
    private Composite previewPage;
    private GridLayout pageLayout;
    private IFigure previewFigure;
    private IFigure borderFigure;
    private ITextFigure headerFigure;
    private ITextFigure footerFigure;
    private IDialogSettings settings;
    private boolean updating = false;
    private boolean modifyingText = false;
    private Listener eventHandler = new Listener(){

        public void handleEvent(Event event) {
            PageSetupDialog.this.handleWidgetEvent(event);
        }
    };

    public PageSetupDialog(Shell parentShell, IGraphicalEditor sourceEditor, IGraphicalEditorPage sourcePge, IMindMapViewer sourceViewer, IMindMap sourceMindMap) {
        super(parentShell);
        this.sourceEditor = sourceEditor;
        this.sourcePge = sourcePge;
        this.sourceViewer = sourceViewer;
        this.sourceMindMap = sourceMindMap;
        this.settings = MindMapUIPlugin.getDefault().getDialogSettings(SECTION_ID);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DialogMessages.PageSetupDialog_windowTitle);
    }

    public void create() {
        super.create();
        this.update(null);
        this.setTitle(NLS.bind((String)DialogMessages.PageSetupDialog_title, (Object)this.sourceMindMap.getCentralTopic().getTitleText()));
        this.setMessage(DialogMessages.PageSetupDialog_description);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.getSettings();
    }

    protected int getDialogBoundsStrategy() {
        return 1;
    }

    public IGraphicalEditor getSourceEditor() {
        return this.sourceEditor;
    }

    public IMindMap getSourceMindMap() {
        return this.sourceMindMap;
    }

    public IGraphicalEditorPage getSourcePge() {
        return this.sourcePge;
    }

    public IMindMapViewer getSourceViewer() {
        return this.sourceViewer;
    }

    public IDialogSettings getSettings() {
        return this.settings;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            label = IDialogConstants.NEXT_LABEL;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createSettingsPart(container);
        this.createPreviewPart(container);
        return composite;
    }

    private void createSettingsPart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = 210;
        layoutData.minimumWidth = 180;
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.createPageSetupSection(composite);
        this.createMarginsSection(composite);
        this.createHeaderFooterSection(composite);
    }

    private void createPageSetupSection(Composite parent) {
        Composite section = this.createSection(parent, DialogMessages.PageSetupDialog_PageSetup);
        this.backgroundCheck = new Button(section, 32);
        this.backgroundCheck.setText(DialogMessages.PageSetupDialog_Background);
        this.backgroundCheck.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hookWidget((Widget)this.backgroundCheck, 13);
        this.borderCheck = new Button(section, 32);
        this.borderCheck.setText(DialogMessages.PageSetupDialog_Border);
        this.borderCheck.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hookWidget((Widget)this.borderCheck, 13);
    }

    private void createMarginsSection(Composite parent) {
        Composite section = this.createSection(parent, DialogMessages.PageSetupDialog_Margins);
        Composite container = new Composite(section, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 5;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createMarginInput(container, "leftMargin", DialogMessages.PageSetupDialog_Left);
        this.createMarginInput(container, "rightMargin", DialogMessages.PageSetupDialog_Right);
        this.createMarginInput(container, "topMargin", DialogMessages.PageSetupDialog_Top);
        this.createMarginInput(container, "bottomMargin", DialogMessages.PageSetupDialog_Bottom);
        this.unitChooser = new Combo(section, 2060);
        this.unitChooser.add(DialogMessages.PageSetupDialog_Inch);
        this.unitChooser.add(DialogMessages.PageSetupDialog_Millimeter);
        GridData unitLayoutData = new GridData(0x1000008, 4, true, false);
        this.unitChooser.setLayoutData((Object)unitLayoutData);
        this.hookWidget((Widget)this.unitChooser, 13);
    }

    private void createMarginInput(Composite parent, String key, String name) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        container.setLayout((Layout)layout);
        Label nameLabel = new Label(container, 0);
        nameLabel.setText(name);
        nameLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Text input = this.createInputControl(container, key, true);
        GridData gd = new GridData(0x1000008, 4, false, false);
        gd.widthHint = 45;
        input.setLayoutData((Object)gd);
    }

    private Text createInputControl(Composite parent, final String key, boolean numeric) {
        Text input = new Text(parent, 2052);
        input.setData((Object)key);
        if (numeric) {
            SWTUtils.makeNumeralInput((Control)input, (boolean)false, (boolean)true);
        }
        this.hookWidget((Widget)input, 24);
        this.hookWidget((Widget)input, 14);
        this.hookWidget((Widget)input, 15);
        if (numeric) {
            this.hookWidget((Widget)input, 1);
        }
        if (this.inputControls == null) {
            this.inputControls = new HashMap<String, Text>();
        }
        this.inputControls.put(key, input);
        input.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PageSetupDialog.this.inputControls != null) {
                    PageSetupDialog.this.inputControls.remove(key);
                }
            }
        });
        return input;
    }

    private void createHeaderFooterSection(Composite parent) {
        Composite section = this.createSection(parent, DialogMessages.PageSetupDialog_HeaderFooter);
        this.createHeaderSection(section);
        this.createFooterSection(section);
    }

    private void createHeaderSection(Composite parent) {
        this.createHFSection(parent, DialogMessages.PageSetupDialog_Header, "headerAlign", "headerFont", "headerText");
    }

    private void createFooterSection(Composite parent) {
        this.createHFSection(parent, DialogMessages.PageSetupDialog_Footer, "footerAlign", "footerFont", "footerText");
    }

    private void createHFSection(Composite parent, String name, final String alignKey, String fontKey, String textKey) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 1;
        layout.verticalSpacing = 1;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        AlignAction leftAction = new AlignAction(alignKey, "left");
        AlignAction centerAction = new AlignAction(alignKey, "center");
        AlignAction rightAction = new AlignAction(alignKey, "right");
        ToolBarManager alignBar = new ToolBarManager(0x800000);
        alignBar.add((IAction)leftAction);
        alignBar.add((IAction)centerAction);
        alignBar.add((IAction)rightAction);
        alignBar.createControl(container);
        alignBar.getControl().setLayoutData((Object)new GridData(4, 4, false, false));
        this.addActions(alignKey, new IAction[]{leftAction, centerAction, rightAction});
        alignBar.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PageSetupDialog.this.removeActions(alignKey);
            }
        });
        ToolBarManager fontBar = new ToolBarManager(0x800000);
        FontAction fontAction = new FontAction(fontKey);
        fontBar.add((IAction)fontAction);
        fontBar.createControl(container);
        fontBar.getControl().setLayoutData((Object)new GridData(4, 4, false, false));
        Text input = this.createInputControl(container, textKey, false);
        GridData inputLayoutData = new GridData(4, 4, true, false);
        inputLayoutData.horizontalSpan = 3;
        input.setLayoutData((Object)inputLayoutData);
    }

    private void addActions(String key, IAction ... actions) {
        if (this.actions == null) {
            this.actions = new HashMap<String, IAction[]>();
        }
        this.actions.put(key, actions);
    }

    private void removeActions(String key) {
        if (this.actions != null) {
            this.actions.remove(key);
        }
    }

    private IAction[] getActions(String key) {
        return this.actions == null ? null : this.actions.get(key);
    }

    private void hookWidget(Widget widget, int eventType) {
        widget.addListener(eventType, this.eventHandler);
    }

    private Composite createSection(Composite parent, String title) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createSectionTitle(composite, title);
        Composite container = new Composite(composite, 0);
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginWidth = 0;
        layout2.marginLeft = 5;
        layout2.marginBottom = 10;
        container.setLayout((Layout)layout2);
        container.setLayoutData((Object)new GridData(4, 4, true, false));
        return container;
    }

    private void createSectionTitle(Composite parent, String title) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText(title);
        titleLabel.setFont(FontUtils.getBold((String)"org.eclipse.jface.defaultfont"));
        titleLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Label line = new Label(composite, 258);
        line.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void createPreviewPart(Composite parent) {
        Composite container = this.createPreviewContainer(parent);
        Composite blackContainer = this.createBlackContainer(container);
        Composite page = this.createPage(blackContainer);
        this.previewViewer = new MindMapViewer();
        Properties properties = this.previewViewer.getProperties();
        properties.set("constrained", (Object)Boolean.TRUE);
        properties.set("margin", (Object)20);
        properties.set("gradient", (Object)Boolean.FALSE);
        this.previewViewer.createControl(page);
        GridData layoutData = new GridData(4, 4, true, true);
        this.previewViewer.getControl().setLayoutData((Object)layoutData);
        this.previewViewer.getZoomManager().setConstraints(0.0, Double.MAX_VALUE);
        this.previewViewer.getCanvas().setScrollBarVisibility(FigureCanvas.NEVER);
        this.previewViewer.setInput(this.sourceMindMap);
        Layer feedback = this.previewViewer.getLayer(GEF.LAYER_FEEDBACK);
        if (feedback != null) {
            this.previewFigure = new Figure();
            this.previewFigure.setLayoutManager((LayoutManager)new PreviewLayout());
            feedback.add(this.previewFigure);
            this.borderFigure = new Figure();
            this.borderFigure.setBorder((Border)new LineBorder(parent.getDisplay().getSystemColor(2), 1));
            this.previewFigure.add(this.borderFigure);
            this.headerFigure = new RotatableWrapLabel(0);
            this.previewFigure.add((IFigure)this.headerFigure);
            this.footerFigure = new RotatableWrapLabel(0);
            this.previewFigure.add((IFigure)this.footerFigure);
            ((IGraphicalPart)this.previewViewer.getRootPart()).getFigure().addLayoutListener((LayoutListener)new LayoutListener.Stub(){

                public boolean layout(IFigure container) {
                    PageSetupDialog.this.layoutPreviewFigure();
                    return super.layout(container);
                }
            });
        }
        Label forReferenceLabel = new Label(container, 16384);
        forReferenceLabel.setText(DialogMessages.PageSetupDialog_JustForReference);
        forReferenceLabel.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)("carbon".equals(SWT.getPlatform()) ? 9 : 7)));
        forReferenceLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void layoutPreviewFigure() {
        if (this.previewViewer == null || this.previewViewer.getControl().isDisposed() || this.previewFigure == null) {
            return;
        }
        FigureCanvas canvas = this.previewViewer.getCanvas();
        org.eclipse.swt.graphics.Rectangle maxSize = canvas.getClientArea();
        this.previewFigure.setBounds(new Rectangle(maxSize));
    }

    private Composite createPage(Composite parent) {
        this.previewPage = new Composite(parent, 262144);
        this.pageLayout = new GridLayout(1, false);
        this.pageLayout.marginWidth = 0;
        this.pageLayout.marginHeight = 0;
        this.previewPage.setLayout((Layout)this.pageLayout);
        GridData layoutData = new GridData(4, 4, false, false);
        layoutData.widthHint = 480;
        layoutData.heightHint = 360;
        this.previewPage.setLayoutData((Object)layoutData);
        this.previewPage.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setBackground(e.display.getSystemColor(1));
                org.eclipse.swt.graphics.Rectangle r = ((Control)e.widget).getBounds();
                e.gc.fillRectangle(0, 0, r.width, r.height);
            }
        });
        return this.previewPage;
    }

    private Composite createBlackContainer(Composite parent) {
        Composite container = new Composite(parent, 262144);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 7;
        layout.marginHeight = 7;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setBackground(e.display.getSystemColor(2));
                org.eclipse.swt.graphics.Rectangle r = ((Control)e.widget).getBounds();
                e.gc.fillRectangle(0, 0, r.width, r.height);
            }
        });
        return container;
    }

    private Composite createPreviewContainer(Composite parent) {
        Group container = new Group(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        return container;
    }

    protected void setProperty(String key, String value) {
        this.getSettings().put(key, value);
        this.update(key);
    }

    protected void setProperty(String key, double value) {
        this.getSettings().put(key, value);
        this.update(key);
    }

    protected void setProperty(String key, boolean value) {
        this.getSettings().put(key, value);
        this.update(key);
    }

    private void update(String key) {
        if (this.updating) {
            return;
        }
        boolean backgroundChanged = key == null || "noBackground".equals(key);
        boolean borderChanged = key == null || "noBorder".equals(key);
        boolean unitChanged = key == null || "marginUnit".equals(key);
        boolean marginChanged = key == null || unitChanged || "leftMargin".equals(key) || "rightMargin".equals(key) || "topMargin".endsWith(key) || "bottomMargin".equals(key);
        boolean headerChanged = key == null || "headerAlign".equals(key) || "headerFont".equals(key) || "headerText".equals(key);
        boolean footerChanged = key == null || "footerAlign".equals(key) || "footerFont".equals(key) || "footerText".equals(key);
        this.updating = true;
        if (backgroundChanged) {
            Layer layer;
            boolean showBackground;
            boolean bl = showBackground = !this.getBoolean("noBackground");
            if (this.previewViewer != null && !this.previewViewer.getControl().isDisposed() && (layer = this.previewViewer.getLayer(GEF.LAYER_BACKGROUND)) != null) {
                layer.setOpaque(showBackground);
            }
            if (this.backgroundCheck != null && !this.backgroundCheck.isDisposed()) {
                this.backgroundCheck.setSelection(showBackground);
            }
        }
        if (borderChanged) {
            boolean showBorder;
            boolean bl = showBorder = !this.getBoolean("noBorder");
            if (this.borderFigure != null) {
                this.borderFigure.setVisible(showBorder);
            }
            if (this.borderCheck != null && !this.borderCheck.isDisposed()) {
                this.borderCheck.setSelection(showBorder);
            }
        }
        if (marginChanged) {
            if (key == null || unitChanged) {
                this.updateMargins("leftMargin", "rightMargin", "topMargin", "bottomMargin");
            } else {
                this.updateMargins(key);
            }
        }
        if (unitChanged && this.unitChooser != null && !this.unitChooser.isDisposed()) {
            int index = PrintConstants.UNITS.indexOf(this.getString("marginUnit", "inch"));
            if (index < 0 || index >= this.unitChooser.getItemCount()) {
                index = 0;
            }
            this.unitChooser.select(index);
        }
        if (headerChanged) {
            this.updateHFSectionAndPreview("headerText", "", "headerAlign", "center", 2, "headerFont", this.headerFigure);
        }
        if (footerChanged) {
            this.updateHFSectionAndPreview("footerText", "", "footerAlign", "right", 4, "footerFont", this.footerFigure);
        }
        this.updating = false;
    }

    private void updateHFSectionAndPreview(String textKey, String defaultText, String alignKey, String defaultAlign, int defaultDraw2DAlign, String fontKey, ITextFigure textFigure) {
        Text input;
        String text = this.getString(textKey, defaultText);
        String alignValue = this.getString(alignKey, defaultAlign);
        IAction[] alignActions = this.getActions(alignKey);
        if (alignActions != null) {
            IAction[] iActionArray = alignActions;
            int n = alignActions.length;
            int n2 = 0;
            while (n2 < n) {
                IAction action = iActionArray[n2];
                action.setChecked(((AlignAction)action).value.equals(alignValue));
                ++n2;
            }
        }
        if (!this.modifyingText && this.inputControls != null && (input = this.inputControls.get(textKey)) != null && !input.isDisposed()) {
            input.setText(text);
        }
        if (textFigure != null) {
            textFigure.setText(text);
            textFigure.setTextAlignment(PrintConstants.toDraw2DAlignment(alignValue, defaultDraw2DAlign));
            String fontValue = this.getString(fontKey, null);
            Font font = null;
            if (fontValue != null) {
                font = FontUtils.getFont((String)fontValue);
            }
            if (font == null) {
                font = Display.getCurrent().getSystemFont();
            }
            textFigure.setFont(font);
        }
    }

    private void updateMargins(String ... keys) {
        String key;
        int n;
        int n2;
        String[] stringArray;
        if (this.inputControls != null) {
            stringArray = keys;
            n2 = keys.length;
            n = 0;
            while (n < n2) {
                key = stringArray[n];
                Text text = this.inputControls.get(key);
                if (text != null && !text.isDisposed()) {
                    text.setText(this.getMarginText(key));
                }
                ++n;
            }
        }
        if (this.pageLayout != null && this.previewPage != null && !this.previewPage.isDisposed()) {
            stringArray = keys;
            n2 = keys.length;
            n = 0;
            while (n < n2) {
                key = stringArray[n];
                int margin = this.getControlMargin(key);
                if ("leftMargin".equals(key)) {
                    this.pageLayout.marginLeft = margin;
                } else if ("rightMargin".equals(key)) {
                    this.pageLayout.marginRight = margin;
                } else if ("topMargin".equals(key)) {
                    this.pageLayout.marginTop = margin;
                } else {
                    this.pageLayout.marginBottom = margin;
                }
                ++n;
            }
            this.previewPage.layout();
        }
    }

    private int getControlMargin(String key) {
        double value = this.getDouble(key, 0.2);
        value = "leftMargin".equals(key) || "rightMargin".equals(key) ? (value *= (double)UnitConvertor.getScreenDpi().x) : (value *= (double)UnitConvertor.getScreenDpi().y);
        return (int)(value / 2.0);
    }

    private String getMarginText(String key) {
        double value = this.getDouble(key, 0.2);
        if ("milliter".equals(this.getString("marginUnit", "inch"))) {
            value = UnitConvertor.inch2mm(value);
        }
        return String.valueOf(value);
    }

    private String getString(String key, String defaultValue) {
        String value = this.getSettings().get(key);
        return value == null ? defaultValue : value;
    }

    private boolean getBoolean(String key) {
        return this.getSettings().getBoolean(key);
    }

    private double getDouble(String key, double defaultValue) {
        try {
            return this.getSettings().getDouble(key);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private void handleWidgetEvent(Event event) {
        if (event.widget == this.backgroundCheck) {
            this.setProperty("noBackground", !this.backgroundCheck.getSelection());
        } else if (event.widget == this.borderCheck) {
            this.setProperty("noBorder", !this.borderCheck.getSelection());
        } else if (event.widget == this.unitChooser) {
            int index = this.unitChooser.getSelectionIndex();
            if (index < 0 || index >= PrintConstants.UNITS.size()) {
                index = 0;
            }
            this.setProperty("marginUnit", PrintConstants.UNITS.get(index));
        } else if (event.widget instanceof Text && this.inputControls != null && this.inputControls.containsValue(event.widget)) {
            Text input = (Text)event.widget;
            if (event.type == 15) {
                input.selectAll();
            } else if (event.type == 1) {
                if (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)0, (int)0x1000001)) {
                    this.stepValue(input, 1);
                } else if (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)0, (int)0x1000002)) {
                    this.stepValue(input, -1);
                }
            } else if (event.type == 14 || event.type == 24) {
                if (this.updating) {
                    return;
                }
                int caretPosition = input.getCaretPosition();
                this.modifyingText = true;
                String key = (String)event.widget.getData();
                if (key.equals("headerText") || key.equals("footerText")) {
                    this.setProperty(key, input.getText());
                } else {
                    try {
                        double value = Double.parseDouble(input.getText());
                        this.setMargin(key, value);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                this.modifyingText = false;
                caretPosition = Math.min(caretPosition, input.getText().length());
                input.setSelection(caretPosition);
            }
        }
    }

    private void stepValue(Text input, int stepFactor) {
        double value;
        try {
            value = Double.parseDouble(input.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        double step = "milliter".equals(this.getString("marginUnit", "inch")) ? 0.5 : 0.1;
        value += (step *= (double)stepFactor);
        if (value < 0.1) {
            value = 0.1;
        }
        this.setMargin((String)input.getData(), value);
    }

    private void setMargin(String key, double value) {
        if ("milliter".equals(this.getString("marginUnit", "inch"))) {
            value = UnitConvertor.mm2inch(value);
        }
        this.setProperty(key, value);
    }

    private class AlignAction
    extends Action {
        private String key;
        private String value;

        public AlignAction(String key, String value) {
            super(null, 2);
            this.key = key;
            this.value = value;
            if ("left".equals(value)) {
                this.setText(DialogMessages.PageSetupDialog_AlignLeft_text);
                this.setToolTipText(DialogMessages.PageSetupDialog_AlignLeft_toolTip);
                this.setImageDescriptor(MindMapUI.getImages().get("align_left.gif", true));
            } else if ("center".equals(value)) {
                this.setText(DialogMessages.PageSetupDialog_AlignCenter_text);
                this.setToolTipText(DialogMessages.PageSetupDialog_AlignCenter_toolTip);
                this.setImageDescriptor(MindMapUI.getImages().get("align_center.gif", true));
            } else {
                this.setText(DialogMessages.PageSetupDialog_AlignRight_text);
                this.setToolTipText(DialogMessages.PageSetupDialog_AlignRight_toolTip);
                this.setImageDescriptor(MindMapUI.getImages().get("align_right.gif", true));
            }
        }

        public void run() {
            PageSetupDialog.this.setProperty(this.key, this.value);
        }
    }

    private class FontAction
    extends Action {
        private String key;

        public FontAction(String key) {
            this.key = key;
            this.setText(DialogMessages.PageSetupDialog_Font_text);
            this.setToolTipText(DialogMessages.PageSetupDialog_Font_toolTip);
            this.setImageDescriptor(MindMapUI.getImages().get("text_font.gif", true));
        }

        public void run() {
            FontDialog dialog = new FontDialog(PageSetupDialog.this.getShell());
            String string = PageSetupDialog.this.getString(this.key, null);
            if (string == null) {
                dialog.setFontList(JFaceResources.getDefaultFontDescriptor().getFontData());
            } else {
                dialog.setFontList(FontUtils.toFontData((String)string));
            }
            FontData open = dialog.open();
            if (open == null) {
                return;
            }
            PageSetupDialog.this.setProperty(this.key, FontUtils.toString((FontData[])dialog.getFontList()));
        }
    }

    private class PreviewLayout
    extends AbstractLayout {
        private PreviewLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            return container.getSize();
        }

        public void layout(IFigure container) {
            Dimension size;
            Rectangle area = container.getClientArea();
            if (PageSetupDialog.this.borderFigure != null) {
                PageSetupDialog.this.borderFigure.setBounds(area);
            }
            if (PageSetupDialog.this.headerFigure != null) {
                size = PageSetupDialog.this.headerFigure.getPreferredSize(area.width, -1);
                PageSetupDialog.this.headerFigure.setBounds(new Rectangle(area.x, area.y + 3, area.width, size.height));
            }
            if (PageSetupDialog.this.footerFigure != null) {
                size = PageSetupDialog.this.footerFigure.getPreferredSize(area.width, -1);
                PageSetupDialog.this.footerFigure.setBounds(new Rectangle(area.x, area.y + area.height - size.height - 1, area.width, size.height));
            }
        }
    }
}

