/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Cursor;
import org.xmind.core.ISheet;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.IDecorator;
import org.xmind.gef.IViewer;
import org.xmind.gef.draw2d.AbstractAnchor;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.graphicalpolicy.IGraphicalPolicy;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartListener;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.gef.part.PartEvent;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.policy.NullEditPolicy;
import org.xmind.gef.service.IBendPointsFeedback;
import org.xmind.gef.service.IFeedback;
import org.xmind.gef.util.GEFUtils;
import org.xmind.ui.internal.decorators.SummaryDecorator;
import org.xmind.ui.internal.figures.SummaryFigure;
import org.xmind.ui.internal.graphicalpolicies.SummaryGraphicalPolicy;
import org.xmind.ui.internal.mindmap.BranchPart;
import org.xmind.ui.internal.mindmap.MindMapPartBase;
import org.xmind.ui.internal.mindmap.SelectionFeedbackHelper;
import org.xmind.ui.internal.mindmap.SummaryFeedback;
import org.xmind.ui.internal.mindmap.SummaryViewerModel;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.INodePart;
import org.xmind.ui.mindmap.ISelectionFeedbackHelper;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SummaryPart
extends MindMapPartBase
implements FigureListener,
ISummaryPart {
    private IAnchor sourceAnchor = null;
    private IAnchor targetAnchor = null;
    private IFigure enclosure = null;
    private INodePart node = null;
    private List<IBranchPart> enclosingBranches = null;
    private IPartListener parentListener = new IPartListener(){

        public void childRemoving(PartEvent event) {
            if (event.child instanceof IBranchPart) {
                IBranchPart branch = (IBranchPart)event.child;
                SummaryPart.this.refreshEnclosure();
                if (branch.getTopicPart() == SummaryPart.this.getNode()) {
                    SummaryPart.this.setNode(null);
                }
            }
        }

        public void childAdded(PartEvent event) {
            if (event.child instanceof IBranchPart) {
                IBranchPart branch = (IBranchPart)event.child;
                String topicType = branch.getTopic().getType();
                if ("attached".equals(topicType)) {
                    SummaryPart.this.refreshEnclosure();
                } else if ("summary".equals(topicType) && MindMapUtils.equals(SummaryPart.this.getSummary().getTopicId(), branch.getTopic().getId())) {
                    SummaryPart.this.setNode((INodePart)((Object)branch.getTopicPart()));
                }
            }
        }
    };
    private ISelectionChangedListener viewerListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            SummaryPart.this.syncStatus(this.isNodeSingleSelected());
        }

        private boolean isNodeSingleSelected() {
            IViewer viewer = SummaryPart.this.getSite().getViewer();
            if (viewer == null) {
                return false;
            }
            ISelection selection = viewer.getSelection();
            if (!selection.isEmpty() && !(selection instanceof IStructuredSelection)) {
                return false;
            }
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (ss.size() == 1 && SummaryPart.this.getSummaryTopic().equals(ss.getFirstElement())) {
                return true;
            }
            if (!(ss.isEmpty() || ss.size() == 1 && ss.getFirstElement() instanceof ISheet)) {
                return false;
            }
            return SummaryPart.this.getSummaryTopic().equals(viewer.getPreselected());
        }
    };
    private boolean cursorOverHandle = false;

    public SummaryPart() {
        this.setDecorator((IDecorator)SummaryDecorator.getInstance());
        this.setGraphicalPolicy((IGraphicalPolicy)SummaryGraphicalPolicy.getInstance());
    }

    protected IFigure createFigure() {
        return new SummaryFigure();
    }

    @Override
    public ISummary getSummary() {
        if (this.getModel() instanceof SummaryViewerModel) {
            return ((SummaryViewerModel)this.getModel()).getSummary();
        }
        return null;
    }

    @Override
    public ITopic getSummaryTopic() {
        return (ITopic)this.getRealModel();
    }

    @Override
    public IBranchPart getOwnedBranch() {
        if (this.getParent() instanceof IBranchPart) {
            return (IBranchPart)this.getParent();
        }
        return null;
    }

    public void setParent(IPart parent) {
        if (this.getParent() instanceof BranchPart) {
            this.getParent().removePartListener(this.parentListener);
            ((BranchPart)this.getParent()).removeSummary(this);
        }
        super.setParent(parent);
        if (this.getParent() instanceof BranchPart) {
            ((BranchPart)this.getParent()).addSummary(this);
            this.getParent().addPartListener(this.parentListener);
        }
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ISummary.class)) {
            return this.getSummary();
        }
        if (adapter.isAssignableFrom(ITopic.class)) {
            return this.getSummaryTopic();
        }
        return super.getAdapter(adapter);
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
        super.declareEditPolicies(reqHandler);
        reqHandler.installEditPolicy("selectable role", (IEditPolicy)NullEditPolicy.getInstance());
        reqHandler.installEditPolicy("deletable role", "org.xmind.ui.editPolicy.deletable");
        reqHandler.installEditPolicy("editable role", "org.xmind.ui.editPolicy.editable");
        reqHandler.installEditPolicy("modifiable role", "org.xmind.ui.editPolicy.modifiable");
        reqHandler.installEditPolicy("movable role", (IEditPolicy)NullEditPolicy.getInstance());
    }

    @Override
    protected void registerCoreEvents(ICoreEventSource source, ICoreEventRegister register) {
        super.registerCoreEvents(source, register);
        ISummary summary = this.getSummary();
        if (summary instanceof ICoreEventSource) {
            register.setNextSource((ICoreEventSource)summary);
            register.register("startIndex");
            register.register("endIndex");
            register.register("topicRefId");
            register.register("style");
        }
    }

    @Override
    public void handleCoreEvent(CoreEvent event) {
        String type = event.getType();
        if ("startIndex".equals(type) || "endIndex".equals(type)) {
            this.refresh();
        } else if ("topicRefId".equals(type)) {
            this.setNode(this.findConclusionNode());
            this.refresh();
        } else if ("style".equals(type)) {
            this.update();
        } else {
            super.handleCoreEvent(event);
        }
    }

    @Override
    public List<IBranchPart> getEnclosingBranches() {
        if (this.enclosingBranches == null) {
            this.enclosingBranches = this.fillEnclosingBranches(new ArrayList<IBranchPart>());
            for (IBranchPart subBranch : this.enclosingBranches) {
                subBranch.getFigure().addFigureListener((FigureListener)this);
            }
        }
        return this.enclosingBranches;
    }

    private List<IBranchPart> fillEnclosingBranches(List<IBranchPart> list) {
        ISummary s = this.getSummary();
        List subtopics = s.getEnclosingTopics();
        if (!subtopics.isEmpty()) {
            IViewer viewer = this.getSite().getViewer();
            for (ITopic t : subtopics) {
                IBranchPart branch = MindMapUtils.findBranch(viewer.findPart((Object)t));
                if (branch == null) continue;
                list.add(branch);
            }
        }
        return list;
    }

    private void flushEnclosingBranches() {
        if (this.enclosingBranches != null) {
            for (IBranchPart subBranch : this.enclosingBranches) {
                subBranch.getFigure().removeFigureListener((FigureListener)this);
            }
            this.enclosingBranches = null;
        }
    }

    @Override
    public boolean encloses(IBranchPart subbranch) {
        return this.getSummary().encloses(subbranch.getTopic());
    }

    public void refresh() {
        this.refreshEnclosure();
        super.refresh();
    }

    public void addNotify() {
        this.setNode(this.findConclusionNode());
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        this.setNode(null);
    }

    @Override
    protected void onActivated() {
        super.onActivated();
        IViewer viewer = this.getSite().getViewer();
        if (viewer != null) {
            viewer.addSelectionChangedListener(this.viewerListener);
            viewer.addPreSelectionChangedListener(this.viewerListener);
        }
    }

    @Override
    protected void onDeactivated() {
        IViewer viewer = this.getSite().getViewer();
        if (viewer != null) {
            viewer.removeSelectionChangedListener(this.viewerListener);
            viewer.removePreSelectionChangedListener(this.viewerListener);
        }
        super.onDeactivated();
    }

    private INodePart findConclusionNode() {
        IPart topicPart;
        ISummary s = this.getSummary();
        ITopic topic = s.getTopic();
        if (topic != null && (topicPart = this.getSite().getViewer().findPart((Object)topic)) instanceof INodePart) {
            return (INodePart)topicPart;
        }
        return null;
    }

    private void refreshEnclosure() {
        this.flushEnclosingBranches();
        this.updateEnclosure();
    }

    public void figureMoved(IFigure source) {
        this.updateEnclosure();
        this.update();
        this.getFigure().revalidate();
    }

    protected IFigure getEnclosure() {
        if (this.enclosure == null) {
            this.enclosure = new Figure();
        }
        return this.enclosure;
    }

    private void updateEnclosure() {
        Rectangle r = null;
        for (IBranchPart enclosingBranch : this.getEnclosingBranches()) {
            r = Geometry.union((Rectangle)r, (Rectangle)enclosingBranch.getFigure().getBounds());
        }
        if (r == null) {
            r = new Rectangle();
        }
        this.getEnclosure().setBounds(r);
    }

    @Override
    public IAnchor getSourceAnchor() {
        if (this.sourceAnchor == null) {
            IFigure enclosure2 = this.getEnclosure();
            this.sourceAnchor = new SummarySourceAnchor(enclosure2);
        }
        return this.sourceAnchor;
    }

    @Override
    public IAnchor getTargetAnchor() {
        if (this.targetAnchor == null) {
            IFigure enclosure2 = this.getEnclosure();
            this.targetAnchor = new SummaryTargetAnchor(enclosure2);
        }
        return this.targetAnchor;
    }

    @Override
    public IAnchor getNodeAnchor() {
        if (this.node != null) {
            return this.node.getTargetAnchor(this);
        }
        return null;
    }

    @Override
    public INodePart getNode() {
        return this.node;
    }

    @Override
    public void setNode(INodePart part) {
        if (part == this.node) {
            return;
        }
        this.node = part;
        this.update();
        this.syncStatus(false);
        if (part != null) {
            IBranchPart branch = MindMapUtils.findBranch((IPart)part);
            if (branch != null) {
                branch.treeUpdate(false);
            } else {
                part.update();
            }
        }
    }

    private void syncStatus(boolean nodeSingleSelected) {
        boolean oldPreselected = this.getStatus().isPreSelected();
        boolean preSelected = this.getNode() != null && (this.getNode().getStatus().isSelected() ? this.cursorOverHandle : nodeSingleSelected && this.getNode().getStatus().isPreSelected());
        boolean selected = nodeSingleSelected && this.getNode() != null && this.getNode().getStatus().isSelected();
        this.getStatus().setStatus(4, preSelected);
        this.getStatus().setStatus(2, selected);
        if (oldPreselected == this.getStatus().isPreSelected()) {
            this.updateFeedback();
        }
    }

    @Override
    protected ISelectionFeedbackHelper createSelectionFeedbackHelper() {
        return new SelectionFeedbackHelper();
    }

    @Override
    protected IFeedback createFeedback() {
        return new SummaryFeedback(this);
    }

    public boolean containsPoint(Point position) {
        return super.containsPoint(position) || this.getFeedback() != null && this.getFeedback().containsPoint(position);
    }

    public IPart findAt(Point position) {
        IPart ret = super.findAt(position);
        if (ret == this) {
            if (this.getFeedback() == null || !this.getFeedback().containsPoint(position)) {
                this.cursorOverHandle = false;
                return this.getNode();
            }
            this.cursorOverHandle = true;
        } else {
            this.cursorOverHandle = false;
        }
        return ret;
    }

    public Cursor getCursor(Point pos) {
        int orientation;
        if (this.getFeedback() instanceof IBendPointsFeedback && (orientation = ((IBendPointsFeedback)this.getFeedback()).getOrientation(pos)) != 0) {
            return GEFUtils.getPositionCursor((int)orientation);
        }
        return super.getCursor(pos);
    }

    private static class SummarySourceAnchor
    extends AbstractAnchor {
        private SummarySourceAnchor(IFigure owner) {
            super(owner);
        }

        public PrecisionPoint getLocation(double x, double y, double expansion) {
            return Geometry.getChopBoxLocation((double)x, (double)y, (Rectangle)this.getOwner().getBounds(), (double)expansion);
        }

        public PrecisionPoint getLocation(int orientation, double expansion) {
            IFigure owner = this.getOwner();
            Rectangle r = owner.getBounds();
            if (orientation == 1) {
                return new PrecisionPoint(r.getTopLeft()).translate(0.0, -expansion);
            }
            if (orientation == 4) {
                return new PrecisionPoint(r.getBottomRight()).translate(0.0, expansion);
            }
            if (orientation == 8) {
                return new PrecisionPoint(r.getBottomLeft()).translate(-expansion, 0.0);
            }
            return new PrecisionPoint(r.getTopRight()).translate(expansion, 0.0);
        }
    }

    private static class SummaryTargetAnchor
    extends AbstractAnchor {
        private SummaryTargetAnchor(IFigure owner) {
            super(owner);
        }

        public PrecisionPoint getLocation(double x, double y, double expansion) {
            return Geometry.getChopBoxLocation((double)x, (double)y, (Rectangle)this.getOwner().getBounds(), (double)expansion);
        }

        public PrecisionPoint getLocation(int orientation, double expansion) {
            Rectangle r = this.getOwner().getBounds();
            if (orientation == 1) {
                return new PrecisionPoint(r.getTopRight()).translate(0.0, -expansion);
            }
            if (orientation == 4) {
                return new PrecisionPoint(r.getBottomLeft()).translate(0.0, expansion);
            }
            if (orientation == 8) {
                return new PrecisionPoint(r.getTopLeft()).translate(-expansion, 0.0);
            }
            return new PrecisionPoint(r.getBottomRight()).translate(expansion, 0.0);
        }
    }
}

