/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import org.eclipse.draw2d.IFigure;
import org.xmind.core.ITitled;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.draw2d.ITitledFigure;
import org.xmind.gef.part.IPart;
import org.xmind.gef.service.IFeedback;
import org.xmind.gef.service.IFeedbackService;
import org.xmind.ui.internal.layers.TitleLayer;
import org.xmind.ui.internal.mindmap.RelationshipFeedback;
import org.xmind.ui.internal.mindmap.SelectionFeedbackHelper;
import org.xmind.ui.util.MindMapUtils;

public class RelationshipSelectionHelper
extends SelectionFeedbackHelper {
    protected void updateFeedback(IFeedback feedback, int newStatus) {
        int alpha = (newStatus & 2) != 0 ? 255 : ((newStatus & 4) != 0 ? 176 : 0);
        ((RelationshipFeedback)feedback).setAlpha(alpha);
        super.updateFeedback(feedback, newStatus);
    }

    protected void updateOtherFeedback(IFeedbackService feedbackService, int newStatus) {
        super.updateOtherFeedback(feedbackService, newStatus);
        this.updateTitleFeedback(feedbackService, newStatus);
    }

    protected void removeOtherFeedback(IFeedbackService feedbackService) {
        super.removeOtherFeedback(feedbackService);
        ITextFigure figure = this.getTitleFigure();
        if (figure != null) {
            feedbackService.removeSelection((IFigure)figure);
        }
    }

    private void updateTitleFeedback(IFeedbackService feedbackService, int newStatus) {
        ITextFigure figure = this.getTitleFigure();
        if (figure != null) {
            if ((newStatus & 2) != 0) {
                feedbackService.setSelected((IFigure)figure);
            } else if ((newStatus & 4) != 0) {
                feedbackService.setPreselected((IFigure)figure);
            } else if (newStatus == 0) {
                feedbackService.removeSelection((IFigure)figure);
            }
            figure.setVisible(newStatus != 0 || this.getHost().getFigure().isVisible() && this.hasTitle());
            if (figure.getParent() instanceof TitleLayer) {
                TitleLayer layer = (TitleLayer)figure.getParent();
                if ((newStatus & 0xE) != 0) {
                    layer.addOnTop((IFigure)figure);
                } else {
                    layer.removeOnTop((IFigure)figure);
                }
            }
        }
    }

    private ITextFigure getTitleFigure() {
        IFigure figure = this.getHost().getFigure();
        if (figure instanceof ITitledFigure) {
            return ((ITitledFigure)figure).getTitle();
        }
        return null;
    }

    private boolean hasTitle() {
        Object m = MindMapUtils.getRealModel((IPart)this.getHost());
        if (m instanceof ITitled) {
            ITitled titled = (ITitled)m;
            return titled.hasTitle() && !"".equals(titled.getTitleText());
        }
        return false;
    }
}

