/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.xmind.core.ISheet;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.gef.GraphicalViewer;
import org.xmind.gef.ISelectionSupport;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRootPart;
import org.xmind.gef.service.IRevealService;
import org.xmind.ui.internal.figures.BranchFigure;
import org.xmind.ui.internal.mindmap.MindMapRootPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MindMapViewer
extends GraphicalViewer
implements IMindMapViewer {
    private boolean inputChangedOnSelectionChanged = false;

    public MindMapViewer() {
        this.setDndSupport(MindMapUI.getMindMapDndSupport());
        this.setPartFactory(MindMapUI.getMindMapPartFactory());
        this.setRootPart((IRootPart)new MindMapRootPart());
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IMindMap.class) {
            return this.getMindMap();
        }
        if (adapter == ISheet.class) {
            return this.getSheet();
        }
        if (adapter == ITopic.class) {
            return this.getCentralTopic();
        }
        if (adapter == ISheetPart.class) {
            return this.getSheetPart();
        }
        if (adapter == IBranchPart.class) {
            return this.getCentralBranchPart();
        }
        if (adapter == ITopicPart.class) {
            return this.getCentralTopicPart();
        }
        if (adapter == IWorkbook.class) {
            ISheet sheet = this.getSheet();
            return sheet == null ? null : sheet.getParent();
        }
        return super.getAdapter(adapter);
    }

    protected Control internalCreateControl(Composite parent, int style) {
        FigureCanvas fc = (FigureCanvas)super.internalCreateControl(parent, style);
        fc.setScrollBarVisibility(FigureCanvas.ALWAYS);
        fc.setBackground(parent.getDisplay().getSystemColor(1));
        return fc;
    }

    protected ISelectionSupport createSelectionSupport() {
        return new MindMapSelectionSupport();
    }

    public Object getPreselected() {
        Object o = super.getPreselected();
        if (o instanceof IPart) {
            o = ((IPart)o).getModel();
        }
        return MindMapUtils.toRealModel(o);
    }

    public Object getFocused() {
        Object o = super.getFocused();
        if (o instanceof IPart) {
            o = ((IPart)o).getModel();
        }
        return MindMapUtils.toRealModel(o);
    }

    protected void revealParts(List<? extends IPart> parts) {
        super.revealParts(parts);
        IRevealService revealService = (IRevealService)this.getService(IRevealService.class);
        if (revealService != null) {
            revealService.reveal((ISelection)new StructuredSelection(parts));
        }
    }

    public void setSelection(ISelection selection) {
        super.setSelection(selection, true);
    }

    protected void ensureVisible(Rectangle box, Rectangle clientArea, int margin) {
        super.ensureVisible(box, clientArea, 10);
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
    }

    protected void setSelectionOnInputChanged(ISelection selection) {
        if (this.inputChangedOnSelectionChanged) {
            return;
        }
        this.setSelection(selection, false);
    }

    @Override
    public IMindMap getMindMap() {
        Object input = this.getInput();
        return input instanceof IMindMap ? (IMindMap)input : null;
    }

    @Override
    public void setMindMap(IMindMap mindMap) {
        this.setInput(mindMap);
    }

    @Override
    public IBranchPart getCentralBranchPart() {
        ISheetPart sheetPart = this.getSheetPart();
        return sheetPart == null ? null : sheetPart.getCentralBranch();
    }

    @Override
    public ITopic getCentralTopic() {
        Object input = this.getInput();
        if (input instanceof IMindMap) {
            return ((IMindMap)input).getCentralTopic();
        }
        if (input instanceof ISheet) {
            return ((ISheet)input).getRootTopic();
        }
        if (input instanceof ITopic) {
            return (ITopic)input;
        }
        return null;
    }

    @Override
    public ITopicPart getCentralTopicPart() {
        IBranchPart centralBranchPart = this.getCentralBranchPart();
        return centralBranchPart == null ? null : centralBranchPart.getTopicPart();
    }

    @Override
    public ISheet getSheet() {
        Object input = this.getInput();
        if (input instanceof IMindMap) {
            return ((IMindMap)input).getSheet();
        }
        if (input instanceof ISheet) {
            return (ISheet)input;
        }
        if (input instanceof ITopic) {
            return ((ITopic)input).getOwnedSheet();
        }
        return null;
    }

    @Override
    public ISheetPart getSheetPart() {
        IPart contents;
        IRootPart rootPart = this.getRootPart();
        if (rootPart != null && (contents = rootPart.getContents()) instanceof ISheetPart) {
            return (ISheetPart)contents;
        }
        return null;
    }

    @Override
    public boolean isPrimaryCentralTopic() {
        ISheet sheet = this.getSheet();
        ITopic centralTopic = this.getCentralTopic();
        return centralTopic != null && sheet != null && centralTopic.equals(sheet.getRootTopic());
    }

    public IPart findPart(Object element) {
        if (element instanceof ISummary) {
            element = ((ISummary)element).getTopic();
        }
        return super.findPart(element);
    }

    protected class MindMapSelectionSupport
    extends GraphicalViewer.GraphicalSelectionSupport {
        protected MindMapSelectionSupport() {
            super((GraphicalViewer)MindMapViewer.this);
        }

        public IPart findSelectablePart(Object element) {
            BranchFigure branchFigure;
            IBranchPart branch;
            if (element instanceof ISheet) {
                return null;
            }
            IPart p = super.findSelectablePart(element);
            if (p instanceof ITopicPart && (branch = MindMapUtils.findBranch(p)) != null && (branchFigure = (BranchFigure)branch.getFigure()).isMinimized()) {
                p = null;
            }
            return p;
        }

        protected Object getModel(IPart p) {
            return MindMapUtils.getRealModel(p);
        }

        public ISelection getModelSelection() {
            IStructuredSelection ss;
            ISelection selection = super.getModelSelection();
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).isEmpty() && MindMapViewer.this.getInput() != null) {
                selection = new StructuredSelection(MindMapUtils.toRealModel(MindMapViewer.this.getInput()));
            }
            return selection;
        }
    }
}

