/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.xmind.core.IImage;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.IDecorator;
import org.xmind.gef.IViewer;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.policy.NullEditPolicy;
import org.xmind.gef.service.IFeedback;
import org.xmind.gef.service.IImageRegistryService;
import org.xmind.gef.util.GEFUtils;
import org.xmind.ui.internal.AttachmentImageDescriptor;
import org.xmind.ui.internal.mindmap.ImageDecorator;
import org.xmind.ui.internal.mindmap.ImageDownloadCenter;
import org.xmind.ui.internal.mindmap.ImageFeedback;
import org.xmind.ui.internal.mindmap.ImageSelectionHelper;
import org.xmind.ui.internal.mindmap.MindMapPartBase;
import org.xmind.ui.internal.mindmap.TopicPart;
import org.xmind.ui.mindmap.IImagePart;
import org.xmind.ui.mindmap.ISelectionFeedbackHelper;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImagePart
extends MindMapPartBase
implements IImagePart {
    private ImageDescriptor imageDescriptor = null;
    private Image image = null;
    private boolean imageCreatable = true;
    private boolean imageNeedsDispose = false;
    private static List<ImageDescriptor> BusyImages = null;
    private static ImageDescriptor WarningImage = null;
    private Thread updateBusyImageThread;

    public ImagePart() {
        this.setDecorator((IDecorator)ImageDecorator.getInstance());
    }

    protected IFigure createFigure() {
        return new SizeableImageFigure();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == this.imageDescriptor) {
            return;
        }
        this.releaseImage();
        this.imageDescriptor = imageDescriptor;
    }

    private void releaseImage() {
        IImageRegistryService service;
        IViewer viewer = this.getSite().getViewer();
        if (viewer != null && (service = (IImageRegistryService)viewer.getService(IImageRegistryService.class)) != null) {
            service.decreaseRef(this.getImageDescriptor(), (Object)this);
        }
        if (this.image != null && this.imageNeedsDispose) {
            this.image.dispose();
        }
        this.image = null;
        this.imageNeedsDispose = false;
    }

    @Override
    public Image getImage() {
        if (this.image == null && this.imageCreatable) {
            this.image = this.createImage();
        }
        return this.image;
    }

    private Image createImage() {
        IImageRegistryService service;
        if (this.getImageDescriptor() == null) {
            return null;
        }
        IViewer viewer = this.getSite().getViewer();
        if (viewer != null && (service = (IImageRegistryService)viewer.getService(IImageRegistryService.class)) != null) {
            return service.getImage(this.getImageDescriptor(), false, (Object)this);
        }
        this.imageNeedsDispose = true;
        return this.getImageDescriptor().createImage(false, (Device)Display.getCurrent());
    }

    public SizeableImageFigure getImageFigure() {
        return (SizeableImageFigure)super.getFigure();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ITopic.class)) {
            return this.getTopic();
        }
        if (adapter == ITopicPart.class) {
            return this.getTopicPart();
        }
        if (adapter == IImage.class) {
            return this.getImageModel();
        }
        if (adapter == Image.class) {
            return this.getImage();
        }
        return super.getAdapter(adapter);
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.setImageDescriptor(this.createNewImageDescriptor());
    }

    @Override
    protected void onDeactivated() {
        ImageDownloadCenter.getInstance().cancel(this.getTopic());
        if (this.updateBusyImageThread != null) {
            this.updateBusyImageThread.interrupt();
            this.updateBusyImageThread = null;
        }
        this.imageCreatable = false;
        this.getImageFigure().setImage(null);
        this.releaseImage();
        super.onDeactivated();
    }

    @Override
    public IImage getImageModel() {
        return (IImage)super.getRealModel();
    }

    protected void register() {
        this.registerModel(this.getImageModel());
        super.register();
    }

    protected void unregister() {
        super.unregister();
        this.unregisterModel(this.getImageModel());
    }

    @Override
    public ITopic getTopic() {
        return this.getImageModel().getParent();
    }

    @Override
    public ITopicPart getTopicPart() {
        if (this.getParent() instanceof ITopicPart) {
            return (ITopicPart)this.getParent();
        }
        return null;
    }

    public void setParent(IPart parent) {
        TopicPart topicPart;
        if (this.getParent() instanceof TopicPart && (topicPart = (TopicPart)this.getParent()).getImagePart() == this) {
            topicPart.setImagePart(null);
        }
        super.setParent(parent);
        if (this.getParent() instanceof TopicPart) {
            topicPart = (TopicPart)this.getParent();
            topicPart.setImagePart(this);
        }
    }

    @Override
    protected void registerCoreEvents(ICoreEventSource source, ICoreEventRegister register) {
        super.registerCoreEvents(source, register);
        register.register("imageAlignment");
        register.register("imageHeight");
        register.register("imageSource");
        register.register("imageWidth");
    }

    @Override
    public void handleCoreEvent(CoreEvent event) {
        String type = event.getType();
        if ("imageAlignment".equals(type)) {
            this.getFigure().revalidate();
        } else if ("imageHeight".equals(type) || "imageWidth".equals(type)) {
            this.update();
        } else if ("imageSource".equals(type)) {
            this.setImageDescriptor(this.createNewImageDescriptor());
            this.update();
        } else {
            super.handleCoreEvent(event);
        }
    }

    private ImageDescriptor createNewImageDescriptor() {
        IImage imageModel;
        String source;
        if (this.isDownloading()) {
            return ImagePart.getBusyImageDescriptor(0);
        }
        if (this.updateBusyImageThread != null) {
            this.updateBusyImageThread.interrupt();
            this.updateBusyImageThread = null;
        }
        if ((source = (imageModel = this.getImageModel()).getSource()) != null && HyperlinkUtils.isAttachmentURL((String)source)) {
            String path = HyperlinkUtils.toAttachmentPath((String)source);
            return AttachmentImageDescriptor.createFromEntryPath(imageModel.getOwnedWorkbook(), path);
        }
        return ImagePart.getWarningImageDescriptor();
    }

    private static List<ImageDescriptor> getBusyImageDescriptors() {
        if (BusyImages == null) {
            BusyImages = ImagePart.findBusyImageDescriptors();
        }
        return BusyImages;
    }

    private static ImageDescriptor getWarningImageDescriptor() {
        if (WarningImage == null) {
            WarningImage = ImageDescriptor.createFromImage((Image)Display.getCurrent().getSystemImage(8));
        }
        return WarningImage;
    }

    private static List<ImageDescriptor> findBusyImageDescriptors() {
        ArrayList<ImageDescriptor> list = new ArrayList<ImageDescriptor>();
        int index = 1;
        while (index <= 12) {
            String path = String.format("/icons/busy/busy_f%02d.gif", index);
            ImageDescriptor img = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.xmind.ui.browser", (String)path);
            if (img != null) {
                list.add(img);
            }
            ++index;
        }
        if (list.isEmpty()) {
            list.add(MindMapUI.getImages().get("nav_stop.gif", true));
        }
        return list;
    }

    private static ImageDescriptor getBusyImageDescriptor(int index) {
        return ImagePart.getBusyImageDescriptors().get(index);
    }

    public boolean isDownloading() {
        return ImageDownloadCenter.getInstance().isDownloading(this.getTopic());
    }

    public boolean hasProblem() {
        return this.getImageDescriptor() != null && this.getImageDescriptor() == WarningImage;
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
        super.declareEditPolicies(reqHandler);
        reqHandler.installEditPolicy("selectable role", (IEditPolicy)NullEditPolicy.getInstance());
        reqHandler.installEditPolicy("deletable role", "org.xmind.ui.editPolicy.deletable");
        reqHandler.installEditPolicy("movable role", "org.xmind.ui.editPolicy.imageMovable");
    }

    @Override
    protected IFeedback createFeedback() {
        return new ImageFeedback(this);
    }

    @Override
    protected ISelectionFeedbackHelper createSelectionFeedbackHelper() {
        return new ImageSelectionHelper();
    }

    public IPart findAt(Point position) {
        ITopicPart topicPart;
        if (!this.getStatus().isSelected() && (topicPart = this.getTopicPart()) != null && !topicPart.getStatus().isSelected()) {
            return null;
        }
        return super.findAt(position);
    }

    public boolean containsPoint(Point position) {
        return super.containsPoint(position) || this.getSelectionOrientation(position) != 0;
    }

    public Cursor getCursor(Point pos) {
        int orientation = this.getSelectionOrientation(pos);
        if (orientation != 0) {
            return GEFUtils.getPositionCursor((int)orientation);
        }
        return super.getCursor(pos);
    }

    private int getSelectionOrientation(Point point) {
        if (this.getStatus().isPreSelected() || this.getStatus().isSelected()) {
            return ((ImageFeedback)this.getFeedback()).getOrientation(point);
        }
        return 0;
    }
}

