/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.xmind.core.ITopic;
import org.xmind.gef.IDecorator;
import org.xmind.gef.IViewer;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.policy.NullEditPolicy;
import org.xmind.gef.service.IFeedback;
import org.xmind.gef.service.IImageRegistryService;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.ui.internal.decorators.IconTipDecorator;
import org.xmind.ui.internal.mindmap.IconTip;
import org.xmind.ui.internal.mindmap.MindMapPartBase;
import org.xmind.ui.internal.mindmap.SelectionFeedbackHelper;
import org.xmind.ui.internal.mindmap.SimpleSelectionFeedback;
import org.xmind.ui.internal.mindmap.TopicPart;
import org.xmind.ui.mindmap.IIconTipPart;
import org.xmind.ui.mindmap.ISelectionFeedbackHelper;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.resources.FontUtils;

public class IconTipPart
extends MindMapPartBase
implements IIconTipPart,
IPropertyChangeListener {
    private IAction action;
    private Menu menu;
    private String actionId;
    private ImageDescriptor imageDescriptor;
    private Image image;
    private boolean imageCreatable = true;
    private boolean imageNeedsDispose = false;

    public IconTipPart() {
        this.setDecorator((IDecorator)IconTipDecorator.getInstance());
    }

    protected IFigure createFigure() {
        return new SizeableImageFigure();
    }

    public IAction getAction() {
        return this.action;
    }

    public Image getImage() {
        if (this.image == null && this.imageCreatable) {
            this.image = this.createImage();
        }
        return this.image;
    }

    public SizeableImageFigure getImageFigure() {
        return (SizeableImageFigure)super.getFigure();
    }

    public Menu getPopupMenu() {
        return this.menu;
    }

    public ITopic getTopic() {
        return (ITopic)super.getRealModel();
    }

    public ITopicPart getTopicPart() {
        if (this.getParent() instanceof ITopicPart) {
            return (ITopicPart)this.getParent();
        }
        return null;
    }

    public void setParent(IPart parent) {
        if (this.getParent() instanceof TopicPart) {
            ((TopicPart)this.getParent()).removeIconTip(this);
        }
        super.setParent(parent);
        if (this.getParent() instanceof TopicPart) {
            ((TopicPart)this.getParent()).addIconTip(this);
        }
    }

    protected void register() {
        super.register();
        if (this.getModel() instanceof IconTip) {
            this.setAction(((IconTip)this.getModel()).getAction());
        }
    }

    protected void unregister() {
        this.setAction(null);
        super.unregister();
    }

    public void setAction(IAction action) {
        if (action == this.action) {
            return;
        }
        if (this.action != null) {
            this.action.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        if (this.actionId != null) {
            this.unregisterAction(this.actionId, this.action);
        }
        this.action = action;
        String string = this.actionId = action == null ? null : action.getId();
        if (this.actionId != null) {
            this.registerAction(action);
        }
        if (action != null) {
            action.addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    private void unregisterAction(String actionId, IAction action) {
        ITopicPart topicPart = this.getTopicPart();
        if (topicPart == null) {
            return;
        }
        IActionRegistry actionRegistry = (IActionRegistry)topicPart.getAdapter(IActionRegistry.class);
        if (actionRegistry == null) {
            return;
        }
        if (actionRegistry.getAction(actionId) == action) {
            actionRegistry.removeAction(actionId);
        }
    }

    private void registerAction(IAction action) {
        ITopicPart topicPart = this.getTopicPart();
        if (topicPart == null) {
            return;
        }
        IActionRegistry actionRegistry = (IActionRegistry)topicPart.getAdapter(IActionRegistry.class);
        if (actionRegistry == null) {
            return;
        }
        actionRegistry.addAction(action);
    }

    private Image createImage() {
        IImageRegistryService service;
        IViewer viewer = this.getSite().getViewer();
        ImageDescriptor descriptor = this.getImageDescriptor();
        if (viewer != null && (service = (IImageRegistryService)viewer.getService(IImageRegistryService.class)) != null) {
            return service.getImage(descriptor, false, (Object)this);
        }
        this.imageNeedsDispose = true;
        return descriptor == null ? null : descriptor.createImage(false, (Device)Display.getCurrent());
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor == null) {
            this.imageDescriptor = this.action == null ? null : this.action.getImageDescriptor();
        }
        return this.imageDescriptor;
    }

    protected void onDeactivated() {
        IImageRegistryService service;
        this.imageCreatable = false;
        IViewer viewer = this.getSite().getViewer();
        if (viewer != null && (service = (IImageRegistryService)viewer.getService(IImageRegistryService.class)) != null) {
            service.decreaseRef(this.getImageDescriptor(), (Object)this);
        }
        if (this.image != null && this.imageNeedsDispose) {
            this.image.dispose();
        }
        this.image = null;
        super.onDeactivated();
    }

    protected void updateView() {
        super.updateView();
        this.updateToolTip();
    }

    protected IFigure createToolTip() {
        if (this.action != null) {
            String text = this.action.getText();
            String tooltip = this.action.getToolTipText();
            if (text != null || tooltip != null) {
                Figure fig = new Figure();
                fig.setBorder((Border)new MarginBorder(1, 3, 1, 3));
                ToolbarLayout layout = new ToolbarLayout(false);
                layout.setMinorAlignment(1);
                layout.setSpacing(7);
                fig.setLayoutManager((LayoutManager)layout);
                if (text != null) {
                    text = Action.removeAcceleratorText((String)text);
                    text = Action.removeMnemonics((String)text);
                    Label title = new Label(text);
                    title.setFont(FontUtils.getBold((String)"org.eclipse.jface.defaultfont"));
                    fig.add((IFigure)title);
                }
                if (tooltip != null) {
                    RotatableWrapLabel description = new RotatableWrapLabel(tooltip, 0);
                    description.setTextAlignment(1);
                    description.setPrefWidth(Display.getCurrent().getClientArea().width / 3);
                    description.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-1));
                    description.setForegroundColor(ColorConstants.gray);
                    fig.add((IFigure)description);
                }
                return fig;
            }
        }
        return super.createToolTip();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ITopic.class)) {
            return this.getTopic();
        }
        if (adapter == Image.class) {
            return this.getImage();
        }
        if (adapter == IAction.class) {
            return this.getAction();
        }
        if (adapter == IMenuManager.class) {
            return this.getPopupMenu();
        }
        return super.getAdapter(adapter);
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
        super.declareEditPolicies(reqHandler);
        reqHandler.installEditPolicy("selectable role", (IEditPolicy)NullEditPolicy.getInstance());
    }

    protected IFeedback createFeedback() {
        return new SimpleSelectionFeedback(this);
    }

    protected ISelectionFeedbackHelper createSelectionFeedbackHelper() {
        return new SelectionFeedbackHelper();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("text".equals(property) || "toolTipText".equals(property)) {
            this.updateToolTip();
        } else if ("image".equals(property)) {
            this.image = null;
            this.imageDescriptor = null;
            this.update();
        }
    }
}

