/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.ISelection;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.service.ZoomingAndPanningRevealService;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.MindMapUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CenteredRevealService
extends ZoomingAndPanningRevealService {
    private double cachedScale = -1.0;

    public CenteredRevealService(IGraphicalViewer viewer, boolean autoRevealSelection) {
        super(viewer, autoRevealSelection);
    }

    protected boolean exclude(IPart part) {
        return part instanceof ISheetPart;
    }

    protected void startReveal(ISelection selection) {
        this.cachedScale = -1.0;
        super.startReveal(selection);
    }

    protected boolean isAnimationEnabled() {
        return MindMapUI.isAnimationEnabled();
    }

    protected PrecisionPoint calcTargetCenter(List<IGraphicalPart> toReveal, Rectangle revealBounds, double targetScale) {
        return new PrecisionPoint(revealBounds.getCenter());
    }

    protected double calcTargetScale(List<IGraphicalPart> toReveal, Rectangle revealBounds) {
        if (!this.isActive()) {
            return 1.0;
        }
        if (this.cachedScale > 0.0) {
            return this.cachedScale;
        }
        Rectangle clientArea = this.getViewer().getClientArea();
        int width = revealBounds.width;
        int height = revealBounds.height;
        double scale = 2.3;
        double w = (double)width * scale;
        double h = (double)height * scale;
        double minWidth = (double)clientArea.width * 0.08;
        double minHeight = (double)clientArea.height * 0.08;
        if (w < minWidth || h < minHeight) {
            double s1 = w < minWidth ? minWidth / (double)width : scale;
            double s2 = h < minHeight ? minHeight / (double)height : scale;
            scale = Math.max(s1, s2);
            w = (double)width * scale;
            h = (double)height * scale;
        }
        double maxWidth = (double)clientArea.width * 0.6;
        double maxHeight = (double)clientArea.height * 0.6;
        if (w > maxWidth || h > maxHeight) {
            double s1 = w > maxWidth ? maxWidth / (double)width : scale;
            double s2 = h > maxHeight ? maxHeight / (double)height : scale;
            scale = Math.min(s1, s2);
        }
        this.cachedScale = scale;
        return scale;
    }
}

