/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.layers;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.xmind.gef.draw2d.ISkylightLayer;
import org.xmind.ui.internal.layers.BaseLayer;

public class SkylightLayer
extends BaseLayer
implements ISkylightLayer {
    private Rectangle skylight = null;

    public SkylightLayer() {
        this.setMainAlpha(128);
    }

    public void setSkylight(Rectangle skylight) {
        if (skylight == null && this.skylight == null) {
            return;
        }
        if (skylight != null && skylight.equals((Object)this.skylight)) {
            return;
        }
        if (skylight == null) {
            this.skylight = null;
        } else if (this.skylight == null) {
            this.skylight = new Rectangle(skylight);
        } else {
            this.skylight.setBounds(skylight);
        }
        this.repaint();
    }

    public Rectangle getSkylight() {
        return this.skylight;
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.skylight != null) {
            this.paintSkylight(graphics);
        }
    }

    public void paint(Graphics graphics) {
        this.simplePaint(graphics);
    }

    protected void paintSkylight(Graphics graphics) {
        int bottom;
        int right;
        int left;
        graphics.setBackgroundColor(this.getCoverColor());
        graphics.setAlpha(this.getMainAlpha());
        Rectangle r = this.getBounds();
        int top = this.skylight.y - r.y;
        if (top > 0) {
            graphics.fillRectangle(r.x, r.y, r.width, top);
        }
        if ((left = this.skylight.x - r.x) > 0) {
            graphics.fillRectangle(r.x, this.skylight.y, left, this.skylight.height);
        }
        if ((right = r.width - this.skylight.width - left) > 0) {
            graphics.fillRectangle(this.skylight.right(), this.skylight.y, right, this.skylight.height);
        }
        if ((bottom = r.height - this.skylight.height - top) > 0) {
            graphics.fillRectangle(r.x, this.skylight.bottom(), r.width, bottom);
        }
    }

    protected Color getCoverColor() {
        Color color = this.getLocalBackgroundColor();
        if (color == null) {
            color = ColorConstants.black;
        }
        return color;
    }
}

