/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.layers;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.GEF;
import org.xmind.gef.draw2d.graphics.AlphaGraphics;
import org.xmind.ui.internal.layers.CoverLayer;
import org.xmind.ui.internal.layers.DefaultLayeredPane;
import org.xmind.ui.internal.layers.SkylightLayer;
import org.xmind.ui.internal.layers.TitleLayer;
import org.xmind.ui.internal.layers.UndoRedoTipsLayer;
import org.xmind.ui.mindmap.MindMapUI;

public class MindMapLayeredPane
extends DefaultLayeredPane {
    private int targetAlpha = 255;
    private boolean schedulePaint = MindMapUI.isAnimationEnabled();
    private int alpha = this.schedulePaint ? 0 : this.targetAlpha;

    protected void addLayers() {
        super.addLayers();
        this.getScalableLayeredPane().addLayerAfter((Layer)new TitleLayer(), MindMapUI.LAYER_TITLE, GEF.LAYER_CONTENTS);
        this.getScalableLayeredPane().addLayerAfter((Layer)new UndoRedoTipsLayer(), MindMapUI.LAYER_UNDO, MindMapUI.LAYER_TITLE);
        CoverLayer coverLayer = new CoverLayer();
        this.getScalableLayeredPane().add((IFigure)coverLayer, MindMapUI.LAYER_COVER);
        coverLayer.addBackgroundLayer((IFigure)this.getLayer(GEF.LAYER_BACKGROUND));
        coverLayer.addBackgroundLayer((IFigure)this.getLayer(GEF.LAYER_SHADOW));
        this.add((IFigure)new SkylightLayer(), MindMapUI.LAYER_SKYLIGHT);
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        if (alpha == this.alpha) {
            return;
        }
        this.alpha = alpha;
        this.repaint();
    }

    public int getTargetAlpha() {
        return this.targetAlpha;
    }

    public void setTargetAlpha(int targetAlpha) {
        this.targetAlpha = targetAlpha = Math.max(0, Math.min(255, targetAlpha));
        this.checkSchedule();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.schedulePaint) {
            Display.getCurrent().timerExec(50, new Runnable(){

                public void run() {
                    MindMapLayeredPane.this.setAlpha(MindMapLayeredPane.this.getNewAlpha());
                    MindMapLayeredPane.this.checkSchedule();
                }
            });
        }
        this.schedulePaint = false;
    }

    private void checkSchedule() {
        this.schedulePaint = this.shouldSchedulePaint();
        if (!this.schedulePaint) {
            this.setAlpha(this.getTargetAlpha());
        } else {
            this.repaint();
        }
    }

    private boolean shouldSchedulePaint() {
        return this.getAlpha() != this.getTargetAlpha() && MindMapUI.isAnimationEnabled();
    }

    private int getNewAlpha() {
        if (this.getAlpha() < this.getTargetAlpha()) {
            return Math.min(this.getTargetAlpha(), this.getAlpha() + 30);
        }
        if (this.getAlpha() > this.getTargetAlpha()) {
            return Math.max(this.getTargetAlpha(), this.getAlpha() - 30);
        }
        return this.getTargetAlpha();
    }

    protected void paintChildren(Graphics graphics) {
        if (this.getAlpha() <= 0) {
            return;
        }
        if (this.getAlpha() >= 255) {
            super.paintChildren(graphics);
        } else {
            AlphaGraphics ag = new AlphaGraphics(graphics);
            ag.setMainAlpha(this.getAlpha());
            super.paintChildren((Graphics)ag);
            ag.dispose();
        }
    }
}

