/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.figures;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.xmind.ui.resources.ColorUtils;

public class PlusMinusFigure
extends Figure {
    private static final float MARGIN = 2.5f;
    private static final int FLAG_PLUS_MINUS = MAX_FLAG << 1;
    private static final int FLAG_PRESELECTED;
    private static final Color FillPlus;
    private static final Color FillPlus2;
    private static final Color FillMinus;
    private static final Color FillMinus2;
    private static final Color BorderPlus;
    private static final Color BorderMinus;
    private static final Color ContentPlus;
    private static final Color ContentMinus;

    static {
        MAX_FLAG = FLAG_PRESELECTED = MAX_FLAG << 2;
        FillPlus = ColorUtils.getColor((int)200, (int)228, (int)248);
        FillPlus2 = ColorUtils.getColor((int)160, (int)196, (int)234);
        FillMinus = ColorUtils.getColor((int)210, (int)230, (int)255);
        FillMinus2 = ColorUtils.getColor((int)180, (int)210, (int)240);
        BorderPlus = ColorUtils.getColor((int)120, (int)136, (int)162);
        BorderMinus = ColorUtils.getColor((int)180, (int)200, (int)240);
        ContentPlus = ColorUtils.getColor((int)48, (int)64, (int)96);
        ContentMinus = ColorUtils.getColor((int)150, (int)160, (int)200);
    }

    public PlusMinusFigure() {
    }

    public PlusMinusFigure(boolean plusOrMinus) {
        this.setFlag(FLAG_PLUS_MINUS, plusOrMinus);
    }

    public boolean getValue() {
        return this.getFlag(FLAG_PLUS_MINUS);
    }

    public void setValue(boolean plusOrMinus) {
        boolean currentState = this.getValue();
        if (plusOrMinus == currentState) {
            return;
        }
        this.setFlag(FLAG_PLUS_MINUS, plusOrMinus);
        this.repaint();
    }

    public boolean isPreselected() {
        return this.getFlag(FLAG_PRESELECTED);
    }

    public void setPreselected(boolean preselected) {
        boolean currentPreselection = this.isPreselected();
        if (preselected == currentPreselection) {
            return;
        }
        this.setFlag(FLAG_PRESELECTED, preselected);
        this.repaint();
    }

    protected Color getFillColor() {
        return this.getValue() ? (this.isPreselected() ? FillPlus2 : FillPlus) : (this.isPreselected() ? FillMinus2 : FillMinus);
    }

    protected Color getBorderColor() {
        return this.getValue() ? BorderPlus : BorderMinus;
    }

    protected Color getContentColor() {
        return this.getValue() ? ContentPlus : ContentMinus;
    }

    protected void paintFigure(Graphics g) {
        g.setAntialias(1);
        super.paintFigure(g);
        g.setLineWidth(1);
        g.setLineStyle(1);
        Rectangle rect = this.getBounds();
        float l = (float)rect.x + 0.5f;
        float t = (float)rect.y + 0.5f;
        float r = (float)rect.right() - 1.5f;
        float b = (float)rect.bottom() - 1.5f;
        org.xmind.gef.draw2d.graphics.Path p = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        p.addArc(l, t, r - l, b - t, 0.0f, 360.0f);
        g.setBackgroundColor(this.getFillColor());
        g.fillPath((Path)p);
        g.setForegroundColor(this.getBorderColor());
        g.drawPath((Path)p);
        p.dispose();
        g.setForegroundColor(this.getContentColor());
        p = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        float centerY = (t + b) / 2.0f;
        p.moveTo(l + 2.5f, centerY);
        p.lineTo(r - 2.5f, centerY);
        if (this.getValue()) {
            float centerX = (l + r) / 2.0f;
            p.moveTo(centerX, t + 2.5f);
            p.lineTo(centerX, b - 2.5f);
        }
        g.drawPath((Path)p);
        p.dispose();
    }
}

