/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.figures;

import java.util.Iterator;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.IDecoratedFigure;
import org.xmind.gef.draw2d.IDecoratedFigureListener;
import org.xmind.gef.draw2d.IMinimizable;
import org.xmind.gef.draw2d.IShadowedFigure;
import org.xmind.gef.draw2d.ITransparentableFigure;
import org.xmind.gef.draw2d.ReferencedFigure;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.draw2d.decoration.IShadowedDecoration;
import org.xmind.gef.draw2d.graphics.AlphaGraphics;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;
import org.xmind.gef.draw2d.graphics.GrayedGraphics;
import org.xmind.ui.decorations.IBranchDecoration;
import org.xmind.ui.internal.figures.TopicFigure;

public class BranchFigure
extends ReferencedFigure
implements IDecoratedFigure,
IMinimizable,
IShadowedFigure,
ITransparentableFigure {
    private static final int FLAG_FOLDED = MAX_FLAG << 1;
    private static final int FLAG_MINIMIZED;
    private IDecoration connections = null;
    private IDecoration decoration = null;
    private int mainAlpha = 255;
    private int alpha = 255;

    static {
        MAX_FLAG = FLAG_MINIMIZED = MAX_FLAG << 2;
    }

    public boolean isFolded() {
        return this.getFlag(FLAG_FOLDED);
    }

    public void setFolded(boolean folded) {
        if (folded == this.isFolded()) {
            return;
        }
        this.setFlag(FLAG_FOLDED, folded);
        this.revalidate();
        this.repaint();
    }

    public boolean isMinimized() {
        return this.getFlag(FLAG_MINIMIZED);
    }

    public void setMinimized(boolean minimized) {
        if (minimized == this.isMinimized()) {
            return;
        }
        this.setFlag(FLAG_MINIMIZED, minimized);
        this.revalidate();
        this.repaint();
    }

    public IDecoration getConnections() {
        return this.connections;
    }

    public void setConnections(IDecoration connections) {
        if (connections == this.connections) {
            return;
        }
        this.connections = connections;
        this.revalidate();
        this.repaint();
    }

    public IDecoration getDecoration() {
        return this.decoration;
    }

    public void setDecoration(IDecoration decoration) {
        IDecoration oldDecoration = this.decoration;
        if (decoration == oldDecoration) {
            return;
        }
        this.decoration = decoration;
        this.fireDecorationChanged(oldDecoration, decoration);
        this.repaint();
    }

    public void addDecoratedFigureListener(IDecoratedFigureListener listener) {
        this.addListener(IDecoratedFigureListener.class, listener);
    }

    public void removeDecoratedFigureListener(IDecoratedFigureListener listener) {
        this.removeListener(IDecoratedFigureListener.class, listener);
    }

    protected void fireDecorationChanged(IDecoration oldDecoration, IDecoration newDecoration) {
        Iterator listeners = this.getListeners(IDecoratedFigureListener.class);
        while (listeners.hasNext()) {
            ((IDecoratedFigureListener)listeners.next()).decorationChanged((IDecoratedFigure)this, oldDecoration, newDecoration);
        }
    }

    public boolean isShadowShowing() {
        return this.isShowing() && this.getMainAlpha() > 0;
    }

    public int getMainAlpha() {
        return this.mainAlpha;
    }

    public int getSubAlpha() {
        return this.alpha;
    }

    public void setMainAlpha(int alpha) {
        if (alpha == this.mainAlpha) {
            return;
        }
        this.mainAlpha = alpha;
        this.repaint();
    }

    public void setSubAlpha(int alpha) {
        if (alpha == this.alpha) {
            return;
        }
        this.alpha = alpha;
        this.repaint();
    }

    public void invalidate() {
        if (this.connections != null) {
            this.connections.invalidate();
        }
        if (this.decoration != null) {
            this.decoration.invalidate();
        }
        super.invalidate();
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.repaint();
    }

    public void paint(Graphics graphics) {
        GraphicsUtils.fixGradientBugForCarbon((Graphics)graphics, (IFigure)this);
        if (this.getMainAlpha() < 255) {
            AlphaGraphics ag = new AlphaGraphics(graphics);
            ag.setMainAlpha(this.getMainAlpha());
            ag.setAlpha(graphics.getAlpha());
            try {
                this.doPaint((Graphics)ag);
            }
            finally {
                ag.dispose();
            }
        } else {
            this.doPaint(graphics);
        }
    }

    private void doPaint(Graphics graphics) {
        if (this.isEnabled()) {
            super.paint(graphics);
        } else {
            GrayedGraphics gg = new GrayedGraphics(graphics);
            try {
                super.paint((Graphics)gg);
            }
            finally {
                gg.dispose();
            }
        }
    }

    protected void paintFigure(Graphics graphics) {
        if (this.getSubAlpha() < 255) {
            AlphaGraphics ag = new AlphaGraphics(graphics);
            ag.setMainAlpha(this.getSubAlpha());
            try {
                this.doPaintFigure((Graphics)ag);
            }
            finally {
                ag.dispose();
            }
        } else {
            this.doPaintFigure(graphics);
        }
    }

    private void doPaintFigure(Graphics graphics) {
        graphics.setAntialias(1);
        super.paintFigure(graphics);
        if (this.decoration != null) {
            this.decoration.paint((IFigure)this, graphics);
        }
        if (this.connections != null) {
            this.connections.paint((IFigure)this, graphics);
        }
    }

    protected void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
        if (this.decoration != null && this.decoration instanceof IBranchDecoration) {
            ((IBranchDecoration)this.decoration).paintAboveChildren((IFigure)this, graphics);
        }
    }

    public void paintShadow(Graphics graphics) {
        if (this.connections != null && this.connections instanceof IShadowedDecoration) {
            ((IShadowedDecoration)this.connections).paintShadow((IFigure)this, graphics);
        }
        if (this.decoration != null && this.decoration instanceof IShadowedDecoration) {
            ((IShadowedDecoration)this.decoration).paintShadow((IFigure)this, graphics);
        }
    }

    public String toString() {
        for (Object c : this.getChildren()) {
            if (!(c instanceof TopicFigure)) continue;
            return c.toString();
        }
        return super.toString();
    }
}

