/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.xmind.core.IWorkbook;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.WorkbookFactory;

public class WorkbookEditorInput
implements IEditorInput {
    private static int NUMBER = 0;
    private String name;
    private InputStream templateStream;
    private IWorkbook contents;

    public WorkbookEditorInput() {
        this(WorkbookFactory.createEmptyWorkbook());
    }

    public WorkbookEditorInput(String name) {
        this.name = name;
    }

    public WorkbookEditorInput(String name, IWorkbook workbook) {
        this(name);
        this.contents = workbook;
    }

    public WorkbookEditorInput(String name, InputStream templateStream) {
        this(name);
        this.templateStream = templateStream;
    }

    public WorkbookEditorInput(IWorkbook contents) {
        this((String)null);
        if (contents == null) {
            throw new IllegalArgumentException();
        }
        this.contents = contents;
    }

    public WorkbookEditorInput(IWorkbook contents, String targetFile) {
        this(contents);
    }

    public WorkbookEditorInput(IWorkbook contents, String targetFile, boolean initialDirty) {
        this(contents);
    }

    public WorkbookEditorInput(IWorkbook contents, IFile targetResourceFile) {
        this(contents);
    }

    public InputStream getTemplateStream() {
        return this.templateStream;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        if (this.name == null) {
            this.name = NLS.bind((String)MindMapMessages.WorkbookEditorInput_name, (Object)(++NUMBER));
        }
        return this.name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getName();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWorkbook.class) {
            return this.getContents();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IWorkbook getContents() {
        return this.contents;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof WorkbookEditorInput)) {
            return false;
        }
        WorkbookEditorInput that = (WorkbookEditorInput)obj;
        if (this.contents == null || that.contents == null) {
            return false;
        }
        return that.contents.equals(this.contents);
    }
}

