/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.ui.actions.PageAction;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.ui.editor.IPanel;
import org.xmind.gef.ui.editor.IPanelContribution;
import org.xmind.gef.ui.editor.PanelContribution;
import org.xmind.gef.ui.editor.PanelContributor;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.mindmap.IDrillDownTraceListener;
import org.xmind.ui.mindmap.IDrillDownTraceService;
import org.xmind.ui.mindmap.MindMap;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.MindMapUtils;

public class MindMapEditorPagePanelContributor
extends PanelContributor {
    private Crumbs crumbs = null;

    protected void init(IPanel panel) {
        super.init(panel);
        this.crumbs = new Crumbs();
        this.crumbs.setVisible(false);
        panel.addContribution(1, (IPanelContribution)this.crumbs);
    }

    public void setViewer(IGraphicalViewer viewer) {
        super.setViewer(viewer);
        IDrillDownTraceService traceService = (IDrillDownTraceService)viewer.getService(IDrillDownTraceService.class);
        this.crumbs.setTraceService(traceService);
    }

    public void dispose() {
        this.crumbs.setTraceService(null);
        super.dispose();
    }

    private static class CrumbItem
    implements IPropertyChangeListener {
        private static final int H_MARGIN = 8;
        private static final int V_MARGIN = 2;
        private static final int M = 2;
        private static final int M2 = 3;
        private static final int W = 5;
        private static final int W2 = 6;
        private static final int C2 = 13;
        private static final int C = 14;
        private static final int SPACING = 1;
        private CrumbsBar bar;
        private IAction action;
        private Rectangle bounds;
        private boolean mouseOver;
        private boolean pressed;
        private Image image = null;

        public CrumbItem() {
            this(null);
        }

        public CrumbItem(IAction action) {
            this.action = action;
        }

        void setParent(CrumbsBar bar) {
            if (bar == this.bar) {
                return;
            }
            if (this.action != null) {
                if (this.bar == null && bar != null) {
                    this.action.addPropertyChangeListener((IPropertyChangeListener)this);
                } else if (this.bar != null && bar == null) {
                    this.action.removePropertyChangeListener((IPropertyChangeListener)this);
                }
            }
            this.bar = bar;
        }

        public void setMouseOver(boolean mouseOver) {
            if (mouseOver == this.mouseOver) {
                return;
            }
            this.mouseOver = mouseOver;
            this.redraw();
        }

        public boolean isMouseOver() {
            return this.mouseOver;
        }

        public void setPressed(boolean pressed) {
            if (pressed == this.pressed) {
                return;
            }
            this.pressed = pressed;
            this.redraw();
        }

        public boolean isPressed() {
            return this.pressed;
        }

        public void setBounds(Rectangle bounds) {
            if (bounds == this.bounds || bounds != null && bounds.equals((Object)this.bounds)) {
                return;
            }
            this.bounds = bounds;
            this.redraw();
        }

        public Rectangle getBounds() {
            if (this.bounds == null) {
                this.bounds = new Rectangle(0, 0, 0, 0);
            }
            return this.bounds;
        }

        public boolean isEnabled() {
            return this.action != null && this.action.isEnabled();
        }

        private void redraw() {
            if (this.barExists()) {
                this.bar.redraw(this);
            }
        }

        public boolean isSeparator() {
            return this.action == null;
        }

        Point getPrefSize() {
            if (!this.barExists()) {
                return new Point(0, 0);
            }
            GC gc = new GC((Drawable)Display.getCurrent());
            gc.setFont(this.bar.getFont());
            Point s = gc.textExtent(this.getText());
            gc.dispose();
            int h = this.getHMargin();
            int v = this.getVMargin();
            Image img = this.getImage();
            if (img != null) {
                Rectangle r = img.getBounds();
                s.x += r.width + 1;
                s.y = Math.max(s.y, r.height);
            }
            s.x += h + h + 1;
            s.y += v + v + 1;
            return s;
        }

        private int getHMargin() {
            if (this.isSeparator()) {
                return 0;
            }
            return 8;
        }

        private int getVMargin() {
            if (this.isSeparator()) {
                return 0;
            }
            return 2;
        }

        protected void paint(GC gc) {
            gc.setAntialias(1);
            gc.setLineStyle(1);
            gc.setLineWidth(1);
            if (this.pressed || this.mouseOver) {
                if (this.pressed && this.mouseOver) {
                    gc.setBackground(ColorUtils.getColor((String)"#a0a0a0"));
                } else if (this.pressed) {
                    gc.setBackground(ColorUtils.getColor((String)"#707070"));
                } else {
                    gc.setBackground(ColorUtils.getColor((String)"#e0e0e0"));
                }
                gc.fillRoundRectangle(this.bounds.x + 3, this.bounds.y + 3, this.bounds.width - 6, this.bounds.height - 6, 13, 13);
                if (this.pressed && this.mouseOver) {
                    gc.setForeground(ColorUtils.getColor((String)"#909090"));
                } else if (this.pressed) {
                    gc.setForeground(ColorUtils.getColor((String)"#606060"));
                } else {
                    gc.setForeground(ColorUtils.getColor((String)"#d0d0d0"));
                }
                gc.drawRoundRectangle(this.bounds.x + 2, this.bounds.y + 2, this.bounds.width - 5, this.bounds.height - 5, 14, 14);
            }
            int h = this.getHMargin();
            int v = this.getVMargin();
            int x = this.bounds.x + h;
            int y = this.bounds.y + v;
            int height = this.bounds.height - v - v;
            Image img = this.getImage();
            if (img != null) {
                Rectangle r = img.getBounds();
                gc.drawImage(img, x, y + (height - r.height) / 2);
                x += r.width + 1;
            }
            if (this.isSeparator() || !this.isEnabled()) {
                gc.setForeground(ColorUtils.getColor((String)"#a0a0a0"));
            } else if (this.pressed) {
                gc.setForeground(ColorUtils.getColor((String)"#f0f0f0"));
            } else {
                gc.setForeground(ColorUtils.getColor((String)"#000000"));
            }
            String text = this.getText();
            Point s = gc.textExtent(text);
            gc.drawText(text, x, y + (height - s.y) / 2, true);
        }

        protected String getText() {
            if (this.action != null) {
                String text = this.action.getText();
                if (text != null) {
                    return text;
                }
                return "";
            }
            return ">";
        }

        protected Image getImage() {
            if (this.image == null && this.barExists() && this.action != null) {
                ImageDescriptor imgDesc = null;
                Display display = this.bar.getDisplay();
                if (!this.isEnabled()) {
                    imgDesc = this.action.getDisabledImageDescriptor();
                    if (imgDesc != null) {
                        this.image = imgDesc.createImage((Device)display);
                    }
                    if (this.image == null && (imgDesc = this.action.getImageDescriptor()) != null) {
                        Image img = imgDesc.createImage((Device)display);
                        this.image = new Image((Device)display, img, 1);
                        img.dispose();
                    }
                } else {
                    imgDesc = this.action.getImageDescriptor();
                    if (imgDesc != null) {
                        this.image = imgDesc.createImage((Device)display);
                    }
                }
            }
            return this.image;
        }

        protected void run() {
            if (this.action != null) {
                this.action.run();
            }
        }

        public void update(String id) {
            boolean needUpdateBar;
            boolean textChange = id == null || "text".equals(id);
            boolean tooltipChange = id == null || "toolTipText".equals(id);
            boolean enabledChange = id == null || "enabled".equals(id);
            boolean imageChange = id == null || "image".equals(id);
            boolean bl = needUpdateBar = textChange || imageChange;
            if (this.barExists()) {
                this.bar.setRedraw(false);
            }
            if (enabledChange) {
                this.redraw();
            }
            if (tooltipChange && this.action != null && this.barExists()) {
                this.bar.setToolTipText(this.action.getToolTipText());
            }
            if (imageChange && this.image != null) {
                this.image.dispose();
                this.image = null;
            }
            if (needUpdateBar && this.barExists()) {
                this.bar.updateLayout();
            }
            if (this.barExists()) {
                this.bar.setRedraw(true);
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            this.update(event.getProperty());
        }

        public IAction getAction() {
            return this.action;
        }

        protected boolean barExists() {
            return this.bar != null && !this.bar.isDisposed();
        }

        protected void releaseResources() {
            if (this.image != null) {
                this.image.dispose();
                this.image = null;
            }
        }
    }

    class Crumbs
    extends PanelContribution
    implements IDrillDownTraceListener {
        private CrumbsBar bar = null;
        private IDrillDownTraceService service = null;

        Crumbs() {
        }

        public void createControl(Composite parent) {
            if (!this.barExists()) {
                this.bar = new CrumbsBar(parent, 0);
            }
        }

        public Control getControl() {
            return this.bar;
        }

        public void update() {
            boolean hasNewItems;
            boolean bl = hasNewItems = this.service != null && this.service.canDrillUp();
            if (this.barExists()) {
                List<ITopic> topics;
                this.bar.removeAllItems();
                this.bar.setRedraw(false);
                if (hasNewItems && !(topics = this.service.getCentralTopics()).isEmpty()) {
                    int i = 0;
                    while (i < topics.size()) {
                        ITopic t = topics.get(i);
                        QuickDrillUpAction action = new QuickDrillUpAction(MindMapEditorPagePanelContributor.this.getPage(), t);
                        if (i == topics.size() - 1) {
                            action.setEnabled(false);
                            action.setToolTipText(NLS.bind((String)MindMapMessages.BreadCrumb_CurrentCentral_text, (Object)action.newCentralTopic.getTitleText()));
                        }
                        this.bar.addItem(new CrumbItem((IAction)action));
                        if (i < topics.size() - 1) {
                            this.bar.addItem(new CrumbItem());
                        }
                        ++i;
                    }
                }
                this.bar.setRedraw(true);
                this.setVisible(hasNewItems);
            }
        }

        private boolean barExists() {
            return this.bar != null && !this.bar.isDisposed();
        }

        public void traceChanged(IDrillDownTraceService traceService) {
            this.update();
        }

        public void setTraceService(IDrillDownTraceService service) {
            if (service == this.service) {
                return;
            }
            if (this.service != null) {
                this.service.removeTraceListener(this);
            }
            this.service = service;
            if (service != null) {
                service.addTraceListener(this);
            }
            this.update();
        }

        private class QuickDrillUpAction
        extends PageAction {
            private ITopic newCentralTopic;

            public QuickDrillUpAction(IGraphicalEditorPage page, ITopic topic) {
                super(page);
                this.newCentralTopic = topic;
                String title = topic.getTitleText();
                this.setText(title);
                this.setToolTipText(NLS.bind((String)MindMapMessages.BreadCrumb_ViewAsCentral_text, (Object)title));
                this.setImageDescriptor(MindMapUtils.getImageDescriptor(topic));
            }

            public void run() {
                ISheet sheet;
                super.run();
                IGraphicalViewer viewer = this.getViewer();
                if (viewer != null && (sheet = (ISheet)viewer.getAdapter(ISheet.class)) != null) {
                    MindMap newInput = new MindMap(sheet, this.newCentralTopic);
                    viewer.setInput((Object)newInput);
                    if (viewer.getEditDomain() != null) {
                        viewer.getEditDomain().handleRequest("select central", (IViewer)viewer);
                    }
                }
            }
        }
    }

    private static class CrumbsBar
    extends Composite {
        private static final int SPACING = 1;
        private List<CrumbItem> items = new ArrayList<CrumbItem>();

        public CrumbsBar(Composite parent, int style) {
            super(parent, style);
            CrumbsBarListener eventHandler = new CrumbsBarListener();
            this.addPaintListener(eventHandler);
            this.addMouseListener(eventHandler);
            this.addMouseMoveListener(eventHandler);
            this.addMouseTrackListener(eventHandler);
            this.addControlListener(eventHandler);
            this.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-1));
        }

        private void releaseItems() {
            for (CrumbItem item : this.items) {
                item.releaseResources();
            }
        }

        protected void redraw(CrumbItem item) {
            this.checkWidget();
            Rectangle r = item.getBounds();
            this.redraw(r.x, r.y, r.width, r.height, false);
        }

        public void addItem(CrumbItem item) {
            this.checkWidget();
            this.addItem(item, -1);
        }

        public void addItem(CrumbItem item, int index) {
            this.checkWidget();
            this.items.remove(item);
            if (index < 0) {
                this.items.add(item);
            } else {
                this.items.add(index, item);
            }
            this.itemAdded(item);
        }

        public void removeItem(CrumbItem item) {
            this.checkWidget();
            this.items.remove(item);
            this.itemRemoved(item);
        }

        private void itemAdded(CrumbItem item) {
            item.setParent(this);
            this.layout();
        }

        private void itemRemoved(CrumbItem item) {
            item.setParent(null);
            item.releaseResources();
            this.layout();
        }

        public void removeAllItems() {
            this.checkWidget();
            this.setRedraw(false);
            CrumbItem[] oldItems = this.getItems();
            this.items.clear();
            CrumbItem[] crumbItemArray = oldItems;
            int n = oldItems.length;
            int n2 = 0;
            while (n2 < n) {
                CrumbItem item = crumbItemArray[n2];
                this.itemRemoved(item);
                ++n2;
            }
            this.layout();
            this.setRedraw(true);
        }

        public CrumbItem[] getItems() {
            this.checkWidget();
            return this.items.toArray(new CrumbItem[this.items.size()]);
        }

        public CrumbItem findItem(Point p) {
            this.checkWidget();
            return this.findItem(p.x, p.y);
        }

        public CrumbItem findItem(int x, int y) {
            this.checkWidget();
            for (CrumbItem item : this.items) {
                Rectangle r = item.getBounds();
                if (!r.contains(x, y)) continue;
                return item;
            }
            return null;
        }

        public void setLayout(Layout layout) {
        }

        public void layout(boolean changed) {
            this.updateLayout();
        }

        public void layout(boolean changed, boolean all) {
            this.updateLayout();
        }

        protected void updateLayout() {
            this.checkWidget();
            Point p = new Point(0, 0);
            int h = this.getSize().y;
            for (CrumbItem item : this.items) {
                Point s = item.getPrefSize();
                Rectangle r = new Rectangle(p.x, p.y + (h - s.y) / 2, s.x, s.y);
                item.setBounds(r);
                p.x += s.x + 1;
            }
            this.redraw();
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            this.checkWidget();
            if (wHint >= 0 && hHint >= 0) {
                return new Point(wHint, hHint);
            }
            Point size = new Point(0, 0);
            if (wHint >= 0) {
                size.x = wHint;
            }
            for (CrumbItem item : this.items) {
                Point s = item.getPrefSize();
                if (wHint < 0) {
                    if (size.x > 0) {
                        ++size.x;
                    }
                    size.x += s.x;
                }
                size.y = Math.max(size.y, s.y);
            }
            return size;
        }

        private class CrumbsBarListener
        implements PaintListener,
        MouseListener,
        MouseMoveListener,
        MouseTrackListener,
        ControlListener,
        DisposeListener {
            private CrumbItem sourceItem = null;
            private CrumbItem targetItem = null;

            private CrumbsBarListener() {
            }

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                if (!"carbon".equals(SWT.getPlatform())) {
                    gc.setBackground(e.display.getSystemColor(22));
                    gc.fillRectangle(CrumbsBar.this.getBounds());
                }
                Rectangle clipping = gc.getClipping();
                for (CrumbItem item : CrumbsBar.this.items) {
                    if (!clipping.intersects(item.getBounds())) continue;
                    item.paint(gc);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                CrumbItem item = CrumbsBar.this.findItem(e.x, e.y);
                if (item != null && item.isEnabled() && !item.isSeparator()) {
                    this.sourceItem = item;
                    item.setPressed(true);
                }
            }

            public void mouseUp(MouseEvent e) {
                CrumbItem item = CrumbsBar.this.findItem(e.x, e.y);
                CrumbItem source = this.sourceItem;
                if (this.sourceItem != null) {
                    this.sourceItem.setPressed(false);
                    this.sourceItem = null;
                }
                if (item != null && item == source) {
                    item.run();
                }
            }

            private void receiveTarget(int x, int y) {
                CrumbItem item = CrumbsBar.this.findItem(x, y);
                if (item != this.targetItem) {
                    IAction action;
                    if (this.targetItem != null && this.targetItem.isEnabled() && !this.targetItem.isSeparator()) {
                        this.targetItem.setMouseOver(false);
                    }
                    this.targetItem = item;
                    if (item != null && item.isEnabled() && !item.isSeparator() && (this.sourceItem == null || item == this.sourceItem)) {
                        item.setMouseOver(true);
                    }
                    String tooltip = null;
                    if (this.targetItem != null && (action = this.targetItem.getAction()) != null) {
                        tooltip = action.getToolTipText();
                    }
                    CrumbsBar.this.setToolTipText(tooltip);
                }
            }

            public void mouseMove(MouseEvent e) {
                this.receiveTarget(e.x, e.y);
            }

            public void mouseEnter(MouseEvent e) {
                this.receiveTarget(e.x, e.y);
            }

            public void mouseExit(MouseEvent e) {
                this.receiveTarget(e.x, e.y);
            }

            public void mouseHover(MouseEvent e) {
                this.receiveTarget(e.x, e.y);
            }

            public void controlMoved(ControlEvent e) {
                CrumbsBar.this.updateLayout();
            }

            public void controlResized(ControlEvent e) {
                CrumbsBar.this.updateLayout();
            }

            public void widgetDisposed(DisposeEvent e) {
                CrumbsBar.this.releaseItems();
            }
        }
    }
}

