/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dnd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.IFileEntry;
import org.xmind.core.IManifest;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.dnd.DndData;
import org.xmind.gef.dnd.IDndClient;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.part.IPart;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyImageSizeCommand;
import org.xmind.ui.commands.ModifyImageSourceCommand;
import org.xmind.ui.mindmap.IMindMapDndClient;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.util.ImageFormat;
import org.xmind.ui.util.Logger;

public class FileDndClient
implements IDndClient,
IMindMapDndClient {
    private FileTransfer transfer = FileTransfer.getInstance();

    public Object getData(Transfer transfer, TransferData data) {
        if (transfer == this.transfer) {
            return this.transfer.nativeToJava(data);
        }
        return null;
    }

    public Transfer getTransfer() {
        return this.transfer;
    }

    public Object toTransferData(Object[] viewerElements, IViewer viewer) {
        return null;
    }

    public Object[] toViewerElements(Object transferData, IViewer viewer, Object target) {
        if (transferData instanceof String[]) {
            String[] paths = (String[])transferData;
            IWorkbook workbook = (IWorkbook)viewer.getAdapter(IWorkbook.class);
            if (workbook != null) {
                return this.buildTopics(workbook, paths);
            }
        }
        return null;
    }

    private Object[] buildTopics(IWorkbook wb, String[] paths) {
        IManifest manifest = wb.getManifest();
        ArrayList<ITopic> topics = new ArrayList<ITopic>(paths.length);
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                IFileEntry entry;
                String path = stringArray[n2];
                try {
                    entry = manifest.createAttachmentFromFilePath(path);
                }
                catch (IOException e) {
                    Logger.log(e, "Error occurred when transfering file: " + path);
                    break block3;
                }
                ITopic topic = wb.createTopic();
                topic.setTitleText(new File(path).getName());
                topic.setHyperlink(HyperlinkUtils.toAttachmentURL((String)entry.getPath()));
                topics.add(topic);
            }
            ++n2;
        }
        return topics.toArray();
    }

    public boolean handleRequest(Request request, DndData dndData) {
        String[] paths;
        if (dndData.parsedData instanceof String[] && this.isSingleImage(paths = (String[])dndData.parsedData)) {
            ITopic topic;
            IFileEntry entry;
            String path = paths[0];
            IPart target = request.getPrimaryTarget();
            if (target != null && target.equals(request.getParameter("parent")) && target instanceof ITopicPart && (entry = this.createAttachmentEntry(topic = ((ITopicPart)target).getTopic(), path)) != null) {
                this.addImage(request, topic, entry, path);
                return true;
            }
        }
        return false;
    }

    private void addImage(Request request, ITopic topic, IFileEntry entry, String path) {
        ModifyImageSourceCommand command = new ModifyImageSourceCommand(topic, HyperlinkUtils.toAttachmentURL((String)entry.getPath()));
        Dimension size = this.getImageSize(path);
        if (size != null) {
            ModifyImageSizeCommand modifySize = new ModifyImageSizeCommand(topic, size.width, size.height);
            command = new CompoundCommand(new Command[]{command, modifySize});
        }
        command.setLabel(CommandMessages.Command_InsertImage);
        request.getTargetCommandStack().execute((Command)command);
    }

    private IFileEntry createAttachmentEntry(ITopic topic, String path) {
        try {
            return topic.getOwnedWorkbook().getManifest().createAttachmentFromFilePath(path);
        }
        catch (IOException e) {
            Logger.log(e, "Error occurred when transfering file: " + path);
            return null;
        }
    }

    private boolean isSingleImage(String[] paths) {
        if (paths.length == 1) {
            String path = paths[0];
            String ext = FileUtils.getExtension((String)path);
            return ImageFormat.findByExtension((String)ext, null) != null;
        }
        return false;
    }

    private Dimension getImageSize(String path) {
        try {
            Image tempImage = new Image((Device)Display.getCurrent(), path);
            Rectangle imageBounds = tempImage.getBounds();
            tempImage.dispose();
            return Geometry.getScaledConstrainedSize((int)imageBounds.width, (int)imageBounds.height, (int)400, (int)400);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

