/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.internal.decorations.SegmentedBoundaryDecoration;

public class WavesBoundaryDecoration
extends SegmentedBoundaryDecoration {
    private static final float c = 0.5f;
    private static final float c1 = 0.125f;
    private static final float c2 = 0.375f;
    private static final float c3 = 0.625f;
    private static final float c4 = 0.875f;

    public WavesBoundaryDecoration() {
    }

    public WavesBoundaryDecoration(String id) {
        super(id);
    }

    protected float getMarginAmount() {
        return 0.25f;
    }

    protected float getPreferredVerticalStep() {
        return super.getPreferredVerticalStep() * 0.9f;
    }

    protected void sketchBottomSegment(IFigure figure, Path shape, float x, float y, float bottom, int index) {
        shape.cubicTo(x - this.hstep * 0.125f, bottom, x - this.hstep * 0.375f, bottom, x - this.hstep * 0.5f, y);
        shape.cubicTo(x - this.hstep * 0.625f, y - (bottom - y), x - this.hstep * 0.875f, y - (bottom - y), x - this.hstep, y);
    }

    protected void sketchLeftSegment(IFigure figure, Path shape, float x, float y, float left, int index) {
        shape.cubicTo(left, y - this.vstep * 0.125f, left, y - this.vstep * 0.375f, x, y - this.vstep * 0.5f);
        shape.cubicTo(x + (x - left), y - this.vstep * 0.625f, x + (x - left), y - this.vstep * 0.875f, x, y - this.vstep);
    }

    protected void sketchRightSegment(IFigure figure, Path shape, float x, float y, float right, int index) {
        shape.cubicTo(right, y + this.vstep * 0.125f, right, y + this.vstep * 0.375f, x, y + this.vstep * 0.5f);
        shape.cubicTo(x - (right - x), y + this.vstep * 0.625f, x - (right - x), y + this.vstep * 0.875f, x, y + this.vstep);
    }

    protected void sketchTopSegment(IFigure figure, Path shape, float x, float y, float top, int index) {
        shape.cubicTo(x + this.hstep * 0.125f, top, x + this.hstep * 0.375f, top, x + this.hstep * 0.5f, y);
        shape.cubicTo(x + this.hstep * 0.625f, y + (y - top), x + this.hstep * 0.875f, y + (y - top), x + this.hstep, y);
    }

    public Insets getPreferredInsets(IFigure figure, int width, int height) {
        return Geometry.add((Insets)super.getPreferredInsets(figure, width, height), (int)10);
    }
}

