/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.decoration.ICorneredDecoration;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.internal.decorations.ElbowBranchConnection;

public class RoundedElbowBranchConnection
extends ElbowBranchConnection
implements ICorneredDecoration {
    private static final float CORNER_CONTROL_RATIO = 0.448f;
    private static final PrecisionPoint sc = new PrecisionPoint();
    private static final PrecisionPoint tc = new PrecisionPoint();
    private static final PrecisionPoint scc = new PrecisionPoint();
    private static final PrecisionPoint tcc = new PrecisionPoint();
    private int cornerSize = 0;

    public RoundedElbowBranchConnection() {
    }

    public RoundedElbowBranchConnection(String id) {
        super(id);
    }

    protected void route(IFigure figure, Path shape) {
        PrecisionPoint sp = this.getSourcePosition(figure);
        PrecisionPoint tp = this.getTargetPosition(figure);
        if (this.isTapered()) {
            if (this.horizontal || this.vertical) {
                if (this.horizontal && this.vertical) {
                    shape.moveTo(sp);
                    shape.lineTo((float)sp.x, (float)tp.y);
                    shape.lineTo(tp);
                    shape.lineTo((float)tp.x, (float)sp.y);
                    shape.close();
                } else {
                    shape.moveTo(this.s1);
                    shape.lineTo(this.t1);
                    shape.lineTo(this.t2);
                    shape.lineTo(this.s2);
                    shape.close();
                }
            } else {
                shape.moveTo(this.s1);
                sc.setLocation(this.s1);
                tc.setLocation(this.t1);
                this.calculateCorners(this.s1, this.t1, sc, tc, this.getCornerSize());
                if (!sc.equals((Object)this.s1)) {
                    shape.lineTo(sc);
                }
                shape.cubicTo(scc.setLocation(this.e1).move(sc, (double)0.448f), tcc.setLocation(this.e1).move(tc, (double)0.448f), tc);
                if (!tc.equals((Object)this.t1)) {
                    shape.lineTo(this.t1);
                }
                shape.lineTo(this.t2);
                sc.setLocation(this.s2);
                tc.setLocation(this.t2);
                this.calculateCorners(this.s2, this.t2, sc, tc, this.getCornerSize());
                if (!tc.equals((Object)this.t2)) {
                    shape.lineTo(tc);
                }
                shape.cubicTo(tcc.setLocation(this.e2).move(tc, (double)0.448f), scc.setLocation(this.e2).move(sc, (double)0.448f), sc);
                if (!sc.equals((Object)this.s2)) {
                    shape.lineTo(this.s2);
                }
                shape.close();
            }
        } else {
            shape.moveTo(sp);
            sc.setLocation(sp);
            tc.setLocation(tp);
            this.calculateCorners(sp, tp, sc, tc, this.getCornerSize());
            if (!sc.equals((Object)sp)) {
                shape.lineTo(sc);
            }
            shape.cubicTo(scc.setLocation(this.elbow).move(sc, (double)0.448f), tcc.setLocation(this.elbow).move(tc, (double)0.448f), tc);
            if (!tc.equals((Object)tp)) {
                shape.lineTo(tp);
            }
        }
    }

    private void calculateCorners(PrecisionPoint sp, PrecisionPoint tp, PrecisionPoint sourceCorner, PrecisionPoint targetCorner, double corner) {
        double width = Math.abs(sp.x - tp.x);
        double height = Math.abs(tp.y - sp.y);
        if (this.isTargetHorizontal()) {
            if (corner >= 0.0 && corner <= height) {
                double y = tp.y > sp.y ? tp.y - corner : tp.y + corner;
                sourceCorner.setLocation(sp.x, y);
            }
            if (corner >= 0.0 && corner <= width) {
                double x = sp.x > tp.x ? sp.x - corner : sp.x + corner;
                targetCorner.setLocation(x, tp.y);
            }
        } else {
            if (corner >= 0.0 && corner <= width) {
                double x = tp.x > sp.x ? tp.x - corner : tp.x + corner;
                sourceCorner.setLocation(x, sp.y);
            }
            if (corner >= 0.0 && corner <= height) {
                double y = sp.y > tp.y ? sp.y - corner : sp.y + corner;
                targetCorner.setLocation(tp.x, y);
            }
        }
    }

    public int getCornerSize() {
        return this.cornerSize;
    }

    public void setCornerSize(IFigure figure, int cornerSize) {
        if (cornerSize == this.cornerSize) {
            return;
        }
        this.cornerSize = cornerSize;
        if (figure != null) {
            figure.revalidate();
            figure.repaint();
        }
        this.invalidate();
    }
}

