/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.decorations.AbstractTopicDecoration;

public class DiamondTopicDecoration
extends AbstractTopicDecoration {
    public DiamondTopicDecoration() {
    }

    public DiamondTopicDecoration(String id) {
        super(id);
    }

    protected void sketch(IFigure figure, Path shape, Rectangle box, int purpose) {
        float cx = (float)box.x + (float)box.width * 0.5f;
        float cy = (float)box.y + (float)box.height * 0.5f;
        shape.moveTo(cx, (float)box.y);
        shape.lineTo((float)box.right(), cy);
        shape.lineTo(cx, (float)box.bottom());
        shape.lineTo((float)box.x, cy);
        shape.close();
    }

    public PrecisionPoint getAnchorLocation(IFigure figure, double refX, double refY, double expansion) {
        Rectangle r = this.getOutlineBox(figure);
        double w = (double)r.width * 0.5;
        double h = (double)r.height * 0.5;
        double cx = (double)r.x + w;
        double cy = (double)r.y + h;
        double px = refX - cx;
        double py = refY - cy;
        if (px == 0.0) {
            return new PrecisionPoint(refX, py > 0.0 ? cy + h : cy - h);
        }
        if (py == 0.0) {
            return new PrecisionPoint(px > 0.0 ? cx + w : cx - w, refY);
        }
        double x = 0.0;
        double y = 0.0;
        Insets ins = figure.getInsets();
        if (Math.abs(h * px) == Math.abs(w * py)) {
            x = px * (w - (double)ins.left) / Math.abs(px);
            y = py * (h - (double)ins.bottom) / Math.abs(py);
        } else if (px > 0.0 && py < 0.0) {
            x = h * w * px / (h * px - w * py);
            y = h * w * py / (h * px - w * py);
        } else if (px > 0.0 && py > 0.0) {
            x = h * w * px / (h * px + w * py);
            y = h * w * py / (h * px + w * py);
        } else if (px < 0.0 && py > 0.0) {
            x = h * w * px / (w * py - h * px);
            y = h * w * py / (w * py - h * px);
        } else if (px < 0.0 && py < 0.0) {
            x = -(h * w * px) / (h * px + w * py);
            y = -(h * w * py) / (h * px + w * py);
        }
        return new PrecisionPoint(x + cx, y + cy);
    }

    public Insets getPreferredInsets(IFigure figure, int width, int height) {
        double w = (double)width * 0.5;
        double h = (double)height * 0.5;
        double d = Math.sqrt(h * w);
        int m = (int)Math.round(d) + 1;
        return new Insets(m + this.getLineWidth());
    }
}

