/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.decoration.AbstractDecoration;
import org.xmind.gef.draw2d.decoration.IShadowedDecoration;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.ui.decorations.IBranchConnections;
import org.xmind.ui.decorations.IBranchDecoration;
import org.xmind.ui.mindmap.IBranchPart;

public class DefaultBranchDecoration
extends AbstractDecoration
implements IBranchDecoration,
IShadowedDecoration {
    private IBranchPart branch;

    public DefaultBranchDecoration(IBranchPart branch) {
        this(branch, "org.xmind.branchDecoration.default");
    }

    public DefaultBranchDecoration(IBranchPart branch, String id) {
        super(id);
        this.branch = branch;
    }

    protected void performPaint(IFigure figure, Graphics graphics) {
        this.paintExpandedLine(graphics, false);
    }

    private void paintExpandedLine(Graphics graphics, boolean paintingShadow) {
        IBranchConnections connections = this.branch.getConnections();
        if (connections == null || connections.isEmpty() || !connections.isVisible()) {
            return;
        }
        int orientation = connections.getSourceOrientation();
        if (orientation == 0) {
            return;
        }
        IAnchor anc = connections.getSourceAnchor();
        if (anc == null) {
            return;
        }
        PrecisionPoint p1 = anc.getLocation(orientation, 0.0);
        PrecisionPoint p2 = anc.getLocation(orientation, (double)connections.getSourceExpansion());
        graphics.setLineStyle(connections.getLineStyle());
        graphics.setLineWidth(connections.getLineWidth());
        if (!paintingShadow) {
            graphics.setForegroundColor(connections.getLineColor());
        }
        graphics.setAlpha(connections.getAlpha());
        org.xmind.gef.draw2d.graphics.Path p = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        p.moveTo(p1);
        p.lineTo(p2);
        graphics.drawPath((Path)p);
        p.dispose();
    }

    public void paintAboveChildren(IFigure figure, Graphics graphics) {
    }

    public void paintShadow(IFigure figure, Graphics graphics) {
        graphics.setForegroundColor(ColorConstants.black);
        this.paintExpandedLine(graphics, true);
    }
}

