/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.xmind.ui.branch.IBranchStyleValueProvider;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.util.Logger;

public class ContributedStyleValueProvider
implements IBranchStyleValueProvider {
    private IConfigurationElement element;
    private String id;
    private IBranchStyleValueProvider contributor;
    private boolean triedLoadingContributor;

    public ContributedStyleValueProvider(IConfigurationElement element) throws CoreException {
        this.element = element;
        this.id = element.getAttribute("id");
        if (RegistryReader.getClassValue((IConfigurationElement)element, (String)"class") == null) {
            throw new CoreException((IStatus)new Status(4, element.getNamespaceIdentifier(), 0, "Invalid extension (missing class name): " + this.id, null));
        }
    }

    public String getId() {
        return this.id;
    }

    public String getValue(IBranchPart branch, String layerName, String key) {
        IBranchStyleValueProvider cont = this.getContributor();
        if (cont != null) {
            return cont.getValue(branch, layerName, key);
        }
        return null;
    }

    private IBranchStyleValueProvider getContributor() {
        if (this.contributor == null && !this.triedLoadingContributor) {
            try {
                this.contributor = (IBranchStyleValueProvider)this.element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                Logger.log(e, "Failed to create style value provider: " + this.id);
            }
            this.triedLoadingContributor = true;
        }
        return this.contributor;
    }
}

