/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.AbstractBranchStructure;
import org.xmind.ui.branch.IFreeableBranchStructureExtension;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.branch.ILockableBranchStructureExtension;
import org.xmind.ui.branch.Insertion;
import org.xmind.ui.internal.branch.RadialData;
import org.xmind.ui.internal.branch.RadialStructure;
import org.xmind.ui.internal.branch.RadialUtils;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IBranchRangePart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.tools.ParentSearchKey;
import org.xmind.ui.util.MindMapUtils;

public abstract class BaseRadialStructure
extends AbstractBranchStructure
implements ILockableBranchStructureExtension,
IFreeableBranchStructureExtension {
    public static final String CACHE_NUMBER_RIGHT_BRANCHES = String.valueOf(RadialStructure.class.getName()) + ".numberRightBranches";
    public Set<IBranchPart> calculatingBranches = new HashSet<IBranchPart>();

    protected boolean isValidStructureData(IBranchPart branch, Object data) {
        return super.isValidStructureData(branch, data) && data instanceof RadialData;
    }

    protected Object createStructureData(IBranchPart branch) {
        return new RadialData(branch);
    }

    protected RadialData getRadialData(IBranchPart branch) {
        return (RadialData)this.getStructureData(branch);
    }

    public boolean isChildLeft(IBranchPart branch, IBranchPart child) {
        Point pos;
        if (branch.isCentral() && (pos = (Point)MindMapUtils.getCache((IPart)child, "org.xmind.ui.cache.preferredPosition")) != null) {
            return RadialUtils.isLeft(0, pos.x);
        }
        if (this.calculatingBranches.contains(branch)) {
            return false;
        }
        this.calculatingBranches.add(branch);
        int index = branch.getSubBranches().indexOf(child);
        boolean left = index >= 0 ? index >= this.getRadialData(branch).getNumRight() : (branch.getSummaryBranches().contains(child) ? this.isSummaryChildLeft(branch, child) : RadialUtils.isLeft(this.getReference((IBranchPart)branch).x, this.getReference((IBranchPart)child).x));
        this.calculatingBranches.remove(branch);
        return left;
    }

    public boolean isSummaryChildLeft(IBranchPart branch, IBranchPart child) {
        ISummaryPart summary = MindMapUtils.findAttachedSummary(branch, child);
        if (summary != null) {
            int direction = this.getSummaryDirection(branch, summary);
            return direction == 8;
        }
        return false;
    }

    public int getSummaryDirection(IBranchPart branch, ISummaryPart summary) {
        IBranchPart subBranch;
        int index;
        List<IBranchPart> enclosingBranches = summary.getEnclosingBranches();
        if (!enclosingBranches.isEmpty() && (index = (subBranch = enclosingBranches.get(0)).getBranchIndex()) >= 0 && index >= this.getRadialData(branch).getNumRight()) {
            return 8;
        }
        return 16;
    }

    public int getRangeGrowthDirection(IBranchPart branch, IBranchRangePart range) {
        return 4;
    }

    public Point getReference(IBranchPart branch) {
        ITopicPart topic = branch.getTopicPart();
        if (topic != null) {
            return ((IReferencedFigure)topic.getFigure()).getReference();
        }
        return ((IReferencedFigure)branch.getFigure()).getReference();
    }

    protected void doFillPlusMinus(IBranchPart branch, IPlusMinusPart plusMinus, AbstractBranchStructure.LayoutInfo info) {
        Point ref = info.getReference();
        IFigure fig = plusMinus.getFigure();
        Rectangle topicBounds = info.getCheckedClientArea();
        Dimension pmSize = fig.getPreferredSize();
        int pmx = ref.x - pmSize.width / 2;
        int pmy = topicBounds.bottom();
        Rectangle pmBounds = new Rectangle(pmx, pmy, pmSize.width, pmSize.height);
        info.put(fig, pmBounds);
    }

    protected Dimension getOffset(IBranchPart subBranch) {
        Point pos = (Point)MindMapUtils.getCache((IPart)subBranch, "org.xmind.ui.cache.preferredPosition");
        if (pos != null) {
            return new Dimension(pos.x, pos.y);
        }
        return null;
    }

    public IPart calcNavigation(IBranchPart branch, String navReqType) {
        int numSecond;
        if ("navigate right".equals(navReqType)) {
            if (!branch.getSubBranches().isEmpty()) {
                return this.getSubTopicPart(branch, 0);
            }
        } else if ("navigate left".equals(navReqType) && (numSecond = this.getRadialData(branch).getNumLeft()) > 0) {
            int numFirst = this.getRadialData(branch).getNumRight();
            return this.getSubTopicPart(branch, numFirst);
        }
        return super.calcNavigation(branch, navReqType);
    }

    public int getChildTargetOrientation(IBranchPart branch, IBranchPart subBranch) {
        return this.isChildLeft(branch, subBranch) ? 16 : 8;
    }

    public int getSourceOrientation(IBranchPart branch) {
        return 0;
    }

    public boolean isChildrenFreeable(IBranchPart branch) {
        return branch.isCentral();
    }

    public int calcChildDistance(IBranchPart branch, ParentSearchKey key) {
        Point parentRef = this.getReference(branch);
        Point childRef = key.getFigure().getReference();
        Rectangle childBounds = key.getFigure().getBounds();
        Point childAnc = RadialUtils.isLeft(parentRef.x, childRef.x) ? childBounds.getRight() : childBounds.getLeft();
        int d = (int)childAnc.getDistance(parentRef);
        Dimension ovalSize = this.getRadialData(branch).getOvalSize();
        int r = Math.max(ovalSize.width, ovalSize.height);
        if (d <= r + 50) {
            return d;
        }
        if (d <= r + 300) {
            return d * d;
        }
        return super.calcChildDistance(branch, key);
    }

    public int calcChildIndex(IBranchPart branch, ParentSearchKey key) {
        return this.calcInsIndex(branch, key, false);
    }

    public IInsertion calcInsertion(IBranchPart branch, ParentSearchKey key) {
        ITopicPart topic = branch.getTopicPart();
        Point ref = topic != null ? ((IReferencedFigure)topic.getFigure()).getReference() : ((IReferencedFigure)branch.getFigure()).getReference();
        return new RadiationInsertion(branch, this.calcInsIndex(branch, key, true), this.calcInsSize(branch, key), this.calcInsSide(branch, ref, key));
    }

    public void lock(IBranchPart branch) {
        MindMapUtils.setCache((IPart)branch, CACHE_NUMBER_RIGHT_BRANCHES, this.getRadialData(branch).getNumRight());
    }

    public void unlock(IBranchPart branch) {
        MindMapUtils.flushCache((IPart)branch, CACHE_NUMBER_RIGHT_BRANCHES);
    }

    protected int calcInsIndex(IBranchPart branch, ParentSearchKey key, boolean withDisabled) {
        List<IBranchPart> subBranches = branch.getSubBranches();
        if (subBranches.isEmpty()) {
            return withDisabled ? 0 : -1;
        }
        if (branch.isFolded()) {
            return withDisabled ? 0 : -1;
        }
        ITopicPart topic = branch.getTopicPart();
        if (topic == null) {
            return withDisabled ? 0 : -1;
        }
        Point childRef = key.getFigure().getReference();
        Point ref = ((IReferencedFigure)topic.getFigure()).getReference();
        RadialData cache = this.getRadialData(branch);
        int numRight = cache.getNumRight();
        int[] childrenSpacings = cache.getChildrenSpacings();
        int num = subBranches.size();
        boolean right = true;
        Dimension insSize = this.calcInsSize(branch, key);
        int insHeight = insSize.height;
        boolean insRight = this.calcInsSide(branch, ref, key);
        int startY = ref.y;
        int y = startY - cache.getRightSumSpacing() / 2;
        if (insRight) {
            y -= insHeight / 2;
        }
        int ret = 0;
        int i = 0;
        while (i < num) {
            if (i == numRight) {
                y = startY - cache.getLeftSumSpacing() / 2;
                if (!insRight) {
                    y -= insHeight / 2;
                }
                right = false;
            }
            IBranchPart subbranch = subBranches.get(i);
            IFigure subFigure = subbranch.getFigure();
            Insets refIns = RadialUtils.getRefInsets(subFigure, right);
            int hint = y - refIns.top + (refIns.getHeight() + insHeight) / 2;
            if (i < numRight) {
                if (insRight && childRef.y < hint) {
                    return ret;
                }
                if (withDisabled || subFigure.isEnabled()) {
                    ++ret;
                }
                if (i == numRight - 1 && childRef.x > ref.x && childRef.y >= hint) {
                    return ret;
                }
            } else {
                if (!insRight && childRef.y < hint) {
                    return ret;
                }
                if (withDisabled || subFigure.isEnabled()) {
                    ++ret;
                }
            }
            y += childrenSpacings[i];
            ++i;
        }
        return withDisabled ? num : -1;
    }

    private Dimension calcInsSize(IBranchPart branch, ParentSearchKey key) {
        return key.getFigure().getSize();
    }

    private boolean calcInsSide(IBranchPart branch, Point branchRef, ParentSearchKey key) {
        Point childRef = key.getFigure().getReference();
        return childRef.x > branchRef.x;
    }

    protected RadiationInsertion getCurrentInsertion(IBranchPart branch) {
        IInsertion insertion = super.getCurrentInsertion(branch);
        return insertion instanceof RadiationInsertion ? (RadiationInsertion)insertion : null;
    }

    public int getQuickMoveOffset(IBranchPart branch, IBranchPart child, int direction) {
        if (direction == 4) {
            return 1;
        }
        if (direction == 1) {
            return -1;
        }
        return super.getQuickMoveOffset(branch, child, direction);
    }

    protected static class RadiationInsertion
    extends Insertion {
        boolean right;

        public RadiationInsertion(IBranchPart parent, int index, Dimension size, boolean right) {
            super(parent, index, size);
            this.right = right;
        }

        public void pushIn() {
            super.pushIn();
        }

        public void pullOut() {
            super.pullOut();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof RadiationInsertion)) {
                return false;
            }
            RadiationInsertion that = (RadiationInsertion)obj;
            return super.equals(obj) && this.right == that.right;
        }
    }
}

