/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.part.IPart;
import org.xmind.gef.ui.actions.ISelectionAction;
import org.xmind.gef.ui.actions.PageAction;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.internal.notes.NotesPopup;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.util.MindMapUtils;

public class EditNotesAction
extends PageAction
implements ISelectionAction {
    public EditNotesAction(IGraphicalEditorPage page) {
        super(MindMapActionFactory.EDIT_NOTES.getId(), page);
    }

    public void setSelection(ISelection selection) {
        this.setEnabled(MindMapUtils.isSingleTopic(selection));
    }

    public void run() {
        IGraphicalEditor editor = this.getEditor();
        if (editor == null) {
            return;
        }
        IWorkbenchWindow window = editor.getSite().getWorkbenchWindow();
        if (window == null) {
            return;
        }
        IGraphicalViewer viewer = this.getViewer();
        if (viewer == null) {
            return;
        }
        Control control = viewer.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        ITopicPart topicPart = this.getSelectionTopicPart(viewer);
        if (topicPart == null) {
            return;
        }
        NotesPopup popup = new NotesPopup(window, topicPart, true, true);
        popup.open();
    }

    private ITopicPart getSelectionTopicPart(IGraphicalViewer viewer) {
        IStructuredSelection ss;
        Object o;
        IPart part;
        ISelection selection = viewer.getSelection();
        if (selection instanceof IStructuredSelection && (part = viewer.findPart(o = (ss = (IStructuredSelection)selection).getFirstElement())) instanceof ITopicPart) {
            return (ITopicPart)part;
        }
        return null;
    }
}

