/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.gef.command.Command;
import org.xmind.gef.ui.actions.EditorAction;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.CreateSheetCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.editor.WorkbookEditorInput;

public class CreateSheetAction
extends EditorAction {
    public CreateSheetAction(IGraphicalEditor editor) {
        super(MindMapActionFactory.NEW_SHEET.getId(), editor);
    }

    public void run() {
        if (this.isDisposed()) {
            return;
        }
        IGraphicalEditor ed = this.getEditor();
        if (ed != null) {
            IEditorInput input;
            IWorkbook workbook = (IWorkbook)ed.getAdapter(IWorkbook.class);
            if (workbook == null && (input = ed.getEditorInput()) instanceof WorkbookEditorInput) {
                workbook = ((WorkbookEditorInput)input).getContents();
            }
            if (workbook == null) {
                return;
            }
            this.saveAndRunCreateSheetCommand(workbook);
        }
    }

    protected void saveAndRunCreateSheetCommand(IWorkbook workbook) {
        CreateSheetCommand command = new CreateSheetCommand(workbook, null);
        command.setLabel(CommandMessages.Command_CreateSheet);
        this.saveAndRun((Command)command);
        ISheet sheet = (ISheet)command.getSource();
        if (sheet != null) {
            this.decorateCreatedSheet(sheet);
        }
    }

    protected void decorateCreatedSheet(ISheet sheet) {
        sheet.setTitleText(NLS.bind((String)MindMapMessages.TitleText_Sheet, (Object)sheet.getParent().getSheets().size()));
        sheet.getRootTopic().setTitleText(MindMapMessages.TitleText_CentralTopic);
    }
}

