/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.actions.AddMarkerAction;

public class AddMarkerHandler
extends AbstractHandler {
    private static final String COMMAND_ID = "org.xmind.ui.command.addMarker";
    private static final String PARAM_MARKER_ID = "org.xmind.ui.mindmap.markerId";
    private AddMarkerAction action;
    private IHandlerActivation activation;
    private IPropertyChangeListener propertyChangeListener;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String markerId;
        if (this.action != null && (markerId = event.getParameter(PARAM_MARKER_ID)) != null) {
            try {
                this.action.runWithMarkerId(markerId);
            }
            catch (Throwable e) {
                throw new ExecutionException("Error occured while executing Add Marker command.", e);
            }
        }
        return null;
    }

    public void activate(IHandlerService service) {
        if (this.activation == null) {
            this.activation = service.activateHandler(COMMAND_ID, (IHandler)this);
        }
    }

    public void deactivate(IHandlerService service) {
        if (this.activation != null) {
            service.deactivateHandler(this.activation);
            this.activation = null;
        }
    }

    public void setActivatePage(IGraphicalEditorPage page) {
        IAction action;
        IActionRegistry actionRegistry;
        if (page != null && (actionRegistry = (IActionRegistry)page.getAdapter(IActionRegistry.class)) != null && (action = actionRegistry.getAction("org.xmind.ui.addMarker")) instanceof AddMarkerAction) {
            this.setAction((AddMarkerAction)action);
            return;
        }
        this.setAction(null);
    }

    public boolean isEnabled() {
        return this.action != null && this.action.isEnabled();
    }

    public boolean isHandled() {
        return this.action != null;
    }

    private void setAction(AddMarkerAction action) {
        if (action == this.action) {
            return;
        }
        this.unhookAction();
        boolean oldEnabled = this.isEnabled();
        boolean oldHandled = this.isHandled();
        this.action = action;
        boolean newEnabled = this.isEnabled();
        boolean newHandled = this.isHandled();
        this.hookAction();
        boolean enabledChanged = oldEnabled ^ newEnabled;
        boolean handledChanged = oldHandled ^ newHandled;
        if (enabledChanged || handledChanged) {
            this.fireHandlerChanged(new HandlerEvent((IHandler)this, enabledChanged, handledChanged));
        }
    }

    public void dispose() {
        this.unhookAction();
        super.dispose();
    }

    private void hookAction() {
        if (this.action == null) {
            return;
        }
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new IPropertyChangeListener(){

                public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String property = propertyChangeEvent.getProperty();
                    AddMarkerHandler.this.fireHandlerChanged(new HandlerEvent((IHandler)AddMarkerHandler.this, "enabled".equals(property), "handled".equals(property)));
                }
            };
        }
        this.action.addPropertyChangeListener(this.propertyChangeListener);
    }

    private void unhookAction() {
        if (this.action == null) {
            return;
        }
        if (this.propertyChangeListener != null) {
            this.action.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }
}

